/*************************************************************************
 *
 *  $RCSfile: fmtftn.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:14:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _FMTFTN_HXX
#define _FMTFTN_HXX


#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

class SwDoc;

// ATT_FTN **********************************************************

class SwFmtFtn: public SfxPoolItem
{
	friend class SwTxtFtn;
	SwTxtFtn* pTxtAttr;		//mein TextAttribut
	String  aNumber;		//Benutzerdefinierte 'Nummer'
	USHORT  nNumber;		//Automatische Nummerierung
	BOOL	bEndNote;		//Ist es eine Endnote?

	// geschuetzter CopyCtor
	SwFmtFtn& operator=(const SwFmtFtn& rFtn);
	SwFmtFtn( const SwFmtFtn& );

public:
	SwFmtFtn( BOOL bEndNote = FALSE );
	~SwFmtFtn();

	// "pure virtual Methoden" vom SfxPoolItem
	virtual int             operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	Clone( SfxItemPool* pPool = 0 ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nVer) const;
	virtual SvStream&		Store(SvStream &, USHORT nIVer) const;
	virtual USHORT			GetVersion( USHORT nFFVer ) const;

	const String &GetNumStr() const { return aNumber; }
	const USHORT &GetNumber() const { return nNumber; }
		  BOOL	  IsEndNote() const	{ return bEndNote;}

	void SetNumStr( const String& rStr )	{ aNumber = rStr; }
	void SetNumber( USHORT nNo ) 			{ nNumber = nNo; }
	void SetEndNote( BOOL b );

	void SetNumber( const SwFmtFtn& rFtn )
		{ nNumber = rFtn.nNumber; aNumber = rFtn.aNumber; }

	const SwTxtFtn *GetTxtFtn() const   { return pTxtAttr; }
		  SwTxtFtn *GetTxtFtn()	  		{ return pTxtAttr; }

	void GetFtnText( String& rStr ) const;

	// returnt den anzuzeigenden String der Fuss-/Endnote
	String GetViewNumStr( const SwDoc& rDoc, BOOL bInclStrs = FALSE ) const;
};


#endif

