/*************************************************************************
 *
 *  $RCSfile: sw3doc.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:18:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "hintids.hxx"          //Damit "unsere" Attribute angezogen werden.

#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SFXECODE_HXX //autogen
#include <svtools/sfxecode.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _TOOLS_TENCCVT_HXX //autogen
#include <tools/tenccvt.hxx>
#endif
#ifndef _SWMODULE_HXX //autogen
#include <swmodule.hxx>
#endif

#ifndef _FMTCNTNT_HXX //autogen
#include <fmtcntnt.hxx>
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif

#include "doc.hxx"
#include "docary.hxx"
#include "swrect.hxx"
#include "swerror.h"
#include "pam.hxx"
#include "fldbas.hxx"
#include "rootfrm.hxx"
#include "pagedesc.hxx"
#include "ndtxt.hxx"
#include "ndole.hxx"
#include "sw3imp.hxx"
#include "poolfmt.hxx"


extern String GetSWGVersion();

// Wird von der GUI-Seite gesetzt, wenn Layouts ignoriert werden sollen

//////////////////////////////////////////////////////////////////////////////


void lcl_sw3doc_ChgChartName( SwDoc* pDoc )
{
	// bei "alten" Dokumenten muss das an eine Tabelle gebundene
	// Chart-Object sonderbehandelt werden. Die Verbindung von
	// Tabelle zum ChartObject erfolgt weiterhin ueber den Namen,
	// aber der wird nicht mehr im FlyFormat, sondern direkt
	// beim OLE-Node gespeichert. FlyFrames koennen jetzt benannt
	// werden (Name steht im FlyFormat!)

	// durch alle Tabellen
	for( USHORT n = pDoc->GetTblFrmFmts()->Count(); n; )
	{
		const String& rTblNm = (*pDoc->GetTblFrmFmts())[ --n ]->GetName();
		for( USHORT i = pDoc->GetSpzFrmFmts()->Count(); i; )
		{
			// und durch alle Flys
			SwFmt *pFmt = (*pDoc->GetSpzFrmFmts())[ --i ];
			if( RES_FLYFRMFMT == pFmt->Which() && pFmt->GetName() == rTblNm )
			{
				const SwNodeIndex* pIdx = pFmt->GetCntnt().GetCntntIdx();
				SwOLENode* pNd;
				if( pIdx && 0 != ( pNd =
					pDoc->GetNodes()[ pIdx->GetIndex() + 1 ]->GetOLENode() ))
				{
					pNd->SetChartTblName( rTblNm );
					pFmt->SetName( pDoc->GetUniqueOLEName() );
				}
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////

// Laden eines Dokumentinhalts. Das kann ein Textbaustein oder ein
// normales Dokument sein. Die Vorlagen sind bereits eingelesen.


void Sw3IoImp::LoadDocContents( SwPaM* pPaM )
{
	// Wenn ein PaM angegeben ist, wird an einer bestimmten
	// Position eingefuegt, also ist Insert = TRUE
	short nDiff = 0;
	BYTE nInsFirstPara = 0;
	if( pPaM )
	{
		bInsert = TRUE;
		SwTxtNode *pTxtNode=pDoc->GetNodes()[pPaM->GetPoint()->nNode]->GetTxtNode();
		// Ist das ein SwPaM auf einen TextNode?
		if( !pTxtNode )
		{
			// Ist keiner, dann machen wir uns einen
			pTxtNode=pDoc->GetNodes().MakeTxtNode(pPaM->GetPoint()->nNode,
					 (SwTxtFmtColl*) pDoc->GetDfltTxtFmtColl() );
			// Da zeigt jetzt auch der StartIdx hin
			nDiff = -1;
		}
		else if( pTxtNode->GetTxt().Len() )
			nInsFirstPara = 1;
	}

	// aktuelles Passwort retten
	sal_Char cOldPass[ 16 ];
	memcpy( cOldPass, cPasswd, 16 );
	InHeader( TRUE );
	if( nFileFlags & SWGF_BAD_FILE )
	{
		Error( ERR_SWG_READ_ERROR );
		return;
	}

	BOOL bUndo = pDoc->DoesUndo();
	// Kein Undo bei neuem Dokument!
	if( !bInsert )
		pDoc->DoUndo( FALSE );

	// Auf gehts:
	BOOL bNode1 = TRUE;
	BOOL bDone = BOOL( !Good() );
	xub_StrLen nOffset = 0;
	SwNodeIndex aPos( pDoc->GetNodes().GetEndOfContent(), -1 );
	if( pPaM )
		aPos = pPaM->GetPoint()->nNode.GetIndex() + nDiff,
		nOffset = pPaM->GetPoint()->nContent.GetIndex();
	pCurPaM = pPaM;

	SwDBData aOldData(pDoc->_GetDBDesc());

	// Normales Lesen?
	while( !bDone )
	{
		BYTE cType = Peek();
		if( !Good() || pStrm->IsEof() )
			bDone = TRUE;
		else switch( cType )
		{
			case SWG_EOF:
				bDone = TRUE; break;
			case SWG_DBNAME:
				// der DatenbankName
				if( bNormal && !bInsert )
					InDBName();
				else if( bInsert &&
						 !IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
				{
					// in Versionen ohne mehrfache Datenbanken wird hier
					// der DB-Name gelesen. Warum nicht auch das
					// SQL-Statemement?
					OpenRec( SWG_DBNAME );

					// TODO: unicode: what about 0xff?
					String sStr;
					InString( *pStrm, sStr );
					SwDBData aData;
					aData.sDataSource = sStr.GetToken(0, DB_DELIM);
					aData.sCommand = sStr.GetToken(1, DB_DELIM);
					pDoc->ChgDBData( aData );

					ULONG nSaveWarn = nWarn;
					CloseRec( SWG_DBNAME );
					nWarn = nSaveWarn;
				}
				else
					SkipRec();
				break;
			case SWG_STRINGPOOL:
				InStringPool( cType, aStringPool );
				break;
			case SWG_PASSWORD:
				InPasswd(); break;
			case SWG_JOBSETUP:
				if( bNormal && !bInsert ) InJobSetup();
				else SkipRec(); break;
			case SWG_CONFIG:
				SkipRec();
				break;
			case SWG_PGPREVIEWPRTDATA:
				if( bNormal && !bInsert )
					InPagePreViewPrintData();
				else
					SkipRec();
				break;

//			case SWG_NUMRULE:
				// Der 4.0-SW kommt hier auch schon mit NumRules
				// zurecht, ignoriert sie aber. Es weiss zwar keiner
				// warum das so ist, aber wir behalten es mal lieber bei.
			case SWG_OUTLINE:
				if( bNormal && !(bInsert || bBlock) )
				{
					// Dieser Record steht nur in der 3.1 und 4.0 hier.
					// Ab der 5.0 steht er in einem eigenen Stream.
					SwNumRule* pRule = InNumRule( cType );
					if( pRule )
					{
//JP 10.03.96: und wieder alles zurueck
#if 0
						if( nVersion < SWG_DELETEOLE )
						{
							//JP 18.01.96: Alle Ueberschriften sind normalerweise
							//	ohne Kapitelnummer. Darum hier explizit abschalten
							//	weil das Default jetzt wieder auf AN ist.
							// und UeberschirftBasis ohne Einrueckung!
							SwTxtFmtColl* pCol = pDoc->GetTxtCollFromPool(
												RES_POOLCOLL_HEADLINE_BASE );
							pCol->ResetAttr( RES_LR_SPACE );

							for( short i = 0; i < MAXLEVEL; i++ )
							{
								if( !pRule->GetNumFmt( i ) )
								{
									SwNumFmt aFmt( pRule->Get( i ) );
									aFmt.eType = NUMBER_NONE;
									pRule->Set( i, aFmt );
								}
							}
						}
#endif
						pDoc->SetOutlineNumRule( *pRule );
					}
					delete pRule;
				}
				else
				{
					SkipRec();
				}
				break;
			case SWG_MACROTBL:
				if( bNormal ) InMacroTbl(); else SkipRec();
				break;
			case SWG_DICTIONARY:
				if( bNormal && IsVersion( SWG_DESKTOP40 ) )
					InDictionary();
				else
					SkipRec();
				break;
			case SWG_FIELDTYPE:
				if( bNormal ) InFieldType(); else SkipRec();
				break;
			case SWG_FLYFRAMES:
				if( bNormal ) InFlyFrames(); else SkipRec();
				break;
			case SWG_FOOTINFO:
				// globale Fussnoten-Info
				if( bNormal && !(bInsert || bBlock) )
					InFtnInfo();
				else
					SkipRec();
				break;
			case SWG_ENDNOTEINFO:
				// globale Endnoten-Info
				if( bNormal && !(bInsert || bBlock) )
					InEndNoteInfo();
				else
					SkipRec();
				break;
			case SWG_LINENUMBERINFO:
				// Zeilennumer-Info
				if( bNormal && !(bInsert || bBlock) )
					InLineNumberInfo();
				else
					SkipRec();
				break;
			case SWG_TOXDESCS51:
				if( !IsVersion(SWG_NEWTOX) )
					InTOXs51();
				else
					SkipRec();
				break;
			case SWG_TOXDESCS:
				ASSERT( IsVersion(SWG_NEWTOX),
						"new tox descs within a old doc" );
				InTOXs();
				break;
			case SWG_BOOKMARKS:
				InBookmarks();
				break;
			case SWG_REDLINES:
				InRedlines();
				break;
			case SWG_CONTENTS:
				if( bNormal )
					InContents( aPos, nOffset, bNode1, nInsFirstPara );
				else
					SkipRec();
				bNode1 = FALSE; nOffset = 0;
				nInsFirstPara = 0;
				break;
			case SWG_DOCSTAT:
				if( bNormal && !bInsert )
					InDocStat();
				else
					SkipRec();
				break;
			case SWG_NUMBERFORMATTER:
				InNumberFormatter();
				break;
			case SWG_DOCDUMMIES:
				if( bNormal && !bInsert )
					InDocDummies();
				else
					SkipRec();
				break;
			case SWG_LAYOUTINFO:
				SkipRec();
				break;

#ifdef TEST_HUGE_DOCS
			case SWG_TESTHUGEDOCS:
				InHugeRecord();
#endif
			default:
				SkipRec();
		}
	}

	// Insert TOXs if not done this already.
	ConnectPageDescAttrs();
	ConnectTOXs();

	Cleanup( FALSE );

	if( !IsVersion(SWG_LONGIDX) && pCurNumRange )
		CloseNumRange40( aPos );

	if( bInsert && !IsVersion( SWG_MULTIDB, SWG_EXPORT31, SWG_DESKTOP40 ) )
		pDoc->ChgDBData( aOldData );

	pDoc->DoUndo( bUndo );
	if( !nRes )
	{
		if( bNormal )
		{
			// Neues Doc gelesen
			if( !bInsert )
			{
				// bei "alten" Dokumenten muss das an eine Tabelle gebundene
				// Chart-Object sonderbehandelt werden. Die Verbindung von
				// Tabelle zum ChartObject erfolgt weiterhin ueber den Namen,
				// aber der wird nicht mehr im FlyFormat, sondern direkt
				// beim OLE-Node gespeichert. FlyFrames koennen jetzt benannt
				// werden (Name steht im FlyFormat!)
				if( nVersion < SWG_OLENAME && pDoc->GetTblFrmFmts()->Count() &&
					pDoc->GetSpzFrmFmts()->Count() )
						::lcl_sw3doc_ChgChartName( pDoc );

				pDoc->SetLoaded( TRUE );
			}
		}
		else
		{
			// Nachladen von Vorlagen etc.
			// falls wir die OutlineLevel veraendert haben (Vorlagen geladen),
			// dann muss am Doc ein Update auf die neuen Nummern erfolgen !!
			if( !bAdditive && pDoc->GetOutlineNumRule() )
				pDoc->SetOutlineNumRule( *pDoc->GetOutlineNumRule() );
			pDoc->SetModified();
		}
	}
	pDoc->SetNewDoc( FALSE );
	if ( nVersion < SWG_OLEVIS2PAGE )
	{
		//Bei alten Dokumenten schaetzen wir: Wenn die Standardpage
		//Seitenraender von 0 hat, so wirds wohl ein Ole sein.
		//MA: Ole wird jetzt per Browse dargestellt.
		SwPageDesc &rDesc = pDoc->_GetPageDesc( 0 );
		const SvxLRSpaceItem &rLR = rDesc.GetMaster().GetLRSpace();
		if ( !rLR.GetLeft() && !rLR.GetRight() )
			pDoc->SetBrowseMode( TRUE );
	}
}


// Doc-Header
// SWG_COMMENT		Build des Writers (opt.)
// SWG_STRINGPOOL	Stringpool
// SWG_PASSWORD 	Passwort fuer Bereiche (opt.)
// SWG_OUTLINE		Outline-Numerierung (nicht bei Textbausteinen)
// SWG_NUMRULE		Default-Numerierung (nicht bei Textbausteinen)
// SWG_MACROTBL 	Makro-Tabelle (nicht bei Textbausteinen)
// SWG_DICTIONARY	Woerterbuecher des Onlinespellings
// SWG_FOOTINFO 	globale Funoten-Infos (nicht bei Textbausteinen)
// SWG_FLYFRAMES	Seitengebundene Frames (nicht bei Textbausteinen)
// SWG_FIELDTYPES	Feldtypen
// SWG_TOXDESCS 	Verzeichnisbereiche
// SWG_BOOKMARKS	Bookmarks
// SWG_CONTENTS 	Dokumentinhalt
// SWG_FRAMEINFO	Layout-Frames
// SWG_STRINGPOOL	Liste aller Namen von embedded-Grafiken
// SWG_JOBSETUP 	Job-Setup (nicht bei Textbausteinen)
// SWG_EOF			Streamende

void Sw3IoImp::SaveDocContents( SwPaM& rPaM, const String* pBlockName )
{
	if( pBlockName )
		bBlock = TRUE, aBlkName = *pBlockName;
	OutHeader();
	// Alle FlyFrames am Doc sammeln
	CollectFlyFrms( &rPaM );
	aStringPool.Setup( *pDoc, pStrm->GetVersion(), pExportInfo );
	// Ausgabe des Versions-Textes, falls vorhanden
	String aVersion = GetSWGVersion();
	if( aVersion.Len() )
	{
		ByteString sTmp( aVersion, eSrcSet );
		OpenRec( SWG_COMMENT );
		*pStrm << sTmp.GetBuffer();
		CloseRec( SWG_COMMENT );
	}
	// der DatenbankName
	OutDBName();

	// Der String-Pool
	OutStringPool( SWG_STRINGPOOL, aStringPool );
	if( !bBlock )
	{
		if( !nRes )
		{
			aStat.Reset();
			aStat.nPara = 0;			// default ist auf 1
			OutDocStat( TRUE );
			aDefWordDelim = SW_MOD()->GetDocStatWordDelim();
		}

		// Outline-Numerierung, falls vorhanden
		if( pDoc->GetOutlineNumRule() && IsSw31Or40Export() )
			OutNumRule( SWG_OUTLINE, *pDoc->GetOutlineNumRule() );

		// globale Fussnoten-Info
		if( !nRes )
			OutFtnInfo();
		if( !nRes && !IsSw31Or40Export() )
			OutEndNoteInfo();
		if( !nRes && !IsSw31Or40Export() )
			OutLineNumberInfo();
	}

	// Woerterbuecher des Onlinespellings
	if( !nRes && !IsSw31Export() ) OutDictionary();
	// Numberformatter schreiben bei Textbausteinen. Bei normalen
	// Dokumenten erfolgt es schon bei den PageDescs
	if( !nRes && !IsSw31Export() && bBlock ) OutNumberFormatter();

	// Makro-Tabellen
	if( !nRes ) OutMacroTbl();
	// Nicht-Systemfeldtypen
	if( !nRes ) OutFieldTypes();
	// Verzeichnisbereiche
	if( !nRes )
	{
		OutTOXs51();
		if( !nRes && !IsSw31Or40Export() )
			OutTOXs();
	}

	// Bookmarks (nicht, wenn ein SW2-TextBlockDoc konvertiert wird)
// JP 16.10.95: werden jetzt im OutPageDesc geschrieben
// MIB 11.12.96: es werden jetzt die Bookmarks der Seiten-Vorlagen und
//               im Dok jeweils getrennt in die Streams geschrieben
	if( !nRes && !( nGblFlags & SW3F_CONVBLOCK ) && !IsSw31Export() )
		OutBookmarks( FALSE );

	// Solange Textbausteine ueber Zwischen-Dokumente geladen und
	// gespeichert werden, kann es dort keine Redlines geben. Also
	// muss man dies nirgendwo abfangen (nicht nur hier nicht).
	if( !nRes && !IsSw31Or40Export() )
		OutRedlines( FALSE );

	// Einstellungen der PagePreView speichern
	if( !nRes && !bBlock && !IsSw31Or40Export() )
		OutPagePreViewPrintData();

	// Eine handvoll persistenten Dummy-Member
	if( !nRes && !IsSw31Or40Export() )
		OutDocDummies();

	// Der Inhalt
	SwPaM* pPaM = &rPaM;
	while( !nRes )
	{
		pCurPaM = pPaM;
		// seitengebundene FlyFrames
		if( !pBlockName ) OutFlyFrames( *pPaM );
		OutContents( pPaM );
		if( (SwPaM*) pPaM->GetNext() != &rPaM )
		{
			pPaM = (SwPaM*) pPaM->GetNext();
		}
		else break;
	}
	// der Job-Setup. Vor dem Layout, damit das Layout bei veraendertem Drucker
	// gleich geeignet invalidiert werden kann.
	if( !bBlock && !nRes )
		OutJobSetup();

#ifdef TEST_HUGE_DOCS
	BOOL b = FALSE;
	if( b )
		OutHugeRecord( 1024, 32*1024 );
#endif

	ULONG nRecSzPos = 0;
	if( !nRes && HasRecSizes() && !IsSw31Or40Export() )
		nRecSzPos = OutRecSizes();

	OpenRec( SWG_EOF );
	CloseRec( SWG_EOF );
	// Ggf. Fehlerflag schreiben
	if( nRes )
	{
		nFileFlags |= SWGF_BAD_FILE;
	}
	// Datei-Flags noch einmal schreiben
	pStrm->Seek( 0L );
	OutHeader( nRecSzPos );
	// Temporaere Namenserweiterungen entfernen
	aStringPool.RemoveExtensions( *pDoc );
	FreeFlyFrms();
	// Die gesammelte Statistik am Doc setzen
	if( !bBlock )
	{
		// Bis das Layout gespeichert wird, die Seiten uebernehmen
		if( pDoc->GetRootFrm() )
			aStat.nPage = pDoc->GetRootFrm()->GetPageNum();
		pDoc->SetDocStat( aStat );
		OutDocStat( FALSE );
	}
}

// Laden des Textes eines Dokuments. Der Text wird an den uebergebenen
// String angefuegt.


void Sw3IoImp::LoadDocText( String& rText )
{
	rText.Erase();
	Reset2();
	pStrm->Seek( 0 );
	OutputMode( FALSE );
	InHeader( TRUE );
	if( ( nFileFlags & SWGF_BAD_FILE )
	 || ( nVersion < SWG_DDESEP ) )
		Error( ERR_SWG_READ_ERROR );

	BOOL bDone = BOOL( !Good() );
	while( !bDone )
	{
		BYTE cType = Peek();
		if( !Good() || pStrm->IsEof() )
			bDone = TRUE;
		else switch( cType )
		{
			case SWG_EOF:
				bDone = TRUE; break;
			case SWG_CONTENTS:
				rText += InContentsText();
				break;
			default:
				SkipRec();
		}
	}
}

//////////////////////////////////////////////////////////////////////////////

// Laden des Doc-Headers.

// BYTE[6]		Signatur fuer den harten Patch
// BYTE 		0
// BYTE 		Laenge der globalen Daten (z.Zt. 48 oder 112)
// INT16		Format-Version
// INT16		Globale Flags
// INT32		Persistente Flags vom Document
//				0x0001 == bOleVis2Page, MA 20. Mar. 98 gibt es nicht mehr, wird
//										auf BrowseMode gemappt.
// INT32 x 3	Dummys
// BYTE x 16	Passwort
// BYTE 		CharSet letzter Save
// BYTE 		GUIType letzer Save (Info)
// INT32		Datum letzter Save (Info)
// INT32		Uhrzeit letzter Save (Info)
// BYTE[64] 	Langer Name des Textbausteins, falls SWGF_BLOCKNAME aktiv

BOOL Sw3IoImp::CheckHeader( sal_Char *sHeader )
{
	return strcmp( sHeader, SW5HEADER ) == 0 ||
		   strcmp( sHeader, SW4HEADER ) == 0 ||
		   strcmp( sHeader, SW3HEADER ) == 0;
}

void Sw3IoImp::InHeader( BOOL bReadRecSizes )
{
	BYTE cLen, cSet, cGUI;
	sal_Char cHdrSign[ 8 ];
	Reset2();
	OutputMode( FALSE );
	pStrm->Seek( 0L );
	if( pStrm->Read( cHdrSign, 7 ) == 7 )
	{
		if( !CheckHeader(cHdrSign) )
		{
			Error( ERR_SW6_NOWRITER_FILE );
			return;
		}
	}
	else
		return;

	*pStrm >> cLen;
	ULONG nOld = pStrm->Tell();

	UINT32 nRecSzPos;
	INT32 nDocFlags,
		  nDummy;
	BYTE cRedlineMode;
	INT8 nCompatVer,
		 nDummy8;

	*pStrm >> nVersion >> nFileFlags >> nDocFlags >> nRecSzPos >> nDummy
		   >> nDummy8 >> nDummy8 >> cRedlineMode >> nCompatVer;
	// Ist die daeti von einem zu neuen SW und laesst sich nicht mehr lesen?
	// Die Kompatibilitaets-Version von aelteren File-Formaten muss
	// natuerlich ignoriert werden.
	if( IsVersion(SWG_MAJORVERSION) && nCompatVer > SWG_CVERSION )
	{
		Error( ERR_SWG_NEW_VERSION ); return; // Datei ist von neuerem SW
	}
	pStrm->Read( cPasswd, 16L );
	*pStrm >> cSet >> cGUI >> nDate >> nTime;
	eSrcSet = GetSOLoadTextEncoding( (rtl_TextEncoding) cSet,
								  	 pStrm->GetVersion() );
	pStrm->SetStreamCharSet( eSrcSet );
	if( nFileFlags & SWGF_BLOCKNAME )
	{
		sal_Char cBuf[ 64 ];
		if( pStrm->Read( cBuf, 64 ) != 64 )
			pStrm->SetError( SVSTREAM_FILEFORMAT_ERROR );
		aBlkName = String( cBuf, eSrcSet );
	}
	ULONG nNew = pStrm->Tell();
	nOld += cLen;
	if( nOld != nNew )
		pStrm->Seek( nOld );

#ifdef MAC
	if( pStrm != &pPageStyles && pStrm != &pNumRules )
#else
	if( pStrm != pPageStyles && pStrm != &pNumRules )
#endif
	{
		// Flags werden nur gesetzt, wenn der
		// Contents-Stream eingelesen wird.
		if( nFileFlags & SWGF_HAS_PGNUMS )
			pDoc->SetPageNums();
		if( !bInsert )
		{
			if( IsVersion(SWG_OLEVIS2PAGE) )
				pDoc->SetBrowseMode ( 0 != (nDocFlags & 0x0001) ||
									  0 != (nDocFlags & 0x0002) );

			pDoc->SetHTMLMode( 0 != (nDocFlags & 0x0004) );
			pDoc->SetHeadInBrowse( 0 != (nDocFlags & 0x0008) );
			pDoc->SetFootInBrowse( 0 != (nDocFlags & 0x0010) );
			pDoc->SetGlobalDoc( 0 != (nDocFlags & 0x0020) );
			pDoc->SetGlblDocSaveLinks( 0 != (nDocFlags & 0x0040) );
			pDoc->SetLabelDoc( 0 != (nDocFlags & 0x0080) );
		}
	}
	if( bNormal && !bInsert && IsVersion(SWG_LONGIDX) )
		pDoc->SetRedlineMode_intern( (SwRedlineMode)cRedlineMode );
	if( !CheckPasswd() )
		Error( ERRCODE_SFX_WRONGPASSWORD );

	// MIB: Das <= fuer das 40-FF ist korrekt, denn es gab eine Weile
	// 4.0-Storages mit 5.0-Streams.
#ifndef PRODUCT
	if( !bBlock )
		ASSERT( ( pRoot->GetVersion() == SOFFICE_FILEFORMAT_31 &&
				  nVersion >= SWG_MAJORVERSION_30 &&
				  nVersion < SWG_MAJORVERSION_40 ) ||
				( pRoot->GetVersion() == SOFFICE_FILEFORMAT_40 &&
				  nVersion >= SWG_MAJORVERSION_40 &&
				  nVersion < SWG_MAJORVERSION_50 ) ||
				( pRoot->GetVersion() == SOFFICE_FILEFORMAT_50 &&
				  nVersion >= SWG_MAJORVERSION_50 ),
				"Beim Lesen stimmt die FF-Version am Storage nicht!" );
#endif

	if( nRecSzPos!= 0 && bReadRecSizes && !nRes && IsVersion(SWG_RECSIZES) )
		InRecSizes( nRecSzPos );
}


void Sw3IoImp::OutHeader( ULONG nRecSzPos )
{
	Reset2();
	nFileFlags |= SWGF_NO_FRAMES;
	if( aBlkName.Len() )
		nFileFlags |= SWGF_BLOCKNAME;

	INT32 nDocFlags = 0;
	if ( pDoc->IsBrowseMode() )
		nDocFlags |= 0x0002;
	if ( pDoc->IsHTMLMode() )
		nDocFlags |= 0x0004;
	if ( pDoc->IsHeadInBrowse() )
		nDocFlags |= 0x0008;
	if ( pDoc->IsFootInBrowse() )
		nDocFlags |= 0x0010;
	if( pDoc->IsGlobalDoc() )
		nDocFlags |= 0x0020;
	if( pDoc->IsGlblDocSaveLinks() )
		nDocFlags |= 0x0040;
	if( !bBlock && !IsSw31Or40Export() && pDoc->IsLabelDoc() )
		nDocFlags |= 0x0080;

	BYTE cRedlineMode = 0;
	if( !bBlock && !IsSw31Or40Export() )
		cRedlineMode = (BYTE)pDoc->GetRedlineMode();

	UINT16 nVers = SWG_VERSION;
	const sal_Char *sHeader = SW5HEADER;

	switch( pStrm->GetVersion() )
	{
	case SOFFICE_FILEFORMAT_40:
		nVers = SWG_EXPORT40;
		sHeader = SW4HEADER;
		break;
	case SOFFICE_FILEFORMAT_31:
		nVers = SWG_EXPORT31;
		sHeader = SW3HEADER;
		break;
	}

	ASSERT( !nRecSzPos || !IsSw31Or40Export(),
			"Lange Records gibt's erst ab der 5.0" );
	ASSERT( GetSOStoreTextEncoding( gsl_getSystemTextEncoding(), 
									pStrm->GetVersion() ) == eSrcSet,
			"wrong encoding while writing" );
	ASSERT( pStrm->GetStreamCharSet() == eSrcSet,
			"wrong encoding at stream while writing" );

	OutputMode( TRUE );
	pStrm->Seek( 0L );
	*pStrm << sHeader
		   << (BYTE)   0
		   << (BYTE)   ( aBlkName.Len() ? 46+64 : 46 )	// Laenge der Daten
		   << (UINT16) nVers
		   << (UINT16) nFileFlags
		   << (INT32)  nDocFlags
		   << (UINT32) nRecSzPos
		   << (INT32)  0
		   << (INT8)   0
		   << (INT8)   0
		   << (BYTE)   cRedlineMode
		   << (INT8)   SWG_CVERSION;
	pStrm->Write( cPasswd, 16 );
	*pStrm << (BYTE)   eSrcSet
		   << (BYTE)   0				// OLD: eSysType
		   << (UINT32) nDate			// fuer Passwortcheck wichtig
		   << (UINT32) nTime;
	if( aBlkName.Len() )
	{
		// den langen Blocknamen rausschreiben
		ByteString sTmp( aBlkName, eSrcSet );
		sal_Char cBuf[ 64 ];
		sTmp.Erase( 63 );
		memset( cBuf, 0, 64 );
		memcpy( cBuf, sTmp.GetBuffer(), sTmp.Len() );
		pStrm->Write( cBuf, 64 );
	}
}

void Sw3IoImp::OutRecordSizesPos( ULONG nRecSzPos )
{
	ULONG nPos = pStrm->Tell();

	pStrm->Seek( 16UL );
	*pStrm << (UINT32)nRecSzPos;

	pStrm->Seek( nPos );
}

/*#pragma SEG_FUNCDEF(sw3doc_0b)

void Sw3IoImp::GetBlockName( String& rName )
{
	InHeader();
	rName = aBlkName;
} */

