/*************************************************************************
 *
 *  $RCSfile: optdlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 15:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop


#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>

#ifndef _SV_PRINT_HXX //autogen
#include <vcl/print.hxx>
#endif
#ifndef _SVX_BACKGRND_HXX //autogen
#include <svx/backgrnd.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC //autogen
#include <svx/dialogs.hrc>
#endif
#ifndef _SVX_OPTGRID_HXX //autogen
#include <svx/optgrid.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif
#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _OPTDLG_HXX
#include <optdlg.hxx>
#endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif
#ifndef _PRTOPT_HXX
#include <prtopt.hxx>
#endif
#ifndef _OPTPAGE_HXX
#include <optpage.hxx>
#endif
#ifndef _OPTINS_HXX
#include <optins.hxx>
#endif
#ifndef _OPTLOAD_HXX
#include <optload.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _USRPREF_HXX
#include <usrpref.hxx>
#endif

#ifndef _CONFIG_HRC
#include <config.hrc>
#endif
#ifndef _OPTDLG_HRC
#include <optdlg.hrc>
#endif



/*-----------------31.08.96 14.45-------------------

--------------------------------------------------*/


SwDocEditDialog::SwDocEditDialog(Window* pParent,
					SfxItemPool &rPool,
					const SfxItemSet* pSwItemSet,
					USHORT nDefPage ) :
	SfxTabDialog(pParent, SW_RES(SW_EDIT_OPTIONS_TDLG), pSwItemSet, 0),
	pPool(&rPool)
{
	FreeResource();
	AddTabPage(TP_CONTENT_OPT,		&SwContentOptPage::Create,0);
	AddTabPage(TP_LAYOUT_OPT,		&SwLayoutOptPage::Create,0);
	AddTabPage(RID_SVXPAGE_GRID,	&SvxGridTabPage::Create,0);
	//Sw-Pages
	AddTabPage(TP_STD_FONT,			&SwStdFontTabPage::Create, 0);
	AddTabPage(TP_OPTPRINT_PAGE,	&SwAddPrinterTabPage::Create,0);
	AddTabPage(TP_OPTTABLE_PAGE,	&SwTableOptionsTabPage::Create,0);

	AddTabPage(TP_OPTSHDWCRSR,		&SwShdwCrsrOptionsTabPage::Create,0);
	AddTabPage(TP_REDLINE_OPT,		&SwRedlineOptionsTabPage::Create,0);
	AddTabPage(TP_OPTINSERT_PAGE,	&SwInsertOptPage::Create,0);
	AddTabPage(TP_OPTLOAD_PAGE,		&SwLoadOptPage::Create,0);

#ifndef PRODUCT
	AddTabPage(TP_OPTTEST_PAGE,&SwTestTabPage::Create,0);
#endif

	if (nDefPage)
		SetCurPageId(nDefPage);
}

/*-----------------31.08.96 15.04-------------------

--------------------------------------------------*/

SwDocEditDialog::~SwDocEditDialog()
{
}

/*-----------------31.08.96 15.04-------------------

--------------------------------------------------*/


void __EXPORT SwDocEditDialog::PageCreated(USHORT nPageId, SfxTabPage& rPage)
{
	switch ( nPageId )
	{
		case RID_SVXPAGE_GRID:
			((SvxGridTabPage&)rPage).HideSnapGrid();
		break;
		case TP_OPTPRINT_PAGE:
		{
			SvStringsDtor aFaxList;
			const USHORT nCount = Printer::GetQueueCount();
			for (USHORT i = 0; i < nCount; ++i)
			{
				String* pString = new String( Printer::GetQueueInfo( i ).
												GetPrinterName() );
				String* &rpString = pString;
				aFaxList.Insert( rpString, 0 );
			}
			(( SwAddPrinterTabPage& )rPage).SetFax( aFaxList );
		}
		break;
	}

}
/*-----------------31.08.96 14.40-------------------

--------------------------------------------------*/
SwBrowserOptionsDialog::SwBrowserOptionsDialog(Window* pParent,
									const SfxItemSet* pSwItemSet ) :
	SfxTabDialog(pParent, SW_RES(SW_BROWSER_OPTIONS_TDLG), pSwItemSet, 0)
{
	FreeResource();
#if SUPD<355
	AddTabPage(TP_HTML_OPT,			&OfaHtmlTabPage::Create, 	0);
#endif
	AddTabPage(TP_CONTENT_OPT,		&SwContentOptPage::Create,0);
	AddTabPage(TP_LAYOUT_OPT,		&SwLayoutOptPage::Create,0);
	AddTabPage(RID_SVXPAGE_GRID,	&SvxGridTabPage::Create,0);
	//Sw-Pages
	AddTabPage(TP_OPTPRINT_PAGE,	&SwAddPrinterTabPage::Create,0);
	AddTabPage(TP_OPTTABLE_PAGE,	&SwTableOptionsTabPage::Create,0);
	AddTabPage(TP_OPTINSERT_PAGE,	&SwInsertOptPage::Create,0);
#ifndef PRODUCT
	AddTabPage(TP_OPTTEST_PAGE,&SwTestTabPage::Create,0);
#endif
	AddTabPage(TP_BACKGROUND,		&SvxBackgroundTabPage::Create, 	0);
}

/*-----------------31.08.96 15.04-------------------

--------------------------------------------------*/


SwBrowserOptionsDialog::~SwBrowserOptionsDialog()
{
}

/*-----------------01.02.97 11.15-------------------

--------------------------------------------------*/

void __EXPORT SwBrowserOptionsDialog::PageCreated(USHORT nPageId, SfxTabPage& rPage)
{
	switch ( nPageId )
	{
		case RID_SVXPAGE_GRID:
			((SvxGridTabPage&)rPage).HideSnapGrid();
		break;
		case TP_OPTPRINT_PAGE:
		{
			SvStringsDtor aFaxList;
			const USHORT nCount = Printer::GetQueueCount();
			for (USHORT i = 0; i < nCount; ++i)
			{
				String* pString = new String( Printer::GetQueueInfo( i ).
												GetPrinterName() );
				String* &rpString = pString;
				aFaxList.Insert(rpString, 0);
			}
			(( SwAddPrinterTabPage& )rPage).SetFax( aFaxList );

			const String aFax = pPathFinder->GetFaxName();
			if (aFax.Len())
			{
				(( SwAddPrinterTabPage& )rPage).SelectFax( aFax );
			}
		}
		break;
	}

}



