/*************************************************************************
 *
 *  $RCSfile: rapofflinecontenttypedata.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINECONTENTTYPEDATA_HXX
#include "rapofflinecontenttypedata.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINECOMMANDMAP_HXX
#include "rapofflinecommandmap.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINECONTENT_HXX
#include "rapofflinecontent.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include "com/sun/star/beans/Property.hpp"
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include "com/sun/star/beans/PropertyValue.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_CONTENTINFO_HPP_
#include "com/sun/star/ucb/ContentInfo.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_CONTENTINFOATTRIBUTE_HPP_
#include "com/sun/star/ucb/ContentInfoAttribute.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_INSERTCOMMANDARGUMENT_HPP_
#include "com/sun/star/ucb/InsertCommandArgument.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT2_HPP_
#include "com/sun/star/ucb/OpenCommandArgument2.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include "com/sun/star/ucb/TransferInfo.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_TYPE_HXX_
#include "com/sun/star/uno/Type.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif

using namespace com::sun;
using ucprmt::offline::CommandMap;
using ucprmt::offline::Content;
using ucprmt::offline::ContentTypeData;

ContentTypeData::~ContentTypeData() SAL_THROW(())
{}

ContentTypeData::ContentTypeData()
{
    rtl::Reference< CommandMap > xMap(new CommandMap);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("getCommandInfo"))]
        = CommandDescription(getVoidCppuType(),
                             &Content::executeGetCommandInfo);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("getPropertySetInfo"))]
        = CommandDescription(getVoidCppuType(),
                             &Content::executeGetPropertySetInfo);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("getPropertyValues"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::uno::Sequence<
                                   star::beans::Property > const * >(0)),
              &Content::executeGetPropertyValues);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("setPropertyValues"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::uno::Sequence<
                                   star::beans::PropertyValue > const * >(0)),
              &Content::executeSetPropertyValues);
    m_aCommandMapMap[rtl::OUString()] = xMap;
    xMap = new CommandMap;
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("getCommandInfo"))]
        = CommandDescription(getVoidCppuType(),
                             &Content::executeGetCommandInfo);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("getPropertySetInfo"))]
        = CommandDescription(getVoidCppuType(),
                             &Content::executeGetPropertySetInfo);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("getPropertyValues"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::uno::Sequence<
                                   star::beans::Property > const * >(0)),
              &Content::executeGetPropertyValues);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("setPropertyValues"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::uno::Sequence<
                                   star::beans::PropertyValue > const * >(0)),
              &Content::executeSetPropertyValues);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("open"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::ucb::OpenCommandArgument2 const * >(0)),
              &Content::executeOpen);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("update"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::ucb::OpenCommandArgument2 const * >(0)),
              &Content::executeUpdate);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("delete"))]
        = CommandDescription(getBooleanCppuType(),
                             &Content::executeDelete);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("insert"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::ucb::InsertCommandArgument const * >(0)),
              &Content::executeInsert);
    (*xMap)[rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("transfer"))]
        = CommandDescription(
              getCppuType(
                  static_cast< star::ucb::TransferInfo const * >(0)),
              &Content::executeTransfer);
    m_aCommandMapMap[rtl::OUString(
                         RTL_CONSTASCII_USTRINGPARAM(
                             "application/vnd.sun.staroffice.fsys-file"))]
        = xMap;
    m_aCommandMapMap[rtl::OUString(
                         RTL_CONSTASCII_USTRINGPARAM(
                             "application/vnd.sun.staroffice.fsys-folder"))]
        = xMap;

    m_aCreatableContentsInfoMap[rtl::OUString()]
        = star::uno::Sequence< star::ucb::ContentInfo >();
    star::uno::Sequence< star::ucb::ContentInfo > aInfos(2);
    aInfos[0].Type
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                            "application/vnd.sun.staroffice.fsys-file"));
    aInfos[0].Attributes
        = star::ucb::ContentInfoAttribute::INSERT_WITH_INPUTSTREAM
              | star::ucb::ContentInfoAttribute::KIND_DOCUMENT;
    aInfos[0].Properties.realloc(1);
    aInfos[0].Properties[0].Name
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Title"));
    aInfos[0].Properties[0].Handle = -1;
    aInfos[0].Properties[0].Type
        = getCppuType(static_cast< rtl::OUString const * >(0));
    aInfos[1].Type
        = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                            "application/vnd.sun.staroffice.fsys-folder"));
    aInfos[1].Attributes = star::ucb::ContentInfoAttribute::KIND_FOLDER;
    aInfos[1].Properties = aInfos[0].Properties;
    m_aCreatableContentsInfoMap[
            rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                              "application/vnd.sun.staroffice.fsys-folder"))]
        = aInfos;
}

rtl::Reference< CommandMap >
ContentTypeData::getCommandMap(rtl::OUString const & rContentType)
{
    CommandMapMap::iterator aIt(m_aCommandMapMap.find(rContentType));
    if (aIt == m_aCommandMapMap.end())
        aIt = m_aCommandMapMap.find(rtl::OUString());
    OSL_ASSERT(aIt != m_aCommandMapMap.end());
    return aIt->second;
}

star::uno::Sequence< star::ucb::ContentInfo >
ContentTypeData::getCreatableContentsInfo(rtl::OUString const & rContentType)
{
    CreatableContentsInfoMap::iterator
        aIt(m_aCreatableContentsInfoMap.find(rContentType));
    if (aIt == m_aCreatableContentsInfoMap.end())
        aIt = m_aCreatableContentsInfoMap.find(rtl::OUString());
    OSL_ASSERT(aIt != m_aCreatableContentsInfoMap.end());
    return aIt->second;
}
