/*************************************************************************
 *
 *	$RCSfile: rmoutdev.hxx,v $
 *
 *	$Revision: 1.14 $
 *
 *	last change: $Author: ssa $ $Date: 2002/08/29 15:30:47 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_RMOUTDEV_HXX
#define _SV_RMOUTDEV_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_OUTDEV_HXX
#include <outdev.hxx>
#endif
#ifndef _SV_VIRDEV_HXX
#include <virdev.hxx>
#endif
#ifndef _SV_POLY_HXX
#include <poly.hxx>
#endif
#ifndef _SV_RVP_HXX
#include "rvp.hxx"
#endif

#include <outfont.hxx>	/*###*/

#include <hash_map>

struct ImplFontMetricData;
struct ImplFontData;
struct ImplKernPairData;

class PolyPolygon;
class SalLayout;
class ImplLayoutArgs;

// -----------------
// - RemoteTwoRect -
// -----------------

struct RemoteTwoRect
{
	long		mnSrcX;
	long		mnSrcY;
	long		mnSrcWidth;
	long		mnSrcHeight;
	long		mnDestX;
	long		mnDestY;
	long		mnDestWidth;
	long		mnDestHeight;
};

// --------------
// - RemoteFont -
// --------------

struct RemoteFont
{
	XubString			maName; 					// Name vom Font
	XubString			maStyleName;				// StyleName vom Font
	long				mnWidth;					// Breite vom Font in Pixeln
	long				mnHeight;					// Heoehe vom Font in Pixeln
	FontFamily			meFamily;					// Family vom Font
	CharSet 			meCharSet;					// CharSet vom Font
	FontWidth			meWidthType;				// WidthType vom Font
	FontWeight			meWeight;					// Weight vom Font
	FontItalic			meItalic;					// Italic vom Font
	FontPitch			mePitch;					// Pitch vom Font
	short				mnOrientation;				// Rotation
	BOOL				mbVertical; 				// Vertical

	BOOL				operator ==( const RemoteFont& rFont ) const;
	BOOL				operator !=( const RemoteFont& rFont ) const { return !(RemoteFont::operator ==( rFont )); }
};

// ----------------------
// - ImplServerGraphics -
// ----------------------


// forward declaration (see unotools/atom.hxx for declaration)
namespace utl {
	class AtomClient;
}

class ImplServerGraphics
{
	friend class OutputDevice;
	friend class VirtualDevice;
private:

    typedef ::std::hash_map< sal_Unicode, long > GlyphWidthMap;

	REF( NMSP_CLIENT::XRmOutputDevice ) mxRemoteDevice;
	OutputDevice*						mpLastOutDev;
	Color								maLineColor;
	Color								maFillColor;
	Color								maTextColor;
	ImplFontSelectData					maFontSelectData;
	::utl::AtomClient*					mpAtoms;
	Region								maClipRegion;
	long								mnDPIX;
	long								mnDPIY;
	RasterOp							meRasterOp;
	USHORT								mnBitCount;
	BOOL								mbClipRegion		: 1;
	BOOL								mbSendClipRegion	: 1;
	BOOL								mbSendFont			: 1;
	BOOL								mbGetResolution 	: 1;

	class ServerFont*					mpServerSideFont;
    long                                mnWidthFactor;

    GlyphWidthMap maGlyphWidths;

	void ImplCopyFontMetric( const NMSP_CLIENT::IDLFontMetricData& rFrom, ImplFontMetricData& rTo );
	void ImplCopyFontData( const NMSP_CLIENT::IDLFontData& rFrom, ImplFontData& rTo );
public:

	ImplServerGraphics( ::utl::AtomClient* pAtoms = NULL );
	// NULL means client connection, that is take the one from GetImplSVData
	~ImplServerGraphics();

	void								SetInterface( REF( NMSP_CLIENT::XRmOutputDevice )& rxRmOutDev ) { mxRemoteDevice = rxRmOutDev; }
	const REF( NMSP_CLIENT::XRmOutputDevice )&	GetInterface() const { return mxRemoteDevice; }

	void								InitLineColor();
	void								InitFillColor();
	BOOL								Init();

	void								SetOutputDevice( OutputDevice* pOutDev ) { mpLastOutDev = pOutDev; }
	OutputDevice*						GetOutputDevice() const { return mpLastOutDev; }

	void								GetResolution( long& rDPIX, long& rDPIY );
	USHORT								GetBitCount();
	void								SetWindowResolution( long DPIx, long DPIy, long Depth )
		{ mnDPIX = DPIx; mnDPIY = DPIy; mnBitCount = Depth; mbGetResolution = FALSE; }
	Color								GetPixel( const Point& rPos );
	Color*								GetPixel( const Polygon& rPoints );

	void								SetClipRegion();
	void								SetClipRegion( const Region& rRegion );
	void								SetLineColor( const Color& rColor );
	void								SetFillColor( const Color& rColor );
	void								SetRasterOp( RasterOp eROP );

    void                                SetTextColor( const Color& rColor );
    long                                SetFont( const ImplFontSelectData* rFontSelectData );
    void                                GetCharWidth( USHORT nChar1, USHORT nChar2, long* pWidthAry );
    void                                GetFontMetric( ImplFontMetricData& rMetric, long& rFactor, unsigned short firstChar, unsigned short lastChar, long* pWidths, BOOL bGetKernPairs, ImplKernPairData** ppKernPairs, long& rKernPairs );
    ULONG                               GetFontCodeRanges( sal_uInt32* pCodePairs ) const;
    ULONG                               GetKernPairs( ImplKernPairData** ppKernPairs );
    void                                GetDevFontList( ImplDevFontList* pList );

#ifdef ENABLE_CTL
    //  pOutDev param is currently not used but specified to make the prototypes identical to non-RVP version (UI-mirroring)
    BOOL                                GetGlyphBoundRect( long nIndex, bool bIsGlyphIndex, Rectangle&, const OutputDevice *pOutDev );
    BOOL                                GetGlyphOutline( long nIndex, bool bIsGlyphIndex, PolyPolygon&, const OutputDevice *pOutDev );
    SalLayout*                          LayoutText( const ImplLayoutArgs&, const OutputDevice *pOutDev );
    void                                DrawSalLayout( const SalLayout&, const OutputDevice *pOutDev );
#else // ENABLE_CTL
    BOOL                                GetGlyphBoundRect( xub_Unicode cChar, Rectangle& rRect, BOOL bOptimize );
    BOOL                                GetGlyphOutline( xub_Unicode cChar, PolyPolygon& rPolyPoly, BOOL bOptimize );
    void								DrawText( long nX, long nY, const xub_Unicode* pStr, USHORT nLen );
	void								DrawTextArray( long nX, long nY, const xub_Unicode* pStr, USHORT nLen, const long* pDXAry );
#endif // ENABLE_CTL

	void								CopyArea( long nDestX, long nDestY, long nSrcX, long nSrcY,
												  long nSrcWidth, long nSrcHeight, USHORT nFlags );
    //  pOutDev,pSrcOutDev param is currently not used but specified to make the prototypes identical to non-RVP version (UI-mirroring)
	void								CopyBits( const RemoteTwoRect* pPosAry,
												  ImplServerGraphics* pSrcGraphics,
                                                  const OutputDevice *pOutDev, const OutputDevice *pSrcOutDev );

	void								Invert( const Rectangle& rRect, USHORT nFlags );
	void								Invert( const Polygon& rPoly, USHORT nFlags );
	void								InvertTracking( const Rectangle& rRect, USHORT nFlags );
	void								InvertTracking( const Polygon& rPoly, USHORT nFlags );

	void								DrawPixel( const Point& rPos );
	void								DrawPixel( const Point& rPos, const Color& rColor );
	void								DrawPixel( const Polygon& rPoints, const Color* pColors );
	void								DrawLine( const Point& rStartPos, const Point& rEndPos );
	void								DrawRect( const Rectangle& rRect );
	void								DrawPolyLine( const Polygon& rPoly );
	void								DrawPolygon( const Polygon& rPoly );
	void								DrawPolyPolygon( const PolyPolygon& rPoly );
	void								DrawRect( const Rectangle& rRect, ULONG nHorzRound, ULONG nVertRound );
	void								DrawEllipse( const Rectangle& rRect );
	void								DrawArc( const Rectangle& rRect, const Point& rStartPt, const Point& rEndPt );
	void								DrawPie( const Rectangle& rRect, const Point& rStartPt, const Point& rEndPt );
	void								DrawChord( const Rectangle& rRect, const Point& rStartPt, const Point& rEndPt );
	void								DrawGradient( const Rectangle& rRect, const Gradient& rGradient );
	void								DrawGradient( const PolyPolygon& rPolyPoly, const Gradient& rGradient );
	void								DrawHatch( const PolyPolygon& rPolyPoly, const Hatch& rHatch );
	void								DrawWaveLine( const Point& rStartPos, const Point& rEndPos, USHORT nStyle );
	void								DrawGrid( long nMinX, long nMaxX, const SEQ( long )& rHorzValues,
												  long nMinY, long nMaxY, const SEQ( long )& rVertValues, USHORT nFlags );
	void								DrawTransparent( const PolyPolygon& rPolyPoly, USHORT nTransparencyPercent );
	void								Draw2ColorFrame( const Rectangle& rRect,
														 const Color& rLeftTopColor,
														 const Color& rRightBottomColor );

    // font subset and embed; see salgdi.hxx
    BOOL					CreateFontSubset( const rtl::OUString& rToFile,
                                              ImplFontData* pFont,
                                              long* pGlyphIDs,
                                              sal_uInt8* pEncoding,
                                              sal_Int32* pWidths,
                                              int nGlyphs,
                                              FontSubsetInfo& rInfo // out parameter
                                              );
    const void*			GetEmbedFontData( ImplFontData* pFont, sal_Int32* pWidths, FontSubsetInfo& rInfo, long* pDataLen );
    // frees the font data again
    void					FreeEmbedFontData( const void* pData, long nDataLen );
};

#endif	// _SV_RMOUTDEV_HXX
