/*************************************************************************
 *
 *  $RCSfile: macexchg.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _MAC_EXCHANGE_HXX
#define _MAC_EXCHANGE_HXX

#ifndef __cplusplus
#error Vitamin C - Nimm 2
#endif
#include <mac_start.h>
#include <Types.h>
#include <mac_end.h>

#include <sysexchg.hxx>

#define nop	((void)0)


// Die Mac-Resource-Typen

#define MAC_FORMAT_TEXT			'TEXT'
#define MAC_FORMAT_PICT			'PICT'
#define MAC_FORMAT_FILE			'hfs '
#define MAC_FORMAT_RTF			'RTF '
#define MAC_FORMAT_PRIVATE		'SOF4'
#define MAC_FORMAT_HTML			'HTML'
#define MAC_FORMAT_NONE			'\0\0\0\0'

// Standard-Formate fuer die es auch Copy/Paste-Methoden gibt
#define	FORMAT_NONE				0
#define FORMAT_STRING           1		// -> MAC_FORMAT_TEXT
#define FORMAT_BITMAP           2		// -> MAC_FORMAT_PICT
#define FORMAT_GDIMETAFILE      3		// -> MAC_FORMAT_PICT
#define FORMAT_PRIVATE          4		// -> MAC_FORMAT_PRIV
#define FORMAT_FILE             5		// -> MAC_FORMAT_FILE
#define FORMAT_FILE_LIST        6		// -> MAC_FORMAT_FILE

// Weitere Standardformate (diese gehen nur ueber CopyData/PasteData)
#define FORMAT_RTF              10		// -> MAC_FORMAT_RTF
#define FORMAT_HTML				0x32


// Format-Suche

BOOL HasFormat(XDTrans *pInterface, UINT32 nFormat);

// Konvertierungen von Datenformaten

BYTE *ConvertResType2Format(ResType theResType, UINT32 nFormat, const BYTE *pData, UINT32 nSize, UINT32 &rSize);
BYTE *ConvertFormat2ResType(UINT32 nFormat, ResType theResType, const BYTE *pData, UINT32 nSize, UINT32 &rSize);

// Zugriff auf das Clipboard-Interface

void UpdateMacClipboard(BOOL bAllFormats);
void MacClipboardHasChanged();


//==================================================================================================
// FormatItem
//==================================================================================================


struct FormatItem
{
	FormatItem(const String &rName, UINT32 nFormatID);
	
	UINT32	mnFormatID;
	String	maFormatName;
};

//==================================================================================================
// XMacExchange
//==================================================================================================

DECLARE_LIST(FormatList, FormatItem *);
class XMacExchange : public FormatList, public XSystemExchange
{
public:
	XMacExchange();
	virtual ~XMacExchange();
	
	virtual void registerFormatName(const String &, UINT32);
	const FormatItem *findItem(const String &, UINT32 = FORMAT_NONE);
	
protected:
	static XMacExchange	theExchange;
	
	friend class XDTransMacClip;
	friend class XMacClipboard;
	friend XSystemExchange* GetSystemExchange();
	friend UINT32	*__getTypeList(UINT32 &rSize);

};



#endif // _MAC_SYSEXCHANGE_HXX
