/*************************************************************************
 *
 *  $RCSfile: gcach_rpeer.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2001/12/03 18:02:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <gcach_rpeer.hxx>

#include <bitmap.hxx>
#include <bmpacc.hxx>

// =======================================================================

void RemoteGlyphPeer::RemovingGlyph( ServerFont&, GlyphData& rGlyphData, int nGlyphIndex )
{
    switch( rGlyphData.GetExtInfo() )
    {
        case BITMAP1_KIND:
        case BITMAP8_KIND:
            {
                Bitmap* const pBitmap = (Bitmap*)rGlyphData.GetExtPointer();
                if( pBitmap )
                {
                    rGlyphData.SetExtended( EMPTY_KIND, NULL );
                    mnBytesUsed -= pBitmap->GetSizeBytes();
                    delete pBitmap;
                }
            }
            break;
    }
}

// -----------------------------------------------------------------------

const Bitmap* RemoteGlyphPeer::GetBitmap1( ServerFont& rServerFont, int nGlyphIndex )
{
    const Bitmap* pBitmap = NULL;
    GlyphData& rGlyphData = rServerFont.GetGlyphData( nGlyphIndex );

    if( rGlyphData.GetExtInfo() == BITMAP1_KIND )
        pBitmap = (Bitmap*)rGlyphData.GetExtPointer();

    if( !pBitmap )
    {
        if( !rServerFont.GetGlyphBitmap1( nGlyphIndex, maRawBitmap ) )
        {
            if( nGlyphIndex != 0 )  // recurse only once
                pBitmap = GetBitmap1( rServerFont, 0 );
            rGlyphData.SetExtended( BITMAP1_KIND, (void*)NULL );
        }
        else
        {
            rGlyphData.SetSize( Size( (maRawBitmap.mnWidth+7)&~7, +maRawBitmap.mnHeight) );
            rGlyphData.SetOffset( +maRawBitmap.mnXOffset, +maRawBitmap.mnYOffset );

            Bitmap* pNewBmp = new Bitmap( rGlyphData.GetSize(), 1 );
			pBitmap = pNewBmp;

            if( !pNewBmp->IsEmpty() )   // empty bitmap e.g. for SPACE character
            {
                BitmapWriteAccess* const pAccess = pNewBmp->AcquireWriteAccess();

                const int nSrcPitch = maRawBitmap.mnScanlineSize;
                const int nDestPitch = pAccess->GetScanlineSize();
                int nRows = maRawBitmap.mnHeight;
                if( nRows > pAccess->Height() )
                    nRows = pAccess->Height();

                int x, y;
                switch( pAccess->GetScanlineFormat() )
                {
                    case (BMP_FORMAT_1BIT_MSB_PAL | BMP_FORMAT_BOTTOM_UP):
                    case (BMP_FORMAT_1BIT_MSB_PAL | BMP_FORMAT_TOP_DOWN):
                        for( y = 0; y < nRows; ++y )
                        {
                            Scanline pDestBuffer = pAccess->GetScanline( y );
                            for( x = 0; x < nSrcPitch ; ++x )
                                pDestBuffer[x] = ~maRawBitmap.mpBits[ y * nSrcPitch + x ];
                            for( ; x < nDestPitch; ++x )
                                pDestBuffer[x] = 0;
                        }
                        for( y = pAccess->Height(); --y >= nRows; )
                        {
                            Scanline pDestBuffer = pAccess->GetScanline( y );
                            for( x = 0 ; x < nDestPitch ; ++x )
                                pDestBuffer[x] = 0;
                        }
                        break;

                    default:
                        DBG_ASSERT( FALSE, "GetBitmap1: unexpected ScanlineFormat!" );
                        break;
                }

                pNewBmp->ReleaseAccess( pAccess );
            }
            mnBytesUsed += pBitmap->GetSizeBytes();
            rGlyphData.SetExtended( BITMAP1_KIND, (void*)pBitmap );
        }
    }

    return pBitmap;
}

// -----------------------------------------------------------------------

const Bitmap* RemoteGlyphPeer::GetBitmap8( ServerFont& rServerFont, int nGlyphIndex )
{
    const Bitmap* pBitmap = NULL;
    GlyphData& rGlyphData = rServerFont.GetGlyphData( nGlyphIndex );

    if( rGlyphData.GetExtInfo() == BITMAP8_KIND )
        pBitmap = (Bitmap*)rGlyphData.GetExtPointer();

    if( !pBitmap )
    {
        if( !rServerFont.GetGlyphBitmap8( nGlyphIndex, maRawBitmap ) )
        {
            rGlyphData.SetExtended( BITMAP8_KIND, (void*)NULL );
            if( nGlyphIndex != 0 )  // recurse only once
                pBitmap = GetBitmap8( rServerFont, 0 );
        }
        else
        {
            rGlyphData.SetSize( Size( maRawBitmap.mnWidth, +maRawBitmap.mnHeight) );
            rGlyphData.SetOffset( +maRawBitmap.mnXOffset, +maRawBitmap.mnYOffset );

            Bitmap* pNewBmp = new Bitmap( rGlyphData.GetSize(), 8 );
            pBitmap = pNewBmp;

            if( !pNewBmp->IsEmpty() )	// empty bitmap e.g. for SPACE character
            {
                BitmapWriteAccess* const pAccess = pNewBmp->AcquireWriteAccess();

                const int nSrcPitch = maRawBitmap.mnScanlineSize;
                const int nDestPitch = pAccess->GetScanlineSize();
                int nRows = maRawBitmap.mnHeight;
                if( nRows > pAccess->Height() )
                    nRows = pAccess->Height();

                int x, y;
                for( y = 0; y < nRows; ++y )
                {
                    Scanline pDestBuffer = pAccess->GetScanline( y );
                    for( x = 0; x < nSrcPitch ; ++x )
                        pDestBuffer[x] = maRawBitmap.mpBits[ y * nSrcPitch + x ];
                    for( ; x < nDestPitch; ++x )
                        pDestBuffer[x] = 0;
                }

                for( y = pAccess->Height(); --y >= nRows; )
                {
                    Scanline pDestBuffer = pAccess->GetScanline( y );
                    for( x = 0; x < nDestPitch; ++x )
                        pDestBuffer[x] = 0;
                }

                pNewBmp->ReleaseAccess( pAccess );
            }

            mnBytesUsed += pBitmap->GetSizeBytes();
            rGlyphData.SetExtended( BITMAP8_KIND, (void*)pBitmap );
        }
    }

    return pBitmap;
}

// =======================================================================
