/*************************************************************************
 *
 *  $RCSfile: ansi1252.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef ANSI1252_HXX_
#define ANSI1252_HXX_

#ifndef _SALUNX_H
#include <salunx.h>
#endif
#ifndef _RTL_TENCINFO_H
#include <rtl/tencinfo.h>
#endif


class Ansi1252FontEncoder {

	protected:
					Ansi1252FontEncoder(); // dont want a default ctor

	private:

		#define REMAP_TABLE_OFFSET 128
		#define REMAP_TABLE_SIZE    32
		static const short 	mnRemapTable[ REMAP_TABLE_SIZE ];

		Bool  			 	mbReencodableFont;
		long 			    mnFixedWidth;
		Bool 			    mbFixedWidthChecked;
		
		long 			   *mpCharWidth; // from SalGraphics::GetCharWidth() 
		unsigned int 	 	mnCharFrom;	 // dito
		unsigned int 	 	mnCharTo;	 // dito

		long 		nFixedWidth();
		short 		nMapChar ( unsigned int nChar );
		long  		nSimpleCharWidth ( unsigned int nChar );
		long  		nCompoundCharWidth ( unsigned int nChar );
		long  		nRoundInt ( double dVal ) { return (long)(dVal + 0.5); }

	public:

					Ansi1252FontEncoder ( rtl_TextEncoding eCharset, 
						long *pCharWidth, 
						unsigned int nCharFrom, unsigned int nCharTo );

		Bool 		bEmulateAnsi1252Encoding ( unsigned int nChar );
		long 		nCharWidth ( unsigned int nChar );
};

// Belonging loosly to Ansi1252FontEncoder, but made  a pure C fkt to be 
// easily called in XPrinter geraffel
extern "C" Bool bAnsi1252ReencodingOn ();

#endif /* ANSI1252_HXX_ */
