/*************************************************************************
 *
 *  $RCSfile: acceptor.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/14 10:01:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <vos/diagnose.hxx>
#include <vos/object.hxx>
#include <vos/acceptor.hxx>
#include <vos/timer.hxx>

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif

#ifdef _USE_NAMESPACE
using namespace vos;
#endif


struct PrivateData
{
	sal_Int32 numOfConnections;
	OSocketAddr rAddr; 
	OSocket::TProtocol protocol;
	OSocket::TSocketType type;
	sal_Bool bReuseAddr;
	OAcceptorSocket* pSocket;
};


/////////////////////////////////////////////////////////////////////////////
//
//  class OAcceptor
//

OAcceptor::OAcceptor(IAcceptHandlerFactory& rFactory, 
					 OSocketAddr& rAddr, 
					 OSocket::TProtocol       protocol,
					 OSocket::TSocketType type,
					 sal_Bool bReuseAddr) :

		m_Socket(rAddr.getFamily(), protocol, type),
		m_rFactory(rFactory), 
		m_numOfConnections(0)

{
	PrivateData* pPrivate = new PrivateData;

	pPrivate->numOfConnections = 0;
	pPrivate->rAddr = rAddr;
	pPrivate->protocol = protocol;
	pPrivate->type = type;
	pPrivate->bReuseAddr = bReuseAddr;
	pPrivate->pSocket = 0;

	m_numOfConnections = (sal_Int32)pPrivate;
}

OAcceptor::~OAcceptor()
{
	terminate();

	delete (PrivateData*)m_numOfConnections;
}

void OAcceptor::terminate()
{
	PrivateData* pPrivate = (PrivateData*)m_numOfConnections;

	// terminate thread after next connect
	OThread::terminate();

	if (pPrivate->pSocket)
	{
		pPrivate->pSocket->close();
		delete pPrivate->pSocket;
		pPrivate->pSocket = 0;
	}
	else
		awake();
}

void OAcceptor::run()
{
	PrivateData* pPrivate = (PrivateData*)m_numOfConnections;

	while (schedule())
	{
		if (! pPrivate->pSocket)
		{
			pPrivate->pSocket = new OAcceptorSocket(pPrivate->rAddr.getFamily(), 
												pPrivate->protocol, pPrivate->type);

			if (pPrivate->bReuseAddr)
				pPrivate->pSocket->setReuseAddr(1);

			if (! pPrivate->pSocket->bind(pPrivate->rAddr) ||
			    ! pPrivate->pSocket->listen(pPrivate->numOfConnections))
			{
				delete pPrivate->pSocket;
				pPrivate->pSocket = 0;

				sleep(TTimeValue(15000));
			}

		}

		if (schedule() && (pPrivate->pSocket))
		{
			NAMESPACE_VOS(OSocketAddr) Addr;
			NAMESPACE_VOS(OStreamSocket) Socket;

			if (pPrivate->pSocket->acceptConnection(Socket, Addr) == OSocket::TResult_Ok)
			{
				if (schedule())
				{
					IAcceptHandler *pHandler = m_rFactory.createHandler();

					if (! pHandler->onConnection(Socket, Addr))
						m_rFactory.destroyHandler(pHandler);
				}
			}
			else
			{
				delete pPrivate->pSocket;
				pPrivate->pSocket = 0;
			}
		}
	}
}

sal_Bool OAcceptor::acceptConnections(sal_Int32 nMaxConnections)
{
	PrivateData* pPrivate = (PrivateData*)m_numOfConnections;

	pPrivate->numOfConnections = nMaxConnections;
	
	if (m_Socket.isValid())
	{
		create();

		return (sal_True);
	}

	return (sal_False);
}

