/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /work/mozilla/mozilla/mailnews/base/public/nsIMsgIncomingServer.idl
 */

#ifndef __gen_nsIMsgIncomingServer_h__
#define __gen_nsIMsgIncomingServer_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_MailNewsTypes2_h__
#include "MailNewsTypes2.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIFileSpec; /* forward declaration */

class nsIFolder; /* forward declaration */

class nsIMsgFolder; /* forward declaration */

class nsIMsgFolderCache; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIMsgFilterList; /* forward declaration */

class nsIMsgRetentionSettings; /* forward declaration */

class nsIMsgDownloadSettings; /* forward declaration */


/* starting interface:    nsIMsgIncomingServer */
#define NS_IMSGINCOMINGSERVER_IID_STR "60dcb100-e3f2-11d2-b7fc-00805f05ffa5"

#define NS_IMSGINCOMINGSERVER_IID \
  {0x60dcb100, 0xe3f2, 0x11d2, \
    { 0xb7, 0xfc, 0x00, 0x80, 0x5f, 0x05, 0xff, 0xa5 }}

class NS_NO_VTABLE nsIMsgIncomingServer : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IMSGINCOMINGSERVER_IID)

  /**
   * internal pref key - guaranteed to be unique across all servers
   */
  /* attribute string key; */
  NS_IMETHOD GetKey(char * *aKey) = 0;
  NS_IMETHOD SetKey(const char * aKey) = 0;

  /**
   * pretty name - should be "userid on hostname"
   * if the pref is not set
   */
  /* attribute wstring prettyName; */
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName) = 0;
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName) = 0;

  /**
  * helper function to construct the pretty name in a server type
  * specific way - e.g., mail for foo@test.com, news on news.mozilla.org
  */
  /* readonly attribute wstring constructedPrettyName; */
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName) = 0;

  /**
   * hostname of the server
   */
  /* attribute string hostName; */
  NS_IMETHOD GetHostName(char * *aHostName) = 0;
  NS_IMETHOD SetHostName(const char * aHostName) = 0;

  /**
   * real hostname of the server (if server name is changed it's stored here)
   */
  /* attribute string realHostName; */
  NS_IMETHOD GetRealHostName(char * *aRealHostName) = 0;
  NS_IMETHOD SetRealHostName(const char * aRealHostName) = 0;

  /* attribute long port; */
  NS_IMETHOD GetPort(PRInt32 *aPort) = 0;
  NS_IMETHOD SetPort(PRInt32 aPort) = 0;

  /**
   * userid to log into the server
   */
  /* attribute string username; */
  NS_IMETHOD GetUsername(char * *aUsername) = 0;
  NS_IMETHOD SetUsername(const char * aUsername) = 0;

  /**
   * real username of the server (if username is changed it's stored here)
   */
  /* attribute string realUsername; */
  NS_IMETHOD GetRealUsername(char * *aRealUsername) = 0;
  NS_IMETHOD SetRealUsername(const char * aRealUsername) = 0;

  /**
   * protocol type, i.e. "pop3", "imap", "nntp", "none", etc
   * used to construct URLs
   */
  /* attribute string type; */
  NS_IMETHOD GetType(char * *aType) = 0;
  NS_IMETHOD SetType(const char * aType) = 0;

  /**
   * the schema for the local mail store, such
   * as "mailbox", "imap", or "news"
   * used to construct URIs
   */
  /* readonly attribute string localStoreType; */
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType) = 0;

  /* void OnUserOrHostNameChanged (in string oldName, in string newName); */
  NS_IMETHOD OnUserOrHostNameChanged(const char *oldName, const char *newName) = 0;

  /* attribute boolean rememberPassword; */
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword) = 0;
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword) = 0;

  /* attribute string password; */
  NS_IMETHOD GetPassword(char * *aPassword) = 0;
  NS_IMETHOD SetPassword(const char * aPassword) = 0;

  /* string getPasswordWithUI (in wstring aPromptString, in wstring aPromptTitle, in nsIMsgWindow aMsgWindow, out boolean okayValue); */
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval) = 0;

  /* void forgetPassword (); */
  NS_IMETHOD ForgetPassword(void) = 0;

  /* void forgetSessionPassword (); */
  NS_IMETHOD ForgetSessionPassword(void) = 0;

  /* attribute boolean downloadOnBiff; */
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff) = 0;
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff) = 0;

  /* attribute boolean doBiff; */
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff) = 0;
  NS_IMETHOD SetDoBiff(PRBool aDoBiff) = 0;

  /* attribute long biffMinutes; */
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes) = 0;
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes) = 0;

  /* attribute unsigned long biffState; */
  NS_IMETHOD GetBiffState(PRUint32 *aBiffState) = 0;
  NS_IMETHOD SetBiffState(PRUint32 aBiffState) = 0;

  /* attribute boolean performingBiff; */
  NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff) = 0;
  NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff) = 0;

  /* attribute nsIFileSpec localPath; */
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath) = 0;
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath) = 0;

  /* readonly attribute string serverURI; */
  NS_IMETHOD GetServerURI(char * *aServerURI) = 0;

  /* attribute nsIFolder rootFolder; */
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder) = 0;
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder) = 0;

  /* readonly attribute nsIMsgFolder rootMsgFolder; */
  NS_IMETHOD GetRootMsgFolder(nsIMsgFolder * *aRootMsgFolder) = 0;

  /* attribute boolean serverBusy; */
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy) = 0;
  NS_IMETHOD SetServerBusy(PRBool aServerBusy) = 0;

  /* attribute boolean isSecure; */
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure) = 0;
  NS_IMETHOD SetIsSecure(PRBool aIsSecure) = 0;

  /* readonly attribute boolean isSecureServer; */
  NS_IMETHOD GetIsSecureServer(PRBool *aIsSecureServer) = 0;

  /* attribute string redirectorType; */
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType) = 0;
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType) = 0;

  /* attribute boolean emptyTrashOnExit; */
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit) = 0;
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit) = 0;

  /* nsIMsgFilterList getFilterList (in nsIMsgWindow aMsgWindow); */
  NS_IMETHOD GetFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval) = 0;

  /* void setFilterList (in nsIMsgFilterList aFilterList); */
  NS_IMETHOD SetFilterList(nsIMsgFilterList *aFilterList) = 0;

  /* void SetDefaultLocalPath (in nsIFileSpec aDefaultLocalPath); */
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath) = 0;

  /* void PerformBiff (); */
  NS_IMETHOD PerformBiff(void) = 0;

  /* readonly attribute boolean serverRequiresPasswordForBiff; */
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff) = 0;

  /* void performExpand (in nsIMsgWindow aMsgWindow); */
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) = 0;

  /* void WriteToFolderCache (in nsIMsgFolderCache folderCache); */
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache) = 0;

  /* void CloseCachedConnections (); */
  NS_IMETHOD CloseCachedConnections(void) = 0;

  /* boolean getBoolValue (in string attr); */
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval) = 0;

  /* void setBoolValue (in string attr, in boolean value); */
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value) = 0;

  /* string getCharValue (in string attr); */
  NS_IMETHOD GetCharValue(const char *attr, char **_retval) = 0;

  /* void setCharValue (in string attr, in string value); */
  NS_IMETHOD SetCharValue(const char *attr, const char *value) = 0;

  /* wstring getUnicharValue (in string attr); */
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval) = 0;

  /* void setUnicharValue (in string attr, in wstring value); */
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value) = 0;

  /* long getIntValue (in string attr); */
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval) = 0;

  /* void setIntValue (in string attr, in long value); */
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value) = 0;

  /* nsIFileSpec getFileValue (in string attr); */
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval) = 0;

  /* void setFileValue (in string attr, in nsIFileSpec value); */
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value) = 0;

  /**
   * this is really dangerous. this destroys all pref values
   * do not call this unless you know what you're doing!
   */
  /* void clearAllValues (); */
  NS_IMETHOD ClearAllValues(void) = 0;

  /** 
   * this is also very dangerous.  this will remove the files
   * associated with this server on disk.
   */
  /* void removeFiles (); */
  NS_IMETHOD RemoveFiles(void) = 0;

  /* attribute boolean valid; */
  NS_IMETHOD GetValid(PRBool *aValid) = 0;
  NS_IMETHOD SetValid(PRBool aValid) = 0;

  /* wstring toString (); */
  NS_IMETHOD ToString(PRUnichar **_retval) = 0;

  /* void displayOfflineMsg (in nsIMsgWindow aWindow); */
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow) = 0;

  /* boolean equals (in nsIMsgIncomingServer server); */
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval) = 0;

  /* readonly attribute boolean downloadMessagesAtStartup; */
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup) = 0;

  /* readonly attribute boolean canHaveFilters; */
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters) = 0;

  /**
   * can this server be removed from the account manager?  for
   * instance, local mail is not removable, but an imported folder is 
   */
  /* attribute boolean canDelete; */
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete) = 0;
  NS_IMETHOD SetCanDelete(PRBool aCanDelete) = 0;

  /* attribute boolean loginAtStartUp; */
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp) = 0;
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp) = 0;

  /* attribute boolean limitOfflineMessageSize; */
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize) = 0;
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize) = 0;

  /* attribute long maxMessageSize; */
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize) = 0;
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize) = 0;

  /* attribute nsIMsgRetentionSettings retentionSettings; */
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings) = 0;
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings) = 0;

  /* readonly attribute boolean canBeDefaultServer; */
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer) = 0;

  /* readonly attribute boolean canSearchMessages; */
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages) = 0;

  /* readonly attribute boolean canEmptyTrashOnExit; */
  NS_IMETHOD GetCanEmptyTrashOnExit(PRBool *aCanEmptyTrashOnExit) = 0;

  /* attribute boolean displayStartupPage; */
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage) = 0;
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage) = 0;

  /* attribute nsIMsgDownloadSettings downloadSettings; */
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings) = 0;
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings) = 0;

  /* attribute long offlineSupportLevel; */
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel) = 0;
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel) = 0;

  /* wstring generatePrettyNameForMigration (); */
  NS_IMETHOD GeneratePrettyNameForMigration(PRUnichar **_retval) = 0;

  /* readonly attribute boolean supportsDiskSpace; */
  NS_IMETHOD GetSupportsDiskSpace(PRBool *aSupportsDiskSpace) = 0;

  /**
   * If the server supports Fcc/Sent/etc, default prefs can point to 
   * the server. Otherwise, copies and folders prefs should point to
   * Local Folders.
   *
   * By default this value is set to true via global pref 'allows_specialfolders_usage'
   * (mailnews.js). For Nntp, the value is overridden to be false.
   * If ISPs want to modify this value, they should do that in their rdf file
   * by using this attribute. Please look at mozilla/mailnews/base/ispdata/aol.rdf for
   * usage example.
   */
  /* attribute boolean defaultCopiesAndFoldersPrefsToServer; */
  NS_IMETHOD GetDefaultCopiesAndFoldersPrefsToServer(PRBool *aDefaultCopiesAndFoldersPrefsToServer) = 0;
  NS_IMETHOD SetDefaultCopiesAndFoldersPrefsToServer(PRBool aDefaultCopiesAndFoldersPrefsToServer) = 0;

  /* attribute boolean canCreateFoldersOnServer; */
  NS_IMETHOD GetCanCreateFoldersOnServer(PRBool *aCanCreateFoldersOnServer) = 0;
  NS_IMETHOD SetCanCreateFoldersOnServer(PRBool aCanCreateFoldersOnServer) = 0;

  /* attribute boolean canFileMessagesOnServer; */
  NS_IMETHOD GetCanFileMessagesOnServer(PRBool *aCanFileMessagesOnServer) = 0;
  NS_IMETHOD SetCanFileMessagesOnServer(PRBool aCanFileMessagesOnServer) = 0;

  /* readonly attribute boolean canCompactFoldersOnServer; */
  NS_IMETHOD GetCanCompactFoldersOnServer(PRBool *aCanCompactFoldersOnServer) = 0;

  /* readonly attribute boolean canUndoDeleteOnServer; */
  NS_IMETHOD GetCanUndoDeleteOnServer(PRBool *aCanUndoDeleteOnServer) = 0;

  /* readonly attribute nsMsgSearchScopeValue filterScope; */
  NS_IMETHOD GetFilterScope(nsMsgSearchScopeValue *aFilterScope) = 0;

  /* readonly attribute nsMsgSearchScopeValue searchScope; */
  NS_IMETHOD GetSearchScope(nsMsgSearchScopeValue *aSearchScope) = 0;

  /** 
   * these generic getter / setters, useful for extending mailnews 
   * note, these attributes persist across sessions
   */
  /* wstring getUnicharAttribute (in string name); */
  NS_IMETHOD GetUnicharAttribute(const char *name, PRUnichar **_retval) = 0;

  /* void setUnicharAttribute (in string name, in wstring value); */
  NS_IMETHOD SetUnicharAttribute(const char *name, const PRUnichar *value) = 0;

  /* string getCharAttribute (in string name); */
  NS_IMETHOD GetCharAttribute(const char *name, char **_retval) = 0;

  /* void setCharAttribute (in string name, in string value); */
  NS_IMETHOD SetCharAttribute(const char *name, const char *value) = 0;

  /* boolean getBoolAttribute (in string name); */
  NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval) = 0;

  /* void setBoolAttribute (in string name, in boolean value); */
  NS_IMETHOD SetBoolAttribute(const char *name, PRBool value) = 0;

  /* long getIntAttribute (in string name); */
  NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval) = 0;

  /* void setIntAttribute (in string name, in long value); */
  NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value) = 0;

  /** 
   * If the password for the server is available either via authentication 
   * in the current session or from password manager stored entries, return
   * true. Otherwise, return false. If password is obtained from password 
   * manager, set the password member variable.
   */
  /* readonly attribute boolean isAuthenticated; */
  NS_IMETHOD GetIsAuthenticated(PRBool *aIsAuthenticated) = 0;

  /**
   * If we have set up to filter return receipts into
   * our Sent folder, this utility method creates
   * a filter to do that, and adds it to our filterList
   * if it doesn't exist.  If it does, it will enable it.
   *
   * If the user changes their prefs, to leave the 
   * return receipt in the inbox, this will disable 
   * the existing return receipts filter, if it exists.
   */
  /* void configureTemporaryReturnReceiptsFilter (in nsIMsgFilterList filterList); */
  NS_IMETHOD ConfigureTemporaryReturnReceiptsFilter(nsIMsgFilterList *filterList) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGINCOMINGSERVER \
  NS_IMETHOD GetKey(char * *aKey); \
  NS_IMETHOD SetKey(const char * aKey); \
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName); \
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName); \
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName); \
  NS_IMETHOD GetHostName(char * *aHostName); \
  NS_IMETHOD SetHostName(const char * aHostName); \
  NS_IMETHOD GetRealHostName(char * *aRealHostName); \
  NS_IMETHOD SetRealHostName(const char * aRealHostName); \
  NS_IMETHOD GetPort(PRInt32 *aPort); \
  NS_IMETHOD SetPort(PRInt32 aPort); \
  NS_IMETHOD GetUsername(char * *aUsername); \
  NS_IMETHOD SetUsername(const char * aUsername); \
  NS_IMETHOD GetRealUsername(char * *aRealUsername); \
  NS_IMETHOD SetRealUsername(const char * aRealUsername); \
  NS_IMETHOD GetType(char * *aType); \
  NS_IMETHOD SetType(const char * aType); \
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType); \
  NS_IMETHOD OnUserOrHostNameChanged(const char *oldName, const char *newName); \
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword); \
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword); \
  NS_IMETHOD GetPassword(char * *aPassword); \
  NS_IMETHOD SetPassword(const char * aPassword); \
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval); \
  NS_IMETHOD ForgetPassword(void); \
  NS_IMETHOD ForgetSessionPassword(void); \
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff); \
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff); \
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff); \
  NS_IMETHOD SetDoBiff(PRBool aDoBiff); \
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes); \
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes); \
  NS_IMETHOD GetBiffState(PRUint32 *aBiffState); \
  NS_IMETHOD SetBiffState(PRUint32 aBiffState); \
  NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff); \
  NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff); \
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath); \
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath); \
  NS_IMETHOD GetServerURI(char * *aServerURI); \
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder); \
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder); \
  NS_IMETHOD GetRootMsgFolder(nsIMsgFolder * *aRootMsgFolder); \
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy); \
  NS_IMETHOD SetServerBusy(PRBool aServerBusy); \
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure); \
  NS_IMETHOD SetIsSecure(PRBool aIsSecure); \
  NS_IMETHOD GetIsSecureServer(PRBool *aIsSecureServer); \
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType); \
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType); \
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit); \
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit); \
  NS_IMETHOD GetFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval); \
  NS_IMETHOD SetFilterList(nsIMsgFilterList *aFilterList); \
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath); \
  NS_IMETHOD PerformBiff(void); \
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff); \
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow); \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache); \
  NS_IMETHOD CloseCachedConnections(void); \
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval); \
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value); \
  NS_IMETHOD GetCharValue(const char *attr, char **_retval); \
  NS_IMETHOD SetCharValue(const char *attr, const char *value); \
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval); \
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value); \
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval); \
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value); \
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval); \
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value); \
  NS_IMETHOD ClearAllValues(void); \
  NS_IMETHOD RemoveFiles(void); \
  NS_IMETHOD GetValid(PRBool *aValid); \
  NS_IMETHOD SetValid(PRBool aValid); \
  NS_IMETHOD ToString(PRUnichar **_retval); \
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow); \
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval); \
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup); \
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters); \
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete); \
  NS_IMETHOD SetCanDelete(PRBool aCanDelete); \
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp); \
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp); \
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize); \
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize); \
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize); \
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize); \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings); \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings); \
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer); \
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages); \
  NS_IMETHOD GetCanEmptyTrashOnExit(PRBool *aCanEmptyTrashOnExit); \
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage); \
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage); \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings); \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings); \
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel); \
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel); \
  NS_IMETHOD GeneratePrettyNameForMigration(PRUnichar **_retval); \
  NS_IMETHOD GetSupportsDiskSpace(PRBool *aSupportsDiskSpace); \
  NS_IMETHOD GetDefaultCopiesAndFoldersPrefsToServer(PRBool *aDefaultCopiesAndFoldersPrefsToServer); \
  NS_IMETHOD SetDefaultCopiesAndFoldersPrefsToServer(PRBool aDefaultCopiesAndFoldersPrefsToServer); \
  NS_IMETHOD GetCanCreateFoldersOnServer(PRBool *aCanCreateFoldersOnServer); \
  NS_IMETHOD SetCanCreateFoldersOnServer(PRBool aCanCreateFoldersOnServer); \
  NS_IMETHOD GetCanFileMessagesOnServer(PRBool *aCanFileMessagesOnServer); \
  NS_IMETHOD SetCanFileMessagesOnServer(PRBool aCanFileMessagesOnServer); \
  NS_IMETHOD GetCanCompactFoldersOnServer(PRBool *aCanCompactFoldersOnServer); \
  NS_IMETHOD GetCanUndoDeleteOnServer(PRBool *aCanUndoDeleteOnServer); \
  NS_IMETHOD GetFilterScope(nsMsgSearchScopeValue *aFilterScope); \
  NS_IMETHOD GetSearchScope(nsMsgSearchScopeValue *aSearchScope); \
  NS_IMETHOD GetUnicharAttribute(const char *name, PRUnichar **_retval); \
  NS_IMETHOD SetUnicharAttribute(const char *name, const PRUnichar *value); \
  NS_IMETHOD GetCharAttribute(const char *name, char **_retval); \
  NS_IMETHOD SetCharAttribute(const char *name, const char *value); \
  NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval); \
  NS_IMETHOD SetBoolAttribute(const char *name, PRBool value); \
  NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval); \
  NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value); \
  NS_IMETHOD GetIsAuthenticated(PRBool *aIsAuthenticated); \
  NS_IMETHOD ConfigureTemporaryReturnReceiptsFilter(nsIMsgFilterList *filterList); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGINCOMINGSERVER(_to) \
  NS_IMETHOD GetKey(char * *aKey) { return _to GetKey(aKey); } \
  NS_IMETHOD SetKey(const char * aKey) { return _to SetKey(aKey); } \
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName) { return _to GetPrettyName(aPrettyName); } \
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName) { return _to SetPrettyName(aPrettyName); } \
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName) { return _to GetConstructedPrettyName(aConstructedPrettyName); } \
  NS_IMETHOD GetHostName(char * *aHostName) { return _to GetHostName(aHostName); } \
  NS_IMETHOD SetHostName(const char * aHostName) { return _to SetHostName(aHostName); } \
  NS_IMETHOD GetRealHostName(char * *aRealHostName) { return _to GetRealHostName(aRealHostName); } \
  NS_IMETHOD SetRealHostName(const char * aRealHostName) { return _to SetRealHostName(aRealHostName); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return _to GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return _to SetPort(aPort); } \
  NS_IMETHOD GetUsername(char * *aUsername) { return _to GetUsername(aUsername); } \
  NS_IMETHOD SetUsername(const char * aUsername) { return _to SetUsername(aUsername); } \
  NS_IMETHOD GetRealUsername(char * *aRealUsername) { return _to GetRealUsername(aRealUsername); } \
  NS_IMETHOD SetRealUsername(const char * aRealUsername) { return _to SetRealUsername(aRealUsername); } \
  NS_IMETHOD GetType(char * *aType) { return _to GetType(aType); } \
  NS_IMETHOD SetType(const char * aType) { return _to SetType(aType); } \
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType) { return _to GetLocalStoreType(aLocalStoreType); } \
  NS_IMETHOD OnUserOrHostNameChanged(const char *oldName, const char *newName) { return _to OnUserOrHostNameChanged(oldName, newName); } \
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword) { return _to GetRememberPassword(aRememberPassword); } \
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword) { return _to SetRememberPassword(aRememberPassword); } \
  NS_IMETHOD GetPassword(char * *aPassword) { return _to GetPassword(aPassword); } \
  NS_IMETHOD SetPassword(const char * aPassword) { return _to SetPassword(aPassword); } \
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval) { return _to GetPasswordWithUI(aPromptString, aPromptTitle, aMsgWindow, okayValue, _retval); } \
  NS_IMETHOD ForgetPassword(void) { return _to ForgetPassword(); } \
  NS_IMETHOD ForgetSessionPassword(void) { return _to ForgetSessionPassword(); } \
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff) { return _to GetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff) { return _to SetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff) { return _to GetDoBiff(aDoBiff); } \
  NS_IMETHOD SetDoBiff(PRBool aDoBiff) { return _to SetDoBiff(aDoBiff); } \
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes) { return _to GetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes) { return _to SetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD GetBiffState(PRUint32 *aBiffState) { return _to GetBiffState(aBiffState); } \
  NS_IMETHOD SetBiffState(PRUint32 aBiffState) { return _to SetBiffState(aBiffState); } \
  NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff) { return _to GetPerformingBiff(aPerformingBiff); } \
  NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff) { return _to SetPerformingBiff(aPerformingBiff); } \
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath) { return _to GetLocalPath(aLocalPath); } \
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath) { return _to SetLocalPath(aLocalPath); } \
  NS_IMETHOD GetServerURI(char * *aServerURI) { return _to GetServerURI(aServerURI); } \
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder) { return _to GetRootFolder(aRootFolder); } \
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder) { return _to SetRootFolder(aRootFolder); } \
  NS_IMETHOD GetRootMsgFolder(nsIMsgFolder * *aRootMsgFolder) { return _to GetRootMsgFolder(aRootMsgFolder); } \
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy) { return _to GetServerBusy(aServerBusy); } \
  NS_IMETHOD SetServerBusy(PRBool aServerBusy) { return _to SetServerBusy(aServerBusy); } \
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure) { return _to GetIsSecure(aIsSecure); } \
  NS_IMETHOD SetIsSecure(PRBool aIsSecure) { return _to SetIsSecure(aIsSecure); } \
  NS_IMETHOD GetIsSecureServer(PRBool *aIsSecureServer) { return _to GetIsSecureServer(aIsSecureServer); } \
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType) { return _to GetRedirectorType(aRedirectorType); } \
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType) { return _to SetRedirectorType(aRedirectorType); } \
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit) { return _to GetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit) { return _to SetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD GetFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval) { return _to GetFilterList(aMsgWindow, _retval); } \
  NS_IMETHOD SetFilterList(nsIMsgFilterList *aFilterList) { return _to SetFilterList(aFilterList); } \
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath) { return _to SetDefaultLocalPath(aDefaultLocalPath); } \
  NS_IMETHOD PerformBiff(void) { return _to PerformBiff(); } \
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff) { return _to GetServerRequiresPasswordForBiff(aServerRequiresPasswordForBiff); } \
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) { return _to PerformExpand(aMsgWindow); } \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache) { return _to WriteToFolderCache(folderCache); } \
  NS_IMETHOD CloseCachedConnections(void) { return _to CloseCachedConnections(); } \
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval) { return _to GetBoolValue(attr, _retval); } \
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value) { return _to SetBoolValue(attr, value); } \
  NS_IMETHOD GetCharValue(const char *attr, char **_retval) { return _to GetCharValue(attr, _retval); } \
  NS_IMETHOD SetCharValue(const char *attr, const char *value) { return _to SetCharValue(attr, value); } \
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval) { return _to GetUnicharValue(attr, _retval); } \
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value) { return _to SetUnicharValue(attr, value); } \
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval) { return _to GetIntValue(attr, _retval); } \
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value) { return _to SetIntValue(attr, value); } \
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval) { return _to GetFileValue(attr, _retval); } \
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value) { return _to SetFileValue(attr, value); } \
  NS_IMETHOD ClearAllValues(void) { return _to ClearAllValues(); } \
  NS_IMETHOD RemoveFiles(void) { return _to RemoveFiles(); } \
  NS_IMETHOD GetValid(PRBool *aValid) { return _to GetValid(aValid); } \
  NS_IMETHOD SetValid(PRBool aValid) { return _to SetValid(aValid); } \
  NS_IMETHOD ToString(PRUnichar **_retval) { return _to ToString(_retval); } \
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow) { return _to DisplayOfflineMsg(aWindow); } \
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval) { return _to Equals(server, _retval); } \
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup) { return _to GetDownloadMessagesAtStartup(aDownloadMessagesAtStartup); } \
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters) { return _to GetCanHaveFilters(aCanHaveFilters); } \
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete) { return _to GetCanDelete(aCanDelete); } \
  NS_IMETHOD SetCanDelete(PRBool aCanDelete) { return _to SetCanDelete(aCanDelete); } \
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp) { return _to GetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp) { return _to SetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize) { return _to GetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize) { return _to SetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize) { return _to GetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize) { return _to SetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings) { return _to GetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings) { return _to SetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer) { return _to GetCanBeDefaultServer(aCanBeDefaultServer); } \
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages) { return _to GetCanSearchMessages(aCanSearchMessages); } \
  NS_IMETHOD GetCanEmptyTrashOnExit(PRBool *aCanEmptyTrashOnExit) { return _to GetCanEmptyTrashOnExit(aCanEmptyTrashOnExit); } \
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage) { return _to GetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage) { return _to SetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings) { return _to GetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings) { return _to SetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel) { return _to GetOfflineSupportLevel(aOfflineSupportLevel); } \
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel) { return _to SetOfflineSupportLevel(aOfflineSupportLevel); } \
  NS_IMETHOD GeneratePrettyNameForMigration(PRUnichar **_retval) { return _to GeneratePrettyNameForMigration(_retval); } \
  NS_IMETHOD GetSupportsDiskSpace(PRBool *aSupportsDiskSpace) { return _to GetSupportsDiskSpace(aSupportsDiskSpace); } \
  NS_IMETHOD GetDefaultCopiesAndFoldersPrefsToServer(PRBool *aDefaultCopiesAndFoldersPrefsToServer) { return _to GetDefaultCopiesAndFoldersPrefsToServer(aDefaultCopiesAndFoldersPrefsToServer); } \
  NS_IMETHOD SetDefaultCopiesAndFoldersPrefsToServer(PRBool aDefaultCopiesAndFoldersPrefsToServer) { return _to SetDefaultCopiesAndFoldersPrefsToServer(aDefaultCopiesAndFoldersPrefsToServer); } \
  NS_IMETHOD GetCanCreateFoldersOnServer(PRBool *aCanCreateFoldersOnServer) { return _to GetCanCreateFoldersOnServer(aCanCreateFoldersOnServer); } \
  NS_IMETHOD SetCanCreateFoldersOnServer(PRBool aCanCreateFoldersOnServer) { return _to SetCanCreateFoldersOnServer(aCanCreateFoldersOnServer); } \
  NS_IMETHOD GetCanFileMessagesOnServer(PRBool *aCanFileMessagesOnServer) { return _to GetCanFileMessagesOnServer(aCanFileMessagesOnServer); } \
  NS_IMETHOD SetCanFileMessagesOnServer(PRBool aCanFileMessagesOnServer) { return _to SetCanFileMessagesOnServer(aCanFileMessagesOnServer); } \
  NS_IMETHOD GetCanCompactFoldersOnServer(PRBool *aCanCompactFoldersOnServer) { return _to GetCanCompactFoldersOnServer(aCanCompactFoldersOnServer); } \
  NS_IMETHOD GetCanUndoDeleteOnServer(PRBool *aCanUndoDeleteOnServer) { return _to GetCanUndoDeleteOnServer(aCanUndoDeleteOnServer); } \
  NS_IMETHOD GetFilterScope(nsMsgSearchScopeValue *aFilterScope) { return _to GetFilterScope(aFilterScope); } \
  NS_IMETHOD GetSearchScope(nsMsgSearchScopeValue *aSearchScope) { return _to GetSearchScope(aSearchScope); } \
  NS_IMETHOD GetUnicharAttribute(const char *name, PRUnichar **_retval) { return _to GetUnicharAttribute(name, _retval); } \
  NS_IMETHOD SetUnicharAttribute(const char *name, const PRUnichar *value) { return _to SetUnicharAttribute(name, value); } \
  NS_IMETHOD GetCharAttribute(const char *name, char **_retval) { return _to GetCharAttribute(name, _retval); } \
  NS_IMETHOD SetCharAttribute(const char *name, const char *value) { return _to SetCharAttribute(name, value); } \
  NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval) { return _to GetBoolAttribute(name, _retval); } \
  NS_IMETHOD SetBoolAttribute(const char *name, PRBool value) { return _to SetBoolAttribute(name, value); } \
  NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval) { return _to GetIntAttribute(name, _retval); } \
  NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value) { return _to SetIntAttribute(name, value); } \
  NS_IMETHOD GetIsAuthenticated(PRBool *aIsAuthenticated) { return _to GetIsAuthenticated(aIsAuthenticated); } \
  NS_IMETHOD ConfigureTemporaryReturnReceiptsFilter(nsIMsgFilterList *filterList) { return _to ConfigureTemporaryReturnReceiptsFilter(filterList); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGINCOMINGSERVER(_to) \
  NS_IMETHOD GetKey(char * *aKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetKey(aKey); } \
  NS_IMETHOD SetKey(const char * aKey) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetKey(aKey); } \
  NS_IMETHOD GetPrettyName(PRUnichar * *aPrettyName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrettyName(aPrettyName); } \
  NS_IMETHOD SetPrettyName(const PRUnichar * aPrettyName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPrettyName(aPrettyName); } \
  NS_IMETHOD GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetConstructedPrettyName(aConstructedPrettyName); } \
  NS_IMETHOD GetHostName(char * *aHostName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHostName(aHostName); } \
  NS_IMETHOD SetHostName(const char * aHostName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHostName(aHostName); } \
  NS_IMETHOD GetRealHostName(char * *aRealHostName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRealHostName(aRealHostName); } \
  NS_IMETHOD SetRealHostName(const char * aRealHostName) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRealHostName(aRealHostName); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPort(aPort); } \
  NS_IMETHOD GetUsername(char * *aUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUsername(aUsername); } \
  NS_IMETHOD SetUsername(const char * aUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUsername(aUsername); } \
  NS_IMETHOD GetRealUsername(char * *aRealUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRealUsername(aRealUsername); } \
  NS_IMETHOD SetRealUsername(const char * aRealUsername) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRealUsername(aRealUsername); } \
  NS_IMETHOD GetType(char * *aType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetType(aType); } \
  NS_IMETHOD SetType(const char * aType) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetType(aType); } \
  NS_IMETHOD GetLocalStoreType(char * *aLocalStoreType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalStoreType(aLocalStoreType); } \
  NS_IMETHOD OnUserOrHostNameChanged(const char *oldName, const char *newName) { return !_to ? NS_ERROR_NULL_POINTER : _to->OnUserOrHostNameChanged(oldName, newName); } \
  NS_IMETHOD GetRememberPassword(PRBool *aRememberPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRememberPassword(aRememberPassword); } \
  NS_IMETHOD SetRememberPassword(PRBool aRememberPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRememberPassword(aRememberPassword); } \
  NS_IMETHOD GetPassword(char * *aPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPassword(aPassword); } \
  NS_IMETHOD SetPassword(const char * aPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPassword(aPassword); } \
  NS_IMETHOD GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPasswordWithUI(aPromptString, aPromptTitle, aMsgWindow, okayValue, _retval); } \
  NS_IMETHOD ForgetPassword(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForgetPassword(); } \
  NS_IMETHOD ForgetSessionPassword(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ForgetSessionPassword(); } \
  NS_IMETHOD GetDownloadOnBiff(PRBool *aDownloadOnBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD SetDownloadOnBiff(PRBool aDownloadOnBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDownloadOnBiff(aDownloadOnBiff); } \
  NS_IMETHOD GetDoBiff(PRBool *aDoBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDoBiff(aDoBiff); } \
  NS_IMETHOD SetDoBiff(PRBool aDoBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDoBiff(aDoBiff); } \
  NS_IMETHOD GetBiffMinutes(PRInt32 *aBiffMinutes) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD SetBiffMinutes(PRInt32 aBiffMinutes) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBiffMinutes(aBiffMinutes); } \
  NS_IMETHOD GetBiffState(PRUint32 *aBiffState) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBiffState(aBiffState); } \
  NS_IMETHOD SetBiffState(PRUint32 aBiffState) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBiffState(aBiffState); } \
  NS_IMETHOD GetPerformingBiff(PRBool *aPerformingBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPerformingBiff(aPerformingBiff); } \
  NS_IMETHOD SetPerformingBiff(PRBool aPerformingBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPerformingBiff(aPerformingBiff); } \
  NS_IMETHOD GetLocalPath(nsIFileSpec * *aLocalPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalPath(aLocalPath); } \
  NS_IMETHOD SetLocalPath(nsIFileSpec * aLocalPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLocalPath(aLocalPath); } \
  NS_IMETHOD GetServerURI(char * *aServerURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerURI(aServerURI); } \
  NS_IMETHOD GetRootFolder(nsIFolder * *aRootFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRootFolder(aRootFolder); } \
  NS_IMETHOD SetRootFolder(nsIFolder * aRootFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRootFolder(aRootFolder); } \
  NS_IMETHOD GetRootMsgFolder(nsIMsgFolder * *aRootMsgFolder) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRootMsgFolder(aRootMsgFolder); } \
  NS_IMETHOD GetServerBusy(PRBool *aServerBusy) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerBusy(aServerBusy); } \
  NS_IMETHOD SetServerBusy(PRBool aServerBusy) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetServerBusy(aServerBusy); } \
  NS_IMETHOD GetIsSecure(PRBool *aIsSecure) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsSecure(aIsSecure); } \
  NS_IMETHOD SetIsSecure(PRBool aIsSecure) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsSecure(aIsSecure); } \
  NS_IMETHOD GetIsSecureServer(PRBool *aIsSecureServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsSecureServer(aIsSecureServer); } \
  NS_IMETHOD GetRedirectorType(char * *aRedirectorType) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRedirectorType(aRedirectorType); } \
  NS_IMETHOD SetRedirectorType(const char * aRedirectorType) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRedirectorType(aRedirectorType); } \
  NS_IMETHOD GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEmptyTrashOnExit(aEmptyTrashOnExit); } \
  NS_IMETHOD GetFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilterList(aMsgWindow, _retval); } \
  NS_IMETHOD SetFilterList(nsIMsgFilterList *aFilterList) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilterList(aFilterList); } \
  NS_IMETHOD SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDefaultLocalPath(aDefaultLocalPath); } \
  NS_IMETHOD PerformBiff(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->PerformBiff(); } \
  NS_IMETHOD GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerRequiresPasswordForBiff(aServerRequiresPasswordForBiff); } \
  NS_IMETHOD PerformExpand(nsIMsgWindow *aMsgWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->PerformExpand(aMsgWindow); } \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache) { return !_to ? NS_ERROR_NULL_POINTER : _to->WriteToFolderCache(folderCache); } \
  NS_IMETHOD CloseCachedConnections(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CloseCachedConnections(); } \
  NS_IMETHOD GetBoolValue(const char *attr, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBoolValue(attr, _retval); } \
  NS_IMETHOD SetBoolValue(const char *attr, PRBool value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBoolValue(attr, value); } \
  NS_IMETHOD GetCharValue(const char *attr, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharValue(attr, _retval); } \
  NS_IMETHOD SetCharValue(const char *attr, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCharValue(attr, value); } \
  NS_IMETHOD GetUnicharValue(const char *attr, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUnicharValue(attr, _retval); } \
  NS_IMETHOD SetUnicharValue(const char *attr, const PRUnichar *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUnicharValue(attr, value); } \
  NS_IMETHOD GetIntValue(const char *attr, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIntValue(attr, _retval); } \
  NS_IMETHOD SetIntValue(const char *attr, PRInt32 value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIntValue(attr, value); } \
  NS_IMETHOD GetFileValue(const char *attr, nsIFileSpec **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFileValue(attr, _retval); } \
  NS_IMETHOD SetFileValue(const char *attr, nsIFileSpec *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFileValue(attr, value); } \
  NS_IMETHOD ClearAllValues(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearAllValues(); } \
  NS_IMETHOD RemoveFiles(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveFiles(); } \
  NS_IMETHOD GetValid(PRBool *aValid) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetValid(aValid); } \
  NS_IMETHOD SetValid(PRBool aValid) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetValid(aValid); } \
  NS_IMETHOD ToString(PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ToString(_retval); } \
  NS_IMETHOD DisplayOfflineMsg(nsIMsgWindow *aWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->DisplayOfflineMsg(aWindow); } \
  NS_IMETHOD Equals(nsIMsgIncomingServer *server, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->Equals(server, _retval); } \
  NS_IMETHOD GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownloadMessagesAtStartup(aDownloadMessagesAtStartup); } \
  NS_IMETHOD GetCanHaveFilters(PRBool *aCanHaveFilters) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanHaveFilters(aCanHaveFilters); } \
  NS_IMETHOD GetCanDelete(PRBool *aCanDelete) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanDelete(aCanDelete); } \
  NS_IMETHOD SetCanDelete(PRBool aCanDelete) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCanDelete(aCanDelete); } \
  NS_IMETHOD GetLoginAtStartUp(PRBool *aLoginAtStartUp) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD SetLoginAtStartUp(PRBool aLoginAtStartUp) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLoginAtStartUp(aLoginAtStartUp); } \
  NS_IMETHOD GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLimitOfflineMessageSize(aLimitOfflineMessageSize); } \
  NS_IMETHOD GetMaxMessageSize(PRInt32 *aMaxMessageSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD SetMaxMessageSize(PRInt32 aMaxMessageSize) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMaxMessageSize(aMaxMessageSize); } \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD GetCanBeDefaultServer(PRBool *aCanBeDefaultServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanBeDefaultServer(aCanBeDefaultServer); } \
  NS_IMETHOD GetCanSearchMessages(PRBool *aCanSearchMessages) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanSearchMessages(aCanSearchMessages); } \
  NS_IMETHOD GetCanEmptyTrashOnExit(PRBool *aCanEmptyTrashOnExit) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanEmptyTrashOnExit(aCanEmptyTrashOnExit); } \
  NS_IMETHOD GetDisplayStartupPage(PRBool *aDisplayStartupPage) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD SetDisplayStartupPage(PRBool aDisplayStartupPage) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDisplayStartupPage(aDisplayStartupPage); } \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOfflineSupportLevel(aOfflineSupportLevel); } \
  NS_IMETHOD SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOfflineSupportLevel(aOfflineSupportLevel); } \
  NS_IMETHOD GeneratePrettyNameForMigration(PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GeneratePrettyNameForMigration(_retval); } \
  NS_IMETHOD GetSupportsDiskSpace(PRBool *aSupportsDiskSpace) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSupportsDiskSpace(aSupportsDiskSpace); } \
  NS_IMETHOD GetDefaultCopiesAndFoldersPrefsToServer(PRBool *aDefaultCopiesAndFoldersPrefsToServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDefaultCopiesAndFoldersPrefsToServer(aDefaultCopiesAndFoldersPrefsToServer); } \
  NS_IMETHOD SetDefaultCopiesAndFoldersPrefsToServer(PRBool aDefaultCopiesAndFoldersPrefsToServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDefaultCopiesAndFoldersPrefsToServer(aDefaultCopiesAndFoldersPrefsToServer); } \
  NS_IMETHOD GetCanCreateFoldersOnServer(PRBool *aCanCreateFoldersOnServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanCreateFoldersOnServer(aCanCreateFoldersOnServer); } \
  NS_IMETHOD SetCanCreateFoldersOnServer(PRBool aCanCreateFoldersOnServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCanCreateFoldersOnServer(aCanCreateFoldersOnServer); } \
  NS_IMETHOD GetCanFileMessagesOnServer(PRBool *aCanFileMessagesOnServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanFileMessagesOnServer(aCanFileMessagesOnServer); } \
  NS_IMETHOD SetCanFileMessagesOnServer(PRBool aCanFileMessagesOnServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCanFileMessagesOnServer(aCanFileMessagesOnServer); } \
  NS_IMETHOD GetCanCompactFoldersOnServer(PRBool *aCanCompactFoldersOnServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanCompactFoldersOnServer(aCanCompactFoldersOnServer); } \
  NS_IMETHOD GetCanUndoDeleteOnServer(PRBool *aCanUndoDeleteOnServer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanUndoDeleteOnServer(aCanUndoDeleteOnServer); } \
  NS_IMETHOD GetFilterScope(nsMsgSearchScopeValue *aFilterScope) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilterScope(aFilterScope); } \
  NS_IMETHOD GetSearchScope(nsMsgSearchScopeValue *aSearchScope) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSearchScope(aSearchScope); } \
  NS_IMETHOD GetUnicharAttribute(const char *name, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUnicharAttribute(name, _retval); } \
  NS_IMETHOD SetUnicharAttribute(const char *name, const PRUnichar *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUnicharAttribute(name, value); } \
  NS_IMETHOD GetCharAttribute(const char *name, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCharAttribute(name, _retval); } \
  NS_IMETHOD SetCharAttribute(const char *name, const char *value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCharAttribute(name, value); } \
  NS_IMETHOD GetBoolAttribute(const char *name, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBoolAttribute(name, _retval); } \
  NS_IMETHOD SetBoolAttribute(const char *name, PRBool value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBoolAttribute(name, value); } \
  NS_IMETHOD GetIntAttribute(const char *name, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIntAttribute(name, _retval); } \
  NS_IMETHOD SetIntAttribute(const char *name, PRInt32 value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIntAttribute(name, value); } \
  NS_IMETHOD GetIsAuthenticated(PRBool *aIsAuthenticated) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsAuthenticated(aIsAuthenticated); } \
  NS_IMETHOD ConfigureTemporaryReturnReceiptsFilter(nsIMsgFilterList *filterList) { return !_to ? NS_ERROR_NULL_POINTER : _to->ConfigureTemporaryReturnReceiptsFilter(filterList); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMsgIncomingServer : public nsIMsgIncomingServer
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMSGINCOMINGSERVER

  nsMsgIncomingServer();
  virtual ~nsMsgIncomingServer();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMsgIncomingServer, nsIMsgIncomingServer)

nsMsgIncomingServer::nsMsgIncomingServer()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsMsgIncomingServer::~nsMsgIncomingServer()
{
  /* destructor code */
}

/* attribute string key; */
NS_IMETHODIMP nsMsgIncomingServer::GetKey(char * *aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetKey(const char * aKey)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute wstring prettyName; */
NS_IMETHODIMP nsMsgIncomingServer::GetPrettyName(PRUnichar * *aPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetPrettyName(const PRUnichar * aPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring constructedPrettyName; */
NS_IMETHODIMP nsMsgIncomingServer::GetConstructedPrettyName(PRUnichar * *aConstructedPrettyName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string hostName; */
NS_IMETHODIMP nsMsgIncomingServer::GetHostName(char * *aHostName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetHostName(const char * aHostName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string realHostName; */
NS_IMETHODIMP nsMsgIncomingServer::GetRealHostName(char * *aRealHostName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRealHostName(const char * aRealHostName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long port; */
NS_IMETHODIMP nsMsgIncomingServer::GetPort(PRInt32 *aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetPort(PRInt32 aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string username; */
NS_IMETHODIMP nsMsgIncomingServer::GetUsername(char * *aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetUsername(const char * aUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string realUsername; */
NS_IMETHODIMP nsMsgIncomingServer::GetRealUsername(char * *aRealUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRealUsername(const char * aRealUsername)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string type; */
NS_IMETHODIMP nsMsgIncomingServer::GetType(char * *aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetType(const char * aType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string localStoreType; */
NS_IMETHODIMP nsMsgIncomingServer::GetLocalStoreType(char * *aLocalStoreType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void OnUserOrHostNameChanged (in string oldName, in string newName); */
NS_IMETHODIMP nsMsgIncomingServer::OnUserOrHostNameChanged(const char *oldName, const char *newName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean rememberPassword; */
NS_IMETHODIMP nsMsgIncomingServer::GetRememberPassword(PRBool *aRememberPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRememberPassword(PRBool aRememberPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string password; */
NS_IMETHODIMP nsMsgIncomingServer::GetPassword(char * *aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetPassword(const char * aPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getPasswordWithUI (in wstring aPromptString, in wstring aPromptTitle, in nsIMsgWindow aMsgWindow, out boolean okayValue); */
NS_IMETHODIMP nsMsgIncomingServer::GetPasswordWithUI(const PRUnichar *aPromptString, const PRUnichar *aPromptTitle, nsIMsgWindow *aMsgWindow, PRBool *okayValue, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forgetPassword (); */
NS_IMETHODIMP nsMsgIncomingServer::ForgetPassword()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void forgetSessionPassword (); */
NS_IMETHODIMP nsMsgIncomingServer::ForgetSessionPassword()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean downloadOnBiff; */
NS_IMETHODIMP nsMsgIncomingServer::GetDownloadOnBiff(PRBool *aDownloadOnBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDownloadOnBiff(PRBool aDownloadOnBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean doBiff; */
NS_IMETHODIMP nsMsgIncomingServer::GetDoBiff(PRBool *aDoBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDoBiff(PRBool aDoBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long biffMinutes; */
NS_IMETHODIMP nsMsgIncomingServer::GetBiffMinutes(PRInt32 *aBiffMinutes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetBiffMinutes(PRInt32 aBiffMinutes)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long biffState; */
NS_IMETHODIMP nsMsgIncomingServer::GetBiffState(PRUint32 *aBiffState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetBiffState(PRUint32 aBiffState)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean performingBiff; */
NS_IMETHODIMP nsMsgIncomingServer::GetPerformingBiff(PRBool *aPerformingBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetPerformingBiff(PRBool aPerformingBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIFileSpec localPath; */
NS_IMETHODIMP nsMsgIncomingServer::GetLocalPath(nsIFileSpec * *aLocalPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetLocalPath(nsIFileSpec * aLocalPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string serverURI; */
NS_IMETHODIMP nsMsgIncomingServer::GetServerURI(char * *aServerURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIFolder rootFolder; */
NS_IMETHODIMP nsMsgIncomingServer::GetRootFolder(nsIFolder * *aRootFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRootFolder(nsIFolder * aRootFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIMsgFolder rootMsgFolder; */
NS_IMETHODIMP nsMsgIncomingServer::GetRootMsgFolder(nsIMsgFolder * *aRootMsgFolder)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean serverBusy; */
NS_IMETHODIMP nsMsgIncomingServer::GetServerBusy(PRBool *aServerBusy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetServerBusy(PRBool aServerBusy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean isSecure; */
NS_IMETHODIMP nsMsgIncomingServer::GetIsSecure(PRBool *aIsSecure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetIsSecure(PRBool aIsSecure)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean isSecureServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetIsSecureServer(PRBool *aIsSecureServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string redirectorType; */
NS_IMETHODIMP nsMsgIncomingServer::GetRedirectorType(char * *aRedirectorType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRedirectorType(const char * aRedirectorType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean emptyTrashOnExit; */
NS_IMETHODIMP nsMsgIncomingServer::GetEmptyTrashOnExit(PRBool *aEmptyTrashOnExit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetEmptyTrashOnExit(PRBool aEmptyTrashOnExit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIMsgFilterList getFilterList (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgIncomingServer::GetFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFilterList (in nsIMsgFilterList aFilterList); */
NS_IMETHODIMP nsMsgIncomingServer::SetFilterList(nsIMsgFilterList *aFilterList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetDefaultLocalPath (in nsIFileSpec aDefaultLocalPath); */
NS_IMETHODIMP nsMsgIncomingServer::SetDefaultLocalPath(nsIFileSpec *aDefaultLocalPath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void PerformBiff (); */
NS_IMETHODIMP nsMsgIncomingServer::PerformBiff()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean serverRequiresPasswordForBiff; */
NS_IMETHODIMP nsMsgIncomingServer::GetServerRequiresPasswordForBiff(PRBool *aServerRequiresPasswordForBiff)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void performExpand (in nsIMsgWindow aMsgWindow); */
NS_IMETHODIMP nsMsgIncomingServer::PerformExpand(nsIMsgWindow *aMsgWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void WriteToFolderCache (in nsIMsgFolderCache folderCache); */
NS_IMETHODIMP nsMsgIncomingServer::WriteToFolderCache(nsIMsgFolderCache *folderCache)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CloseCachedConnections (); */
NS_IMETHODIMP nsMsgIncomingServer::CloseCachedConnections()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getBoolValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetBoolValue(const char *attr, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setBoolValue (in string attr, in boolean value); */
NS_IMETHODIMP nsMsgIncomingServer::SetBoolValue(const char *attr, PRBool value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getCharValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetCharValue(const char *attr, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCharValue (in string attr, in string value); */
NS_IMETHODIMP nsMsgIncomingServer::SetCharValue(const char *attr, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring getUnicharValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetUnicharValue(const char *attr, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setUnicharValue (in string attr, in wstring value); */
NS_IMETHODIMP nsMsgIncomingServer::SetUnicharValue(const char *attr, const PRUnichar *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getIntValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetIntValue(const char *attr, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setIntValue (in string attr, in long value); */
NS_IMETHODIMP nsMsgIncomingServer::SetIntValue(const char *attr, PRInt32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIFileSpec getFileValue (in string attr); */
NS_IMETHODIMP nsMsgIncomingServer::GetFileValue(const char *attr, nsIFileSpec **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setFileValue (in string attr, in nsIFileSpec value); */
NS_IMETHODIMP nsMsgIncomingServer::SetFileValue(const char *attr, nsIFileSpec *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearAllValues (); */
NS_IMETHODIMP nsMsgIncomingServer::ClearAllValues()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeFiles (); */
NS_IMETHODIMP nsMsgIncomingServer::RemoveFiles()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean valid; */
NS_IMETHODIMP nsMsgIncomingServer::GetValid(PRBool *aValid)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetValid(PRBool aValid)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring toString (); */
NS_IMETHODIMP nsMsgIncomingServer::ToString(PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void displayOfflineMsg (in nsIMsgWindow aWindow); */
NS_IMETHODIMP nsMsgIncomingServer::DisplayOfflineMsg(nsIMsgWindow *aWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean equals (in nsIMsgIncomingServer server); */
NS_IMETHODIMP nsMsgIncomingServer::Equals(nsIMsgIncomingServer *server, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean downloadMessagesAtStartup; */
NS_IMETHODIMP nsMsgIncomingServer::GetDownloadMessagesAtStartup(PRBool *aDownloadMessagesAtStartup)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canHaveFilters; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanHaveFilters(PRBool *aCanHaveFilters)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean canDelete; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanDelete(PRBool *aCanDelete)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetCanDelete(PRBool aCanDelete)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean loginAtStartUp; */
NS_IMETHODIMP nsMsgIncomingServer::GetLoginAtStartUp(PRBool *aLoginAtStartUp)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetLoginAtStartUp(PRBool aLoginAtStartUp)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean limitOfflineMessageSize; */
NS_IMETHODIMP nsMsgIncomingServer::GetLimitOfflineMessageSize(PRBool *aLimitOfflineMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetLimitOfflineMessageSize(PRBool aLimitOfflineMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long maxMessageSize; */
NS_IMETHODIMP nsMsgIncomingServer::GetMaxMessageSize(PRInt32 *aMaxMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetMaxMessageSize(PRInt32 aMaxMessageSize)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgRetentionSettings retentionSettings; */
NS_IMETHODIMP nsMsgIncomingServer::GetRetentionSettings(nsIMsgRetentionSettings * *aRetentionSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetRetentionSettings(nsIMsgRetentionSettings * aRetentionSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canBeDefaultServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanBeDefaultServer(PRBool *aCanBeDefaultServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canSearchMessages; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanSearchMessages(PRBool *aCanSearchMessages)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canEmptyTrashOnExit; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanEmptyTrashOnExit(PRBool *aCanEmptyTrashOnExit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean displayStartupPage; */
NS_IMETHODIMP nsMsgIncomingServer::GetDisplayStartupPage(PRBool *aDisplayStartupPage)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDisplayStartupPage(PRBool aDisplayStartupPage)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIMsgDownloadSettings downloadSettings; */
NS_IMETHODIMP nsMsgIncomingServer::GetDownloadSettings(nsIMsgDownloadSettings * *aDownloadSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDownloadSettings(nsIMsgDownloadSettings * aDownloadSettings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long offlineSupportLevel; */
NS_IMETHODIMP nsMsgIncomingServer::GetOfflineSupportLevel(PRInt32 *aOfflineSupportLevel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetOfflineSupportLevel(PRInt32 aOfflineSupportLevel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring generatePrettyNameForMigration (); */
NS_IMETHODIMP nsMsgIncomingServer::GeneratePrettyNameForMigration(PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean supportsDiskSpace; */
NS_IMETHODIMP nsMsgIncomingServer::GetSupportsDiskSpace(PRBool *aSupportsDiskSpace)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean defaultCopiesAndFoldersPrefsToServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetDefaultCopiesAndFoldersPrefsToServer(PRBool *aDefaultCopiesAndFoldersPrefsToServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetDefaultCopiesAndFoldersPrefsToServer(PRBool aDefaultCopiesAndFoldersPrefsToServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean canCreateFoldersOnServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanCreateFoldersOnServer(PRBool *aCanCreateFoldersOnServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetCanCreateFoldersOnServer(PRBool aCanCreateFoldersOnServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean canFileMessagesOnServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanFileMessagesOnServer(PRBool *aCanFileMessagesOnServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsMsgIncomingServer::SetCanFileMessagesOnServer(PRBool aCanFileMessagesOnServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canCompactFoldersOnServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanCompactFoldersOnServer(PRBool *aCanCompactFoldersOnServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean canUndoDeleteOnServer; */
NS_IMETHODIMP nsMsgIncomingServer::GetCanUndoDeleteOnServer(PRBool *aCanUndoDeleteOnServer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsMsgSearchScopeValue filterScope; */
NS_IMETHODIMP nsMsgIncomingServer::GetFilterScope(nsMsgSearchScopeValue *aFilterScope)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsMsgSearchScopeValue searchScope; */
NS_IMETHODIMP nsMsgIncomingServer::GetSearchScope(nsMsgSearchScopeValue *aSearchScope)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring getUnicharAttribute (in string name); */
NS_IMETHODIMP nsMsgIncomingServer::GetUnicharAttribute(const char *name, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setUnicharAttribute (in string name, in wstring value); */
NS_IMETHODIMP nsMsgIncomingServer::SetUnicharAttribute(const char *name, const PRUnichar *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getCharAttribute (in string name); */
NS_IMETHODIMP nsMsgIncomingServer::GetCharAttribute(const char *name, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setCharAttribute (in string name, in string value); */
NS_IMETHODIMP nsMsgIncomingServer::SetCharAttribute(const char *name, const char *value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getBoolAttribute (in string name); */
NS_IMETHODIMP nsMsgIncomingServer::GetBoolAttribute(const char *name, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setBoolAttribute (in string name, in boolean value); */
NS_IMETHODIMP nsMsgIncomingServer::SetBoolAttribute(const char *name, PRBool value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getIntAttribute (in string name); */
NS_IMETHODIMP nsMsgIncomingServer::GetIntAttribute(const char *name, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setIntAttribute (in string name, in long value); */
NS_IMETHODIMP nsMsgIncomingServer::SetIntAttribute(const char *name, PRInt32 value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean isAuthenticated; */
NS_IMETHODIMP nsMsgIncomingServer::GetIsAuthenticated(PRBool *aIsAuthenticated)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void configureTemporaryReturnReceiptsFilter (in nsIMsgFilterList filterList); */
NS_IMETHODIMP nsMsgIncomingServer::ConfigureTemporaryReturnReceiptsFilter(nsIMsgFilterList *filterList)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

/*
 * Following values for offline support have been used by
 * various files. If you are modifying any of the values
 * below, please do take care of the following files.
 * - mozilla/mailnews/base/src/nsMsgAccountManagerDS.cpp
 * - mozilla/mailnews/base/util/nsMsgIncomingServer.cpp
 * - mozilla/mailnews/imap/src/nsImapIncomingServer.cpp
 * - mozilla/mailnews/local/src/nsPop3IncomingServer.cpp
 * - mozilla/mailnews/news/src/nsNntpIncomingServer.cpp
 * - mozilla/mailnews/base/resources/content/msgAccountCentral.js
 * - mozilla/modules/libpref/src/init/mailnews.js
 * - ns/modules/libpref/src/init/mailnews-ns.js
 * - ns/mailnews/base/ispdata/aol.rdf
 * - ns/mailnews/base/ispdata/nswebmail.rdf
 */
#define OFFLINE_SUPPORT_LEVEL_NONE 0
#define OFFLINE_SUPPORT_LEVEL_REGULAR 10
#define OFFLINE_SUPPORT_LEVEL_EXTENDED 20
#define OFFLINE_SUPPORT_LEVEL_UNDEFINED -1
// Value when no port setting is found
#define PORT_NOT_SET -1
/* some useful macros to implement nsIMsgIncomingServer accessors */
#define NS_IMPL_SERVERPREF_STR(_class, _postfix, _prefname)	\
NS_IMETHODIMP								   	\
_class::Get##_postfix(char **retval)   			\
{											   	\
  return GetCharValue(_prefname, retval);		\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(const char *chvalue)			\
{												\
  return SetCharValue(_prefname, chvalue);		\
}
#define NS_IMPL_SERVERPREF_BOOL(_class, _postfix, _prefname)\
NS_IMETHODIMP								   	\
_class::Get##_postfix(PRBool *retval)   		\
{											   	\
  return GetBoolValue(_prefname, retval);		\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(PRBool bvalue)			\
{												\
  return SetBoolValue(_prefname, bvalue);		\
}
#define NS_IMPL_SERVERPREF_INT(_class, _postfix, _prefname)\
NS_IMETHODIMP								   	\
_class::Get##_postfix(PRInt32 *retval)   		\
{											   	\
  return GetIntValue(_prefname, retval);			\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(PRInt32 ivalue)			\
{												\
  return SetIntValue(_prefname, ivalue);			\
}
#define NS_IMPL_SERVERPREF_FILE(_class, _postfix, _prefname)\
NS_IMETHODIMP								   	\
_class::Get##_postfix(nsIFileSpec **retval)   		\
{											   	\
  return GetFileValue(_prefname, retval);			\
}												\
NS_IMETHODIMP	   								\
_class::Set##_postfix(nsIFileSpec* ivalue)			\
{												\
  return SetFileValue(_prefname, ivalue);			\
}

#endif /* __gen_nsIMsgIncomingServer_h__ */
