// Statistics classes
%{
/*
 * These macros are used by code generated by the s_java script.
 */
#define JAVADB_STAT_INT(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetIntField(jenv, jobj,			\
		    (*jenv)->GetFieldID(jenv, cl, #name, "I"),		\
		    (jint)statp->name)

#define JAVADB_STAT_STRING(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetObjectField(jenv, jobj,			\
		    (*jenv)->GetFieldID(jenv, cl, #name,		\
		        "Ljava/lang/String;"),				\
		    (*jenv)->NewStringUTF(jenv, statp->name))

#define JAVADB_STAT_LSN(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetObjectField(jenv, jobj,			\
		(*jenv)->GetFieldID(jenv, cl, #name, "L" DB_PKG "DbLsn;"), \
		    __dbj_wrap_DB_LSN(jenv, &statp->name))

#define JAVADB_STAT_LONG(jenv, cl, jobj, statp, name)			\
		(*jenv)->SetLongField(jenv, jobj,			\
		    (*jenv)->GetFieldID(jenv, cl, #name, "J"),		\
		    (jlong)statp->name)

#define JAVADB_STAT_XID(jenv, cl, jobj, statp, name) {			\
	jobject jarr = (*jenv)->NewByteArray(jenv, (jsize)DB_XIDDATASIZE); \
	(*jenv)->SetByteArrayRegion(jenv, jarr, 0, (jsize)DB_XIDDATASIZE, \
	    (jbyte *)statp->name);					\
	(*jenv)->SetObjectField(jenv, jobj,				\
	    (*jenv)->GetFieldID(jenv, cl, #name, "[B"), jarr);		\
	}

/*
 * We build the active list separately.
 */
#define JAVADB_STAT_ACTIVE(jenv, cl, jobj, statp, name) \
	do {} while(0)

#include "java_stat_auto.c"
%}

%define JAVA_STAT_CLASS(_ctype, _jtype, _name)
JAVA_TYPEMAP(_ctype, _jtype, jobject)
%typemap(out) _ctype %{
	$result = (*jenv)->NewObject(jenv, _name##_class, _name##_construct);
	if ($result != NULL)
		__dbj_fill_##_name(jenv, _name##_class, $result, $1);
	__os_ufree(NULL, $1);
%}
%enddef

JAVA_STAT_CLASS(DB_LOCK_STAT *, DbLockStat, lock_stat)
JAVA_STAT_CLASS(DB_LOG_STAT *, DbLogStat, log_stat)
JAVA_STAT_CLASS(DB_MPOOL_STAT *, DbMpoolStat, mpool_stat)

JAVA_TYPEMAP(DB_MPOOL_FSTAT **, DbMpoolFStat[], jobjectArray)
%typemap(out) DB_MPOOL_FSTAT ** {
	int i, len;
	
	len = 0;
	while ($1[len] != NULL)
		len++;
	$result = (*jenv)->NewObjectArray(jenv, (jsize)len, mpool_fstat_class, 0);
	if ($result == NULL) {
		__os_ufree(NULL, $1);
		return $null;
	}
	for (i = 0; i < len; i++) {
		jobject obj = (*jenv)->NewObject(jenv, mpool_fstat_class,
		    mpool_fstat_construct);
		if (obj == NULL) {
			__os_ufree(NULL, $1);
			return $null; /* an exception is pending */
		}
		(*jenv)->SetObjectArrayElement(jenv, $result, i, obj);
		__dbj_fill_mpool_fstat(jenv, mpool_fstat_class, obj, $1[i]);
	}
	__os_ufree(NULL, $1);
}

JAVA_STAT_CLASS(DB_REP_STAT *, DbRepStat, rep_stat)
JAVA_TYPEMAP(DB_TXN_STAT *, DbTxnStat, jobject)
%typemap(out) DB_TXN_STAT * {
	unsigned int i;
	jobjectArray actives;
	$result = (*jenv)->NewObject(jenv, txn_stat_class, txn_stat_construct);
	if ($result != NULL)
		__dbj_fill_txn_stat(jenv, txn_stat_class, $result, $1);
	
	actives = (*jenv)->NewObjectArray(jenv, (jsize)$1->st_nactive,
	    txn_active_class, 0);
	if (actives == NULL) {
		__os_ufree(NULL, $1);
		return $null;
	}
	(*jenv)->SetObjectField(jenv, $result, txn_stat_active_fid, actives);
	for (i = 0; i < $1->st_nactive; i++) {
		jobject obj = (*jenv)->NewObject(jenv, txn_active_class,
		    txn_active_construct);
		if (obj == NULL) {
			__os_ufree(NULL, $1);
			return $null; /* an exception is pending */
		}
		(*jenv)->SetObjectArrayElement(jenv, actives, (jsize)i, obj);
		__dbj_fill_txn_active(jenv, txn_active_class, obj,
		    &$1->st_txnarray[i]);
	}
	__os_ufree(NULL, $1);
}

// Db.stat return - special case
%typemap(out) void * %{
	if ($1 == NULL)
		$result = NULL;
	else {
		DB *db = (DB *)arg1;
		DBTYPE dbtype;
		int err;
		
		if ((err = db->get_type(db, &dbtype)) != 0) {
			__dbj_throw(jenv, err, NULL, NULL, DB2JDBENV);
			return $null;
		}
		
		switch (dbtype) {
			/* Btree and recno share the same stat structure */
		case DB_BTREE:
		case DB_RECNO:
			$result = (*jenv)->NewObject(jenv, btree_stat_class,
			    btree_stat_construct);
			if ($result != NULL)
				__dbj_fill_bt_stat(jenv, btree_stat_class,
				    $result, (DB_BTREE_STAT *)$1);
			break;

			/* Hash stat structure */
		case DB_HASH:
			$result = (*jenv)->NewObject(jenv, hash_stat_class,
			    hash_stat_construct);
			if ($result != NULL)
				__dbj_fill_h_stat(jenv, hash_stat_class,
				    $result, (DB_HASH_STAT *)$1);
			break;

		case DB_QUEUE:
			$result = (*jenv)->NewObject(jenv, queue_stat_class,
			    queue_stat_construct);
			if ($result != NULL)
				__dbj_fill_qam_stat(jenv, queue_stat_class,
				    $result, (DB_QUEUE_STAT *)$1);
			break;

			/* That's all the database types we're aware of! */
		default:
			__dbj_throw(jenv, EINVAL, "Db.stat only implemented for"
			    " BTREE, HASH, QUEUE and RECNO", NULL, DB2JDBENV);
			break;
		}
		
		__os_ufree(db->dbenv, $1);
	}
%}

