#
#    Copyright 2014-2015 Kai Pastor
#    
#    This file is part of OpenOrienteering.
# 
#    OpenOrienteering is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    OpenOrienteering is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE = aux
CONFIG  -= debug_and_release

CMAKE_TOOLCHAIN_FILE = $$clean_path($$OUT_PWD/../../toolchain.cmake)
if (exists($$CMAKE_TOOLCHAIN_FILE)) {
    CMAKE_ARGS      += "-DCMAKE_TOOLCHAIN_FILE=\"$$CMAKE_TOOLCHAIN_FILE\""
    proj.depends    += $$CMAKE_TOOLCHAIN_FILE
}

proj.dir      = $$OUT_PWD/proj
proj.target   = $$proj.dir/Proj-prefix/lib/libproj.so
osx: proj.target = $$proj.dir/Proj-prefix/lib/libproj.9.dylib
win32: proj.target = $$proj.dir/Proj-prefix/bin/libproj-9.dll
proj.cflags   = $$QMAKE_CFLAGS -Wno-declaration-after-statement -Wno-int-to-pointer-cast
proj.commands = \
  mkdir -p "$$proj.dir" && \
  cd "$$proj.dir" && \
  if [ -d CMakeFiles -o -f CMakeCache.txt ] ; then rm -R CMake*; fi && \
  if [ -d Proj-prefix ] ; then rm -R Proj-prefix; fi && \
  cmake "$$PWD" $$CMAKE_ARGS && \
  PATH="$$NDK_TOOLCHAIN_PATH/bin:${PATH}" $(MAKE) VERBOSE=$(VERBOSE) all && \
  $(MAKE) clean VERBOSE=$(VERBOSE)

QMAKE_EXTRA_TARGETS += proj
PRE_TARGETDEPS      += $$proj.target
QMAKE_CLEAN         += $$proj.target

PROJ_PRI = \
  "$$LITERAL_HASH Generated by $$_PRO_FILE_" \
  "DEPENDPATH  += $$proj.dir/Proj-prefix/include" \
  "INCLUDEPATH += $$proj.dir/Proj-prefix/include"
win32: PROJ_PRI += \
  "LIBS        += \"-L$$proj.dir/Proj-prefix/bin\""
else: PROJ_PRI += \
  "LIBS        += \"-L$$proj.dir/Proj-prefix/lib\""
android: PROJ_PRI += \
  "ANDROID_EXTRA_LIBS += \"$$proj.target\""

write_file($$OUT_PWD/proj.pri, PROJ_PRI)

android|win32 {
  INSTALLS += proj_data
  proj_data.prefix =
  android: proj_data.prefix = /assets
  proj_data.extra  = $(MAKE) -C proj/Proj-prefix/src/Proj-build/nad install-data DESTDIR=$(INSTALL_ROOT) prefix= datarootdir=$$proj_data.prefix
  proj_data.path   = $$proj_data.prefix/proj
}

OTHER_FILES += \
  CMakeLists.txt \
  COPYING        \
  proj-config.in \
  proj-make.in   \
  proj-patch.in  \
  proj-postinstall.in
