name="Font Tools"
author="mDuo13"
help="""You can change your font in chat by typing '/myfont *key*'
where *key* is this plugin's shorthand for a font, like 'c'
for Courier. You can type /myfont list for the whole list.
You can use another font by typing '/myfont custom=*name*', where
*name* is the EXACT name of the font, case-sensitive and all.
Font resizing is no longer supported by the plugin as it is in
the official code now. (Try typing '/fontsize *x*' to change your
font to size *x*.)"""
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------

import os

chat=None
session=None
tree=None
openrpg=None

fontstring = ''

fontlist = {"a" : "",
        "arial" : "",
        "c" : "<font face='Courier New, Courier, monospace'>",
        "courier" : "<font face='Courier New, Courier, monospace'>",
        "t" : "<font face='Times New Roman, Times, serif'>",
        "times" : "<font face='Times New Roman, Times, serif'>",
        "tempus" : "<font face='Tempus Sans ITC'>",
        "westminster" : "<font face='Westminster' size=+1>",
        "mistral" : "<font face='Mistral' size=+2>",
        "lucida sans" : "<font face='Lucida Sans'>",
        "lucida handwriting" : "<font face='Lucida Handwriting'>",
        "western" : "<font face='Rockwell'>",
        "rockwell" : "<font face='Rockwell'>"}




#This is the name of your plugin. Make sure it's not the same as another
#plugin's name


##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

def load(self):
    # This is called when the plugin is imported, Do not use this for anything
    # except initializing global settings that are gathered from the plugindb
    global fontstring
    fontstring = plugindb.GetString("xxfontchng", "fontstring", "")

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    global fontstring

    if text[:3]=="/me":
        text= "/me "+fontstring+text[4:]+"</font>"
    elif text[:2]=="/w":
        text=text[:text.find("=")+1]+fontstring+text[text.find("=")+1:]+"</font>"
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    if fontstring.find("<font") > -1:
        text = fontstring + text + "</font>"
    return text, send

def receive_msg(self, text, type, name, player):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the format for the player variable.
    #print player
    posted = 0#If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever a message written is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    global fontstring, fontlist

    if cmdlist[0] != "/myfont":
        return 0

    try:
        if cmdlist[1]=="list":
            the_list = ""
            for entry in fontlist.keys():
                the_list+=fontlist[entry]+entry+"</font><br>"
            the_list+="custom *anyfont*"
            chat.Post(the_list)
        elif cmdlist[1] == "custom":
            fontstring = "<font face='"+cmdlist[2]+"'>"
        elif fontlist.has_key(cmdlist[1]):
            fontstring = fontlist[cmdlist[1]]
            chat.Post("Your font now looks "+fontstring+"like this.</font>")
            plugindb.SetString("xxfontchng", "fontstring", fontstring)
    except:
        the_list = ""
        for entry in fontlist.keys():
            the_list+=fontlist[entry]+entry+"</font><br>"
        the_list+="custom *anyfont*"
        chat.Post(the_list)

    return 1

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    pass

def close_module(self):
    #This is called when OpenRPG shuts down
    pass
