name="Initiative Tool"
author="Woody, Darloth, updated by mDuo13"
help="""This is the ever-popular init tool. To learn how to use it, type \
'/inittoolhelp'. It will load the a help node into your game tree."""
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------
from string import find, replace
import os
import orpg.dirpath

chat=None
session=None
tree=None
openrpg=None

class v:
    toggle=1
    init_list=[]
    backup_list=[]

              #std, wod, 3e
    tool_type="std"
    wod_counter=0

##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    return text, send

def receive_msg(self, text, type, name, player):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the format for the player variable.
    #print player
    posted = 0#If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever any message is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    if v.toggle:
        if myself==1:
            if text.lower().find("init") != -1:
                #player=self.chat_display_name(self.session.get_my_info())
                player=text[:text.find("[")]
                init=text[text.rfind("(")+1:text.rfind(")")]
        else:
            if text.lower().find("init") != -1:
                player=text[text.find("</B>")+4:text.find("[")]
                init=text[text.rfind("(")+1:text.rfind(")")]
        try:
            if text.lower().find("init") != -1:
                init=int(init)
                v.init_list+=[[init,player]]
                v.backup_list+=[[init,player]]
        except:
            pass
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    if text=="/inittoolhelp":
        f = open(orpg.dirpath.dir_struct["plugins"]+ "inittool.xml","r")
        gametree.insert_xml(f.read())
        f.close()
        return 1
    if text=="/init":
        if v.toggle:
            v.toggle=0
            chat.Post("<font color='#ff0000'>Init recording off</font>")
        else:
            chat.Post("<font color='#ff0000'>Init recording on</font>")
            v.toggle=1

    elif text[:5]=="/type":
        if len(cmdlist) >=2:
            if cmdlist[1]=="std" or cmdlist[1]=="wod" or cmdlist[1]=="3e" or cmdlist[1]=="srun":
                v.tool_type=cmdlist[1]
                chat.Post("<font color='#ff0000'>Initiative tool now set to '"+v.tool_type+"'</font>")
            else:
                chat.Post("<font color='#ff0000'>Unknown Initiative tool type: "+cmdlist[1])
        else:
            chat.Post("<font color='#ff0000'>currently using the '"+v.tool_type+"' Initiative tool type</font>")

    elif text=="/clear"or text=="/new" or text=="/start":
        v.init_list=[]
        v.backup_list=[]
        v.wod_counter=0
        tmp=v.toggle
        v.toggle=0
        chat.Post("<hr><font color='#ff0000'>New Initiative</font><br><font color='#0000ff'>Roll new Initiatives</font>",1)
        v.toggle=tmp

    elif text[:4]=="/add":
        txt=text.split(None, 2)
        try:
            if len(txt) == 3:
                new_init=int(txt[1])
                v.init_list+=[[new_init, txt[2]]]
                v.backup_list+=[[new_init, txt[2]]]
                list_inits()
        except:
            post_my_msg("<font color='#ff0000'>Invalid format.  correct command is: /add init_number description</font>")
    elif text[:4]=="/del":
        try:
            txt=text.split(None,1)
            del v.init_list[int(txt[1])-1]
            del v.backup_list[int(txt[1])-1]
            list_inits()
        except:
            tmp=v.toggle
            v.toggle=0
            chat.Post("<font color='#ff0000'>Invalid format.  correct command is: /del list_number</font>")
            v.toggle=tmp

    elif text=="/list":
        list_inits()
    elif text=="/backuplist":
        list_backups()

    elif text=="/sort" or text=="/low" or text=="/sortlow":
        v.init_list.sort()
        v.backup_list.sort()
        list_inits()

    elif text=="/high" or text=="/sorthigh" or text=="/reverse":
        v.init_list.sort()
        v.init_list.reverse()
        v.backup_list.sort()
        v.backup_list.reverse()
        list_inits()

    elif text=="/run" or text=="/go":
        if len(v.init_list):
            id=str(v.init_list[0][0])
            player=str(v.init_list[0][1])
            del v.init_list[0]
            tmp=v.toggle
            v.toggle=0      #have to disable the tool in order to post or else you get a clone
            chat.Post("<hr><font color='#ff0000'>Next init:</font><br><font color='#0000ff'><b>("+id+")</b>: "+player+"</font>",1)
            v.toggle=tmp
        else:
            if (v.tool_type=="std") or (v.tool_type=="wod" and v.wod_counter==1):
                v.backup_list=[]
                v.init_list=[]
                v.wod_counter=0
                post_my_msg("<hr><font color='#ff0000'>End of Initiative Round</font>",1)
            elif v.tool_type=="3e":
                v.init_list+=v.backup_list
                post_my_msg("<hr><font color='#ff0000'>End of Initiative Round, Starting New Initiative Round</font>",1)
            elif v.tool_type=="wod" and v.wod_counter==0 and len(v.backup_list) > 0:
                post_my_msg("<hr><font color='#ff0000'>Starting physical initiatives:</font>",1)
                v.wod_counter=1
                v.init_list=v.backup_list
                v.init_list.sort()
                v.init_list.reverse()
            elif v.tool_type=="srun":
                for m in v.backup_list[:]:
                    m[0] -= 10
                    if m[0] <= 0:
                        v.backup_list.remove(m)
                if len(v.backup_list):
                    post_my_msg("<hr><font color='#ff0000'>End of Initiative Pass, starting next Pass</font>",1)
                    v.init_list+=v.backup_list
                else:
                    post_my_msg("<hr><font color='#ff0000'>End of Combat Turn, roll new initiatives please</font>",1)
                    v.init_list=[]
                    v.backup_list=[]

    elif text[:7]=="/change" and len(text.split())==3:
        try:
            txtlist=text.split()
            id=int(txtlist[1])-1
            new_init=int(txtlist[2])
            v.init_list[id][0]=new_init
            v.backup_list[id][0]=new_init
            list_inits()
        except:
            tmp=v.toggle
            v.toggle=0
            chat.Post("<font color='#0000ff'>Invalid format.  correct command is: /change list_# new_init_# (example: /change 1 4)</font>")
            v.toggle=tmp
    else:
        return 0
    return 1

def post_my_msg(msg,send=0):
    tmp=v.toggle
    v.toggle=0      #have to disable the tool in order to post or else you get a clone
    chat.Post(msg,send)
    v.toggle=tmp


def list_inits():
    msg="Initiatives:<br>"
    for m in v.init_list:
        msg+= " <font color='#ff0000'>" + str(v.init_list.index(m)+1)+"</font>"
        msg+= ": <font color='#0000ff'>(" + str(m[0]) + ") "
        msg+= m[1] + "</font><br>"
    tmp=v.toggle
    v.toggle=0
    chat.Post(msg)
    v.toggle=tmp


def list_backups():
    msg="backup list:<br>"
    for m in v.backup_list:
        msg+= " <font color='#ff0000'>" + str(v.backup_list.index(m)+1)+"</font>"
        msg+= ": <font color='#0000ff'>(" + str(m[0]) + ") "
        msg+= m[1] + "</font><br>"
    tmp=v.toggle
    v.toggle=0
    chat.Post(msg)
    v.toggle=tmp

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    pass

def close_module(self):
    #This is called when OpenRPG shuts down
    pass
