/*      -*- OpenSAF  -*-
 *
 * (C) Copyright 2008 The OpenSAF Foundation
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. This file and program are licensed
 * under the GNU Lesser General Public License Version 2.1, February 1999.
 * The complete license can be accessed from the following location:
 * http://opensource.org/licenses/lgpl-license.php
 * See the Copying file included with the OpenSAF distribution for full
 * licensing terms.
 *
 * Author(s): Emerson Network Power
 *
 */

#ifndef MQA_LOG_H
#define MQA_LOG_H

/******************************************************************************
 Logging offset indexes for MQA Headline logging
 ******************************************************************************/
typedef enum mqa_hdln_log_flex {
	MQA_CB_CREATE_FAILED,
	MQA_CB_DESTROY_FAILED,
	MQA_CLIENT_TREE_INIT_FAILED,
	MQA_CLIENT_TREE_ADD_FAILED,
	MQA_CLIENT_TREE_DEL_FAILED,
	MQA_CLIENT_TREE_DESTROY_FAILED,
	MQA_QUEUE_TREE_INIT_FAILED,
	MQA_QUEUE_TREE_ADD_FAILED,
	MQA_QUEUE_TREE_DEL_FAILED,
	MQA_QUEUE_TREE_DESTROY_FAILED,
	MQA_TAKE_HANDLE_FAILED,
	MQA_CREATE_HANDLE_FAILED,
	MQA_MDS_REGISTER_SUCCESS,
	MQA_MDS_REGISTER_FAILED,
	MQA_ASAPi_REGISTER_FAILED,
	MQA_ASAPi_UNREGISTER_FAILED,
	MQA_ASAPi_OPERATION_SUCCESS,
	MQA_ASAPi_OPERATION_FAILED,
	MQA_SE_API_CREATE_SUCCESS,
	MQA_SE_API_CREATE_FAILED,
	MQA_SE_API_DESTROY_SUCCESS,
	MQA_SE_API_DESTROY_FAILED,
	MQA_SE_API_UNKNOWN_REQUEST,
	MQA_CB_RETRIEVAL_FAILED,
	MQA_VERSION_INCOMPATIBLE,
	MQA_MDS_GET_HANDLE_FAILED,
	MQA_MDS_CALLBK_FAILURE,
	MQA_MDS_CALLBK_UNKNOWN_OP,
	MQA_TIMER_TABLE_INIT_FAILED,
	MQA_TRACK_TREE_ADD_FAILED,
	MQA_TRACK_TREE_DEL_FAILED,
	MQA_API_MSG_GROUP_ADD_FAIL,
	MQA_API_MSG_GROUP_DEL_FAIL,
	MQA_API_MSG_GROUP_DEL_SUCCESS,
	MQA_API_MSG_GROUP_INSERT_FAIL,
	MQA_API_MSG_GROUP_INSERT_SUCCESS,
	MQA_API_MSG_GROUP_REMOVE_FAIL,
	MQA_API_MSG_GROUP_REMOVE_SUCCESS,
	MQA_CB_LOCK_INIT_FAILED,
	MQA_EDU_HDL_INIT_FAILED,
	MQA_REGISTER_WITH_ASAPi_FAILED,
	MQA_SYNC_WITH_MQD_UP,
	MQA_SYNC_WITH_MQND_UP,
	MQA_MQD_ALREADY_UP,
	MQA_MQND_ALREADY_UP,
	MQA_CREATE_HANDLE_SUCCESS,
	MQA_CB_LOCK_INIT_SUCCESS,
	MQA_CLIENT_TREE_INIT_SUCCESS,
	MQA_QUEUE_TREE_INIT_SUCCESS,
	MQA_EDU_HDL_INIT_SUCCESS,
	MQA_MDS_INSTALL_FAILED,
	MQA_MDS_SUBSCRIPTION_ND_FAILED,
	MQA_MDS_SUBSCRIPTION_D_FAILED,
	MQA_MDS_DEREGISTER_FAILED,
	MQA_MDS_ENC_FAILED,
	MQA_MDS_DEC_FAILED,
	MQA_STOP_DELETE_TMR_SUCCESS,
	MQA_STOP_DELETE_TMR_FAILED,
	MQA_ASAPi_MSG_RECEIVE_FAILED,
	MQA_MQND_DOWN,
	MQA_MQD_DOWN,
	MQA_MQND_UP,
	MQA_MQD_UP,
	MQA_CB_TIMER_INIT_FAILED,
	MQA_CB_TMR_DELETE_FAILED,
	MQA_CB_TMR_STOP_FAILED,
	MQA_CB_TMR_START_FAILED,
	MQA_CB_TMR_CREATE_FAILED,
	MQA_CLIENT_TREE_FIND_FAILED,
	MQA_QUEUE_READER_TASK_CREATE_FAILED,
	MQA_QUEUE_READER_TASK_START_FAILED,
	MQA_QUEUE_TREE_FIND_FAILED,
	MQA_TRACK_TREE_FIND_AND_DEL_FAILED,
	MQA_CLBK_QUEUE_WRITE_FAILED,
	MQA_NOTIFY_CHANGES_FAILED,
	MQA_NOTIFY_CHANGES_ONLY_FAILED,
	MQA_CLBK_QUEUE_INIT_FAILED,
	MQA_NCS_AGENTS_START_FAILED,
	MQA_INVALID_PARAM,
	MQA_MQD_OR_MQND_DOWN,
	MQA_LOCK_WRITE_FAILED,
	MQA_FINALIZE_CLOSE_FAILED,
	MQA_OPEN_CALLBACK_MISSING,
	MQA_RECEIVE_CALLBACK_MISSING,
	MQA_CREATE_AND_START_TIMER_FAILED,
	MQA_QUEUES_NOT_AVLBL_IN_GROUP,
	MQA_INVALID_MSG_SIZE,
	MQA_DELIVERED_CALLBACK_MISSING,
	MQA_ASAPi_GETDEST_FAILED,
	MQA_ASAPi_GETDEST_CACHE_NOT_EXIST,
	MQD_ASAPi_REG_FAILED,
	MQD_ASAPi_DEREG_FAILED,
	MQD_ASAPi_GROUP_INSERT_FAILED,
	MQD_ASAPi_GROUP_REMOVE_FAILED,
	MQD_ASAPi_TRACK_FAILED,
	MQA_MSG_GET_NATIVE_QUEUE_ERROR,
	MQA_MSG_UNABLE_TO_PUT_GENUINE_MESSAGE,
	MQA_MSG_UNABLE_TO_PUT_STOP_TIMER_MESSAGE,
	MQA_SENDERID_LIST_INSERTION_FAILED,
	MQA_MSG_UNABLE_TO_PUT_CANCEL_MESSAGE,
	MQA_INVALID_MSG_PRIORITY,
	MQA_SENDRECV_SEND_FAILED,
	MQA_MSG_NO_SPACE,
	MQA_SENDER_INFO_DOES_NOT_EXIST,
	MQA_INVALID_GROUP_POLICY,
	MQA_INVALID_TRACK_FLAGS,
	MQA_CLIENT_TREE_FIND_AND_ADD_FAILED,
	MQA_TRACK_TREE_FIND_FAILED,

	/* MEMALLOC FAILURE FLEX */
	MQA_CB_ALLOC_FAILED,
	MQA_CLIENT_ALLOC_FAILED,
	MQA_QUEUE_ALLOC_FAILED,
	MQA_EVT_ALLOC_FAILED,
	MQA_TIMER_NODE_ALLOC_FAILED,
	MQA_TRACK_ALLOC_FAILED,
	MQP_ASYNC_RSP_MSG_ALLOC_FAILED,
	MQP_OPEN_RSP_ALLOC_FAILED,
	MQA_TRACK_BUFFER_INFO_ALLOC_FAILED,
	MQA_CANCEL_REQ_ALLOC_FAILED,
	MQA_MEMORY_ALLOC_FAILED,

	/* API FAILURE FLEX */
	MQA_API_MSG_INITIALIZE_FAIL,
	MQA_API_MSG_INITIALIZE_SUCCESS,
	MQA_API_MSG_SELECTION_OBJECT_FAIL,
	MQA_API_MSG_SELECTION_OBJECT_SUCCESS,
	MQA_API_MSG_DISPATCH_FAIL,
	MQA_API_MSG_DISPATCH_SUCCESS,
	MQA_API_MSG_FINALIZE_FAIL,
	MQA_API_MSG_FINALIZE_SUCCESS,
	MQA_API_QUEUE_OPEN_SYNC_FAIL,
	MQA_API_QUEUE_OPEN_SYNC_SUCCESS,
	MQA_API_QUEUE_OPEN_ASYNC_FAIL,
	MQA_API_QUEUE_OPEN_ASYNC_SUCCESS,
	MQA_API_QUEUE_CLOSE_SYNC_FAIL,
	MQA_API_QUEUE_CLOSE_SYNC_SUCCESS,
	MQA_API_QUEUE_STATUS_GET_SYNC_FAIL,
	MQA_API_QUEUE_STATUS_GET_SYNC_SUCCESS,
	MQA_API_QUEUE_UNLINK_SYNC_FAIL,
	MQA_API_QUEUE_UNLINK_SYNC_SUCCESS,
	MQA_DISPATCH_ALL_CALLBK_FAIL,
	MQA_API_QUEUE_SEND_SYNC_FAIL,
	MQA_API_QUEUE_SEND_SYNC_SUCCESS,
	MQA_API_QUEUE_SEND_ASYNC_FAIL,
	MQA_API_QUEUE_SEND_ASYNC_SUCCESS,
	MQA_API_QUEUE_MESSAGE_GET_FAIL,
	MQA_API_QUEUE_MESSAGE_GET_SUCCESS,
	MQA_API_QUEUE_MESSAGE_CANCEL_FAIL,
	MQA_API_QUEUE_MESSAGE_CANCEL_SUCCESS,
	MQA_API_QUEUE_SENDRCV_FAIL,
	MQA_API_QUEUE_SENDRCV_SUCCESS,
	MQA_API_QUEUE_REPLY_SYNC_FAILED,
	MQA_API_QUEUE_REPLY_SYNC_SUCCESS,
	MQA_API_QUEUE_REPLY_ASYNC_FAILED,
	MQA_API_QUEUE_REPLY_ASYNC_SUCCESS,
	MQD_API_GROUP_CREATE_FAILED,
	MQD_API_GROUP_CREATE_SUCCESS,
	MQA_API_MSG_GROUP_TRACK_FAIL,
	MQA_API_MSG_GROUP_TRACK_SUCCESS,
	MQA_API_MSG_GROUP_TRACK_STOP_FAIL,
	MQA_API_MSG_GROUP_TRACK_STOP_SUCCESS,

	/* MDS FAILURE FLEX */
	MQA_MDS_SEND_FAILURE,
	MQA_MDS_SEND_TIMEOUT,
	MQA_MSG_FRMT_VER_INVALID
} MQA_HDLN_LOG_FLEX;
/******************************************************************************
 Logging offset indexes for canned constant strings for the ASCII SPEC
 ******************************************************************************/

typedef enum mqa_flex_sets {
	MQA_FC_HDLN,
} MQA_FLEX_SETS;

typedef enum mqa_log_ids {
	MQA_LID_HDLN,
} MQA_LOG_IDS;

EXTERN_C uns32 mqa_log_ascii_reg(void);
EXTERN_C void mqa_log_ascii_dereg(void);
EXTERN_C uns32 mqa_reg_strings();

#if((NCS_DTA == 1) && (NCS_MQSV_LOG == 1))
EXTERN_C void mqa_log(uns8 id, uns32 category, uns8 sev, uns32 rc, char *fname, uns32 fno);
EXTERN_C void mqa_flx_log_reg(void);
EXTERN_C void mqa_flx_log_dereg(void);

#define m_LOG_MQSV_A(id,category,sev,rc,fname,fno)  mqa_log(id,category,sev,rc,fname,fno)
#else
#define m_LOG_MQSV_A(id,category,sev,rc,fname,fno)
#endif

#endif
