/*
 *  Copyright 2001-2005 Internet2
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* SAMLIdentifier.cpp - wraps ID generation functionality

   Scott Cantor
   5/22/02

   $History:$
*/

#include "internal.h"

#include <xsec/enc/XSECCryptoException.hpp>
#include <xsec/utils/XSECPlatformUtils.hpp>

using namespace saml;
using namespace std;

void SAMLIdentifier::generateRandomBytes(void* buf, unsigned int len)
{
    try {
        if (XSECPlatformUtils::g_cryptoProvider->getRandom(reinterpret_cast<unsigned char*>(buf),len)<len)
            throw InvalidCryptoException("Unable to generate random data; was PRNG seeded?");
    }
    catch (XSECCryptoException& e) {
        throw InvalidCryptoException("Unable to generate random data: $1",params(1,e.getMsg()));
    }
}

void SAMLIdentifier::generateRandomBytes(std::string& buf, unsigned int len)
{
    buf.erase();
    auto_ptr<unsigned char> hold(new unsigned char[len]);
    generateRandomBytes(hold.get(),len);
    for (unsigned int i=0; i<len; i++)
        buf+=(hold.get())[i];
}

SAMLIdentifier::SAMLIdentifier()
{
    unsigned char key[17];
    generateRandomBytes(key,16);
    
    char hexform[34];
    sprintf(hexform,"_%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
            key[0],key[1],key[2],key[3],key[4],key[5],key[6],key[7],
            key[8],key[9],key[10],key[11],key[12],key[13],key[14],key[15]);
    hexform[33]=0;
    m_buffer=XMLString::transcode(hexform);
}

SAMLIdentifier::~SAMLIdentifier()
{
    XMLString::release(&m_buffer);
}
