/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cxxtest/TestSuite.h>
#include <cxxtest/GlobalFixture.h>

#include <saml/saml.h>
//#include <log4cpp/Category.hh>
//#include <log4cpp/OstreamAppender.hh>

using namespace saml;
//using namespace log4cpp;

class SAMLFixture : public CxxTest::GlobalFixture
{
public:
    bool setUpWorld() {
        const char* path=getenv("SAMLSCHEMAS");
        if (path)
            SAMLConfig::getConfig().schema_dir=path;
        else
            SAMLConfig::getConfig().schema_dir="\\opt\\shibboleth\\share\\xml\\shibboleth";

        //Category& root = Category::getRoot();
        //root.setPriority(Priority::DEBUG);
        //root.setAppender(new OstreamAppender("default",&std::cerr));

        return SAMLConfig::getConfig().init();
    }
    bool tearDownWorld() {
        SAMLConfig::getConfig().term();
        return true;
    }
    //bool setUp() { printf( "</test>" ); return true; }
    //bool tearDown() { printf( "</test>" ); return true; }
};

static SAMLFixture globalFixture;

class DummyTest : public CxxTest::TestSuite
{
public:
    void testDummy(void) {
    }
};
