/**********************************************************************
 *
 *	FILE:			DirectionalSector.cpp
 *
 *	DESCRIPTION:	Read/Write osgSim::DirectionalSector in binary format to disk.
 *
 *	CREATED BY:		Auto generated by iveGenerator.exe
 *					and later modified by Rune Schmidt Jensen.
 *
 *	HISTORY:		Created 9.9.2003
 *
 **********************************************************************/

#include "Exception.h"
#include "DirectionalSector.h"

using namespace ive;

void DirectionalSector::write(DataOutputStream* out){
	// Write DirectionalSector's identification.
	out->writeInt(IVEDIRECTIONALSECTOR);
	// Write DirectionalSector's properties.
	out->writeVec3(getDirection());
   out->writeFloat(getHorizLobeAngle());
   out->writeFloat(getVertLobeAngle());
   out->writeFloat(getLobeRollAngle());
   out->writeFloat(getFadeAngle());
}

void DirectionalSector::read(DataInputStream* in){
	// Peek on DirectionalSector's identification.
	int id = in->peekInt();
	if(id == IVEDIRECTIONALSECTOR){
		// Read DirectionalSector's identification.
		id = in->readInt();
		// Read DirectionalSector's properties
		setDirection(in->readVec3());
      setHorizLobeAngle(in->readFloat());
      setVertLobeAngle(in->readFloat());
      setLobeRollAngle(in->readFloat());
      setFadeAngle(in->readFloat());

	}
	else{
		throw Exception("DirectionalSector::read(): Expected DirectionalSector identification.");
	}
}
