/* -*-c++-*- Producer - Copyright (C) 2001-2004  Don Burns
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
 */

#include <Producer/Export>
#include <Producer/RenderSurface>

#ifdef _OSX_CGL_IMPLEMENTATION

#include <Carbon/Carbon.h>
#include <OpenGL/OpenGL.h>

using namespace Producer;

bool RenderSurface::realize(Producer::VisualChooser *vc, GLContext shared_context)
{
    _sharedGlcontext = shared_context;

    _init();

    _realized = true;
    _realizeBlock->release();

    std::vector <Producer::ref_ptr<Callback> >::iterator p;
    for( p = _realizeCallbacks.begin(); p != _realizeCallbacks.end(); p++ )
    {
        if( (*p).valid() )
            (*(*p).get())( *this );
    }
    _realizeCallbacks.clear();

    return _realized;

}

bool RenderSurface::makeCurrent() const
{
    CGLSetCurrentContext(_glcontext);
    return true;
}

void RenderSurface::swapBuffers()
{
    CGLFlushDrawable(_glcontext);
}

void RenderSurface::run()
{
}

void RenderSurface::sync(int)
{
}

void RenderSurface::fullScreen( bool flag )
{
}

unsigned int RenderSurface::getNumberOfScreens()
{
    /*  From James Hopper:
        change it to just return 1.  my previous patch only grabs 1 screen and
        so it works right with multiscreen macs.  but if some of the osgsamples
        blow up because they end up calling this and getting the wrong number
        of screens.
        */
    /*
    if( _numScreens == UnknownAmount )
    {
        if( CGGetActiveDisplayList( 0, NULL, &_numScreens ) != CGDisplayNoErr )
        {
            std::cerr << "CGGetActiveDisplayList() falied\n";
            _numScreens = UnknownAmount;
            return 0;
        }
    }
    */
    _numScreens = 1;
    return _numScreens;
}

#if 0
static Display *_openDisplay(unsigned int num)
{
    static Display *displays = NULL;
    static CGDisplayCount numDisplays = RenderSurface::getNumberOfScreens();

    if( displays == NULL )
    {
        if( numDisplays == 0 )
        {
            std::cerr << "openDisplay: No Displays!\n";
            return NULL;
        }

        displays = new Display[numDisplays];
        if( CGGetActiveDisplayList( numDisplays, displays, &numDisplays ) != CGDisplayNoErr )
        {
            std::cerr << "CGGetActiveDisplayList() falied\n";
            return NULL;
        }
    }

    if( num > numDisplays )
    {
        std::cerr << "OpenDisplay(): " << num << " is out of range.\n";
        return NULL;
    }

    return &displays[num];
}
#endif

// get a double value from a dictionary
static double getDictDouble (CFDictionaryRef refDict, CFStringRef key)
{
   double double_value;
   CFNumberRef number_value = (CFNumberRef) CFDictionaryGetValue(refDict, key);
   if (!number_value) // if can't get a number for the dictionary
       return -1;  // fail
   if (!CFNumberGetValue(number_value, kCFNumberDoubleType, &double_value)) // or if cant convert it
        return -1; // fail
    return double_value; // otherwise return the long value
}

bool RenderSurface::_init()
{
    _dpy = new CGDirectDisplayID;     
    *_dpy = CGMainDisplayID();         
    CGDisplayCapture(*_dpy);

    if( _windowWidth == UnknownDimension )
        _windowWidth = CGDisplayPixelsWide(*_dpy);

    if( _windowHeight == UnknownDimension )
        _windowHeight = CGDisplayPixelsHigh(*_dpy);

       // add next line and on following line replace hard coded depth and refresh rate
    CGRefreshRate refresh =  getDictDouble (CGDisplayCurrentMode (*_dpy), kCGDisplayRefreshRate);  
    CFDictionaryRef display_mode_values =
    CGDisplayBestModeForParametersAndRefreshRate(*_dpy, CGDisplayBitsPerPixel (*_dpy), 
                    _windowWidth,_windowHeight,  
                    refresh,  
                    NULL);

    CGDisplaySwitchToMode(*_dpy, display_mode_values);

    _screenWidth = _windowWidth  =  CGDisplayPixelsWide(*_dpy);
    _screenHeight = _windowHeight =  CGDisplayPixelsHigh(*_dpy);

    CGLPixelFormatObj pixel_format;
    _choosePixelFormat( &pixel_format );
    CGLCreateContext( pixel_format, NULL, &_glcontext );

    CGLDestroyPixelFormat( pixel_format );
    makeCurrent();

    CGLSetFullScreen(_glcontext);

    // Add sync support by default:
    GLint swap = 1;
    CGLSetParameter (_glcontext, kCGLCPSwapInterval, &swap);

    return true;
}

void RenderSurface::_fini()
{
    
    if( _glcontext )
    {
        CGLClearDrawable(_glcontext);                                                   
        CGLDestroyContext(_glcontext);                                                  
        CGLSetCurrentContext(NULL);                                                      
    }
    if( _dpy )
        CGDisplayRelease(*_dpy);                                                           
}

void RenderSurface::_setBorder(bool)
{
}

void RenderSurface::_useCursor(bool)
{
}

void RenderSurface::_setCursor( Cursor )
{
}

void RenderSurface::_setCursorToDefault()
{
}

void RenderSurface::_resizeWindow()
{
    _windowWidth =  CGDisplayPixelsWide(*_dpy);
    _windowHeight =  CGDisplayPixelsHigh(*_dpy);
}

void RenderSurface::_positionPointer(int, int)
{
}


void RenderSurface::_computeScreenSize(unsigned int &width, unsigned int &height) const
{
    width =  CGDisplayPixelsWide(*_dpy);
    height =  CGDisplayPixelsHigh(*_dpy);
}

void RenderSurface::bindPBufferToTexture(BufferType /*buffer*/) const
{
    // Ok... a bit of a hack.
    glCopyTexSubImage2D( GL_TEXTURE_2D, 0, 0, 0, 0, 0, _windowWidth, _windowHeight);
}


int RenderSurface::_adaptPixelAttribute( PixelAttribute &attr, VisualInfo *vinfo )
{
    switch( attr.attribute() )
    {
        case UseGL:          return kCGLPFACompliant;
        case BufferSize:     return kCGLPFAColorSize;
        //case Level:          return GLX_LEVEL;
        //case RGBA:           return GLX_RGBA;
        case DoubleBuffer:   return kCGLPFADoubleBuffer;
        case Stereo:         return kCGLPFAStereo;
        case AuxBuffers:     return kCGLPFAAuxBuffers;
        case RedSize:        return kCGLPFAColorSize;
        case GreenSize:      return kCGLPFAColorSize;
        case BlueSize:       return kCGLPFAColorSize;
        case AlphaSize:      return kCGLPFAAlphaSize;
        case DepthSize:      return kCGLPFADepthSize;
        case StencilSize:    return kCGLPFAStencilSize;
        case AccumRedSize:   return kCGLPFAAccumSize;
        case AccumGreenSize: return kCGLPFAAccumSize;
        case AccumBlueSize:  return kCGLPFAAccumSize;
        case AccumAlphaSize: return kCGLPFAAccumSize;
        default: return (int)attr.attribute();
    }
    return 0;
}


void RenderSurface::_choosePixelFormat( VisualInfo *vinfo )
{
    if( _pixelAttributes.size() == 0 )
        setSimplePixelConfiguration();

    std::vector<CGLPixelFormatAttribute>va;

    u_int32_t display_id = CGDisplayIDToOpenGLDisplayMask(*_dpy);

    va.clear();
    va.push_back( kCGLPFADisplayMask );
    va.push_back( (CGLPixelFormatAttribute)display_id);
    va.push_back( kCGLPFANoRecovery );
    va.push_back( kCGLPFAAccelerated );
    va.push_back( kCGLPFAFullScreen );

    std::vector<PixelAttribute>::iterator p;
    for( p = _pixelAttributes.begin(); p != _pixelAttributes.end(); p++ )
    {
        va.push_back( CGLPixelFormatAttribute(_adaptPixelAttribute((*p), 0L)));
         if( (*p).hasParameter() )
            va.push_back( CGLPixelFormatAttribute((*p).parameter()) );
    }
    va.push_back(CGLPixelFormatAttribute(0));

    long nvirt;                                                          
    CGLPixelFormatAttribute *array = new CGLPixelFormatAttribute[va.size()];

    std::vector<CGLPixelFormatAttribute>::iterator pp;
    int index = 0;
    for( pp = va.begin(); pp != va.end(); pp++ )
	array[index++] = *pp;

    //CGLChoosePixelFormat(&(va.front()), vinfo, &nvirt);          
    CGLChoosePixelFormat(array, vinfo, &nvirt);          
}



void _setCursor()
{
}

void _positionPointer(int x, int y)
{
}

void _resizeWindow()
{
}

void _fini()
{
}

void RenderSurface::_useOverrideRedirect( bool )
{
    // Ignored on OSX CGL.  Flag value remains false.
}

void RenderSurface::_setWindowName( const std::string &name )
{
    if( !_realized )
        return;
}

void RenderSurface::_initThreads()
{
    // Ignored...
}


#endif

