/**********************************************************************
 *
 *    FILE:            EllipsoidModel.cpp
 *
 *    DESCRIPTION:    Read/Write osg::EllipsoidModel in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 23.4.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "Object.h"
#include "EllipsoidModel.h"
#include "ConvexPlanarPolygon.h"

using namespace ive;

void EllipsoidModel::write(DataOutputStream* out){
    // Write EllipsoidModel's identification.
    out->writeInt(IVEELLIPSOIDMODEL);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("EllipsoidModel::write(): Could not cast this osg::EllipsoidModel to an osg::Object.");
    // Write EllipsoidModel's properties.

    out->writeDouble(getRadiusEquator());
    out->writeDouble(getRadiusPolar());

}

void EllipsoidModel::read(DataInputStream* in){
    // Peek on EllipsoidModel's identification.
    int id = in->peekInt();
    if(id == IVEELLIPSOIDMODEL){
        // Read EllipsoidModel's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("EllipsoidModel::read(): Could not cast this osg::EllipsoidModel to an osg::Object.");
        // Read EllipsoidModel's properties

        setRadiusEquator(in->readDouble());
        setRadiusPolar(in->readDouble());
        

    }
    else{
        in_THROW_EXCEPTION("EllipsoidModel::read(): Expected EllipsoidModel identification.");
    }
}
