/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
** Copyright (C) 2003 Guilhem Bonnefille <guilhem.bonnefille@free.fr>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <iostream>
#include <cstdio>
#include <cstring>
#include <cstdarg>

using namespace std;

#include "messenger.h"

/// Storage
bool MESSENGER::_globalDebug = false;

/// Format a message
/// \param buf buffer where to format the message
void MESSENGER::Format(char *buf, const char *fmt, va_list args)
{
  vsprintf(buf, fmt, args);
}

/// Format a message
/// \param buf buffer where to format the message
void MESSENGER::Format(char *buf, const char *fmt, ...)
{
  va_list args;
 
  va_start(args, fmt);
  Format(buf, fmt, args);
  va_end(args);
}

/// Display an error message
void MESSENGER::Error(const char *fmt, va_list args)
{
  char buf[1024];
 
  Format(buf, fmt, args);
  
  cerr << buf << endl;
}

/// Display an error message
void MESSENGER::Error(const char *fmt, ...) 
{
  va_list args;
 
  va_start(args, fmt);
  Error(fmt, args);
  va_end(args);
}

/// Display a warning
void MESSENGER::Warning(const char *fmt, va_list args)
{
  char buf[1024];

  sprintf(buf,"WARNING: ");
  Format(buf+strlen(buf), fmt, args);
  
  cerr << buf << endl;
}

/// Display a warning
void MESSENGER::Warning(const char *fmt, ...) 
{
  char buf[1024];
  va_list args;
 
  va_start(args, fmt);
  Warning(buf, fmt, args);
  va_end(args);
}

/// Display a debug message
void MESSENGER::Debug(ENTITY entity, const char *fmt, va_list args)
{
  char buf[1024];

  if (_globalDebug == true)
    {
      Format(buf,fmt,args);
      cerr << buf << endl;
    }
}

/// Display a debug message
void MESSENGER::Debug(ENTITY entity, const char *fmt, ...) 
{
  va_list args;

  va_start(args,fmt);
  Debug(entity, fmt, args);
  va_end(args);
}
