/*
 * $Id: aug_std.h,v 1.1.1.1 2005/06/13 16:47:43 bogdan_iancu Exp $
 *
 * POSTGRES module, portions of this code were templated using
 * the mysql module, thus it's similarity.
 *
 * Copyright (C) 2003 August.Net Services, LLC
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ---
 *
 * History
 * -------
 * 2003-04-06 initial code written (Greg Fausak/Andy Fullford)
 *
 */
/*
** ________________________________________________________________________
**
**
**                      $RCSfile: aug_std.h,v $
**                     $Revision: 1.1.1.1 $
**
**             Last change $Date: 2005/06/13 16:47:43 $
**           Last change $Author: bogdan_iancu $
**                        $State: Exp $
**                       $Locker:  $
**
**               Original author: Andrew Fullford
**
**           Copyright (C) August Associates  1995
**
** ________________________________________________________________________
*/

/*  AM_TYPE: (INSTALL_INC)  */

#ifndef AUG_STD_H
#define AUG_STD_H

#include "aug_sysdep.h"

/*
**  The rest of the libaug package has dependencies on these
**  system includes.
*/
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>
#include <time.h>

/*
**  Some boolean verbosity.
*/
#ifndef augBool
#define augBool		char
#endif
#define augFALSE	0
#define augTRUE		1

/*
**  Exit codes.
**
**  To just indicate success or failure, use augEXIT_OK and augEXIT_BAD.
**  For more esoteric codes, use the others.  Their numbers are chosen
**  so that they are unlikely to be generated by other applications, and
**  also to avoid signal numbers or error counts.
**
**  Note that augEXIT_NOMEM will be generated by aug_alloc failures
**  if they are not handled.
*/
#define augEXIT_YES	0
#define augEXIT_NO	1
#define augEXIT_NOMEM	99
#define augEXIT_ABORT	(augEXIT_NOMEM-1)
#define augEXIT_FATAL	(augEXIT_NOMEM-2)
#define augEXIT_ERROR	(augEXIT_NOMEM-3)
#define augEXIT_WARN	(augEXIT_NOMEM-4)
#define augEXIT_USAGE	(augEXIT_NOMEM-5)

/*
**  Used as a tag to explicitly signify externally accessible symbols.
**  I don't like leaving off the storage class; it's just too quiet.
*/
#define augExport

/*
**  Some utility prototypes.
*/
extern char *aug_cpy(char *tgt, char *src, int size);
extern char *aug_cat(char *tgt, char *src, int size);
extern char *aug_strip(char *tgt);
extern char *aug_upper(char *tgt);
extern char *aug_lower(char *tgt);
extern int aug_strexpand(char *tgt, char *src, int tgt_size);
extern char *aug_getsym(char *name, char *default_value);
extern void aug_abort_va(char *file, int line, char *fmt, va_list ap);
extern void aug_abort(char *file, int line, char *fmt, ...);
extern void aug_exit(int exit_code);
extern void aug_setmodule(char *name);
extern char *aug_module(void);
extern void aug_setenv(char *name, char *value);
extern char *aug_tempnam(char *dir, char *pfx, void *parent);

extern char *aug_hostname(void);
extern char *aug_domain(void);
extern char *aug_fqdn(char *addr);

extern int aug_getport(char *name);

extern void aug_sockopts(int s);

extern int aug_signal_max(void);
extern int aug_signal_num(char *signame);
extern char *aug_signal_name(int sig);

extern int aug_utc_offset(time_t tim);

extern unsigned long aug_random(void);
extern void aug_srandom(unsigned long seed);
extern unsigned long aug_random_seed(int entropy);
extern int aug_mkdir(char *name, int mode);

extern char *aug_encrypt(char *type, char *key, char *string, void *parent);
extern char *aug_decrypt(char *key, char *string, void *parent);

extern char **aug_mxresolv(char *domain, int timeout, int retry, void *parent);
extern char *aug_mxget(char *domain);

#include "aug_debug.h"
#include "aug_alloc.h"

#endif /* AUG_STD_H */
