/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CharacterModel!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &CharacterModelBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 CharacterModelBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
CharacterModelPtr CharacterModelBase::create(void) 
{
    CharacterModelPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = CharacterModelPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
CharacterModelPtr CharacterModelBase::createEmpty(void) 
{ 
    CharacterModelPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the CharacterModel::_sfConfigFile field.
inline
SFString *CharacterModelBase::getSFConfigFile(void)
{
    return &_sfConfigFile;
}

//! Get the CharacterModel::_sfNumAnimations field.
inline
SFUInt32 *CharacterModelBase::getSFNumAnimations(void)
{
    return &_sfNumAnimations;
}

//! Get the CharacterModel::_sfShader field.
inline
SFSHLChunkPtr *CharacterModelBase::getSFShader(void)
{
    return &_sfShader;
}

//! Get the CharacterModel::_mfMaterials field.
inline
MFChunkMaterialPtr *CharacterModelBase::getMFMaterials(void)
{
    return &_mfMaterials;
}


//! Get the value of the CharacterModel::_sfConfigFile field.
inline
std::string &CharacterModelBase::getConfigFile(void)
{
    return _sfConfigFile.getValue();
}

//! Get the value of the CharacterModel::_sfConfigFile field.
inline
const std::string &CharacterModelBase::getConfigFile(void) const
{
    return _sfConfigFile.getValue();
}

//! Set the value of the CharacterModel::_sfConfigFile field.
inline
void CharacterModelBase::setConfigFile(const std::string &value)
{
    _sfConfigFile.setValue(value);
}

//! Get the value of the CharacterModel::_sfNumAnimations field.
inline
UInt32 &CharacterModelBase::getNumAnimations(void)
{
    return _sfNumAnimations.getValue();
}

//! Get the value of the CharacterModel::_sfNumAnimations field.
inline
const UInt32 &CharacterModelBase::getNumAnimations(void) const
{
    return _sfNumAnimations.getValue();
}

//! Set the value of the CharacterModel::_sfNumAnimations field.
inline
void CharacterModelBase::setNumAnimations(const UInt32 &value)
{
    _sfNumAnimations.setValue(value);
}

//! Get the value of the CharacterModel::_sfShader field.
inline
SHLChunkPtr &CharacterModelBase::getShader(void)
{
    return _sfShader.getValue();
}

//! Get the value of the CharacterModel::_sfShader field.
inline
const SHLChunkPtr &CharacterModelBase::getShader(void) const
{
    return _sfShader.getValue();
}

//! Set the value of the CharacterModel::_sfShader field.
inline
void CharacterModelBase::setShader(const SHLChunkPtr &value)
{
    _sfShader.setValue(value);
}


//! Get the value of the \a index element the CharacterModel::_mfMaterials field.
inline
ChunkMaterialPtr &CharacterModelBase::getMaterials(const UInt32 index)
{
    return _mfMaterials[index];
}

//! Get the CharacterModel::_mfMaterials field.
inline
MFChunkMaterialPtr &CharacterModelBase::getMaterials(void)
{
    return _mfMaterials;
}

//! Get the CharacterModel::_mfMaterials field.
inline
const MFChunkMaterialPtr &CharacterModelBase::getMaterials(void) const
{
    return _mfMaterials;
}

OSG_END_NAMESPACE

#define OSGCHARACTERMODELBASE_INLINE_CVSID "@(#)$Id: OSGCharacterModelBase.inl,v 1.2 2006/02/20 17:04:12 dirk Exp $"

