/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class FTGLText!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEFTGLTEXTINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGFTGLTextBase.h"
#include "OSGFTGLText.h"


OSG_USING_NAMESPACE

const OSG::BitVector  FTGLTextBase::TextFieldMask = 
    (TypeTraits<BitVector>::One << FTGLTextBase::TextFieldId);

const OSG::BitVector  FTGLTextBase::FontFieldMask = 
    (TypeTraits<BitVector>::One << FTGLTextBase::FontFieldId);

const OSG::BitVector  FTGLTextBase::PositionFieldMask = 
    (TypeTraits<BitVector>::One << FTGLTextBase::PositionFieldId);

const OSG::BitVector FTGLTextBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var std::string     FTGLTextBase::_sfText
    The text to display.
*/
/*! \var FTGLFontPtr     FTGLTextBase::_sfFont
    Font to use.
*/
/*! \var Pnt3f           FTGLTextBase::_sfPosition
    Position of the text string, in 3D space.
*/

//! FTGLText description

FieldDescription *FTGLTextBase::_desc[] = 
{
    new FieldDescription(SFString::getClassType(), 
                     "text", 
                     TextFieldId, TextFieldMask,
                     false,
                     (FieldAccessMethod) &FTGLTextBase::getSFText),
    new FieldDescription(SFFTGLFontPtr::getClassType(), 
                     "font", 
                     FontFieldId, FontFieldMask,
                     false,
                     (FieldAccessMethod) &FTGLTextBase::getSFFont),
    new FieldDescription(SFPnt3f::getClassType(), 
                     "position", 
                     PositionFieldId, PositionFieldMask,
                     false,
                     (FieldAccessMethod) &FTGLTextBase::getSFPosition)
};


FieldContainerType FTGLTextBase::_type(
    "FTGLText",
    "MaterialDrawable",
    NULL,
    (PrototypeCreateF) &FTGLTextBase::createEmpty,
    FTGLText::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(FTGLTextBase, FTGLTextPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &FTGLTextBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &FTGLTextBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr FTGLTextBase::shallowCopy(void) const 
{ 
    FTGLTextPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const FTGLText *>(this)); 

    return returnValue; 
}

UInt32 FTGLTextBase::getContainerSize(void) const 
{ 
    return sizeof(FTGLText); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void FTGLTextBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((FTGLTextBase *) &other, whichField);
}
#else
void FTGLTextBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((FTGLTextBase *) &other, whichField, sInfo);
}
void FTGLTextBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void FTGLTextBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

FTGLTextBase::FTGLTextBase(void) :
    _sfText                   (), 
    _sfFont                   (), 
    _sfPosition               (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

FTGLTextBase::FTGLTextBase(const FTGLTextBase &source) :
    _sfText                   (source._sfText                   ), 
    _sfFont                   (source._sfFont                   ), 
    _sfPosition               (source._sfPosition               ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

FTGLTextBase::~FTGLTextBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 FTGLTextBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (TextFieldMask & whichField))
    {
        returnValue += _sfText.getBinSize();
    }

    if(FieldBits::NoField != (FontFieldMask & whichField))
    {
        returnValue += _sfFont.getBinSize();
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        returnValue += _sfPosition.getBinSize();
    }


    return returnValue;
}

void FTGLTextBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (TextFieldMask & whichField))
    {
        _sfText.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FontFieldMask & whichField))
    {
        _sfFont.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _sfPosition.copyToBin(pMem);
    }


}

void FTGLTextBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (TextFieldMask & whichField))
    {
        _sfText.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FontFieldMask & whichField))
    {
        _sfFont.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PositionFieldMask & whichField))
    {
        _sfPosition.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void FTGLTextBase::executeSyncImpl(      FTGLTextBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (TextFieldMask & whichField))
        _sfText.syncWith(pOther->_sfText);

    if(FieldBits::NoField != (FontFieldMask & whichField))
        _sfFont.syncWith(pOther->_sfFont);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _sfPosition.syncWith(pOther->_sfPosition);


}
#else
void FTGLTextBase::executeSyncImpl(      FTGLTextBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (TextFieldMask & whichField))
        _sfText.syncWith(pOther->_sfText);

    if(FieldBits::NoField != (FontFieldMask & whichField))
        _sfFont.syncWith(pOther->_sfFont);

    if(FieldBits::NoField != (PositionFieldMask & whichField))
        _sfPosition.syncWith(pOther->_sfPosition);



}

void FTGLTextBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<FTGLTextPtr>::_type("FTGLTextPtr", "MaterialDrawablePtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(FTGLTextPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(FTGLTextPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGFTGLTextBase.cpp,v 1.7 2006/02/20 17:04:13 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGFTGLTEXTBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGFTGLTEXTBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGFTGLTEXTFIELDS_HEADER_CVSID;
}

