/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Deformer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEDEFORMERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGDeformerBase.h"
#include "OSGDeformer.h"


OSG_USING_NAMESPACE

const OSG::BitVector  DeformerBase::GeometryFieldMask = 
    (TypeTraits<BitVector>::One << DeformerBase::GeometryFieldId);

const OSG::BitVector DeformerBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var NodePtr         DeformerBase::_sfGeometry
    Geometry node to deform
*/

//! Deformer description

FieldDescription *DeformerBase::_desc[] = 
{
    new FieldDescription(SFNodePtr::getClassType(), 
                     "geometry", 
                     GeometryFieldId, GeometryFieldMask,
                     false,
                     (FieldAccessMethod) &DeformerBase::getSFGeometry)
};


FieldContainerType DeformerBase::_type(
    "Deformer",
    "AttachmentContainer",
    NULL,
    NULL, 
    Deformer::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(DeformerBase, DeformerPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &DeformerBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &DeformerBase::getType(void) const 
{
    return _type;
} 


UInt32 DeformerBase::getContainerSize(void) const 
{ 
    return sizeof(Deformer); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void DeformerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((DeformerBase *) &other, whichField);
}
#else
void DeformerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((DeformerBase *) &other, whichField, sInfo);
}
void DeformerBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void DeformerBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

DeformerBase::DeformerBase(void) :
    _sfGeometry               (NodePtr(NullFC)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

DeformerBase::DeformerBase(const DeformerBase &source) :
    _sfGeometry               (source._sfGeometry               ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

DeformerBase::~DeformerBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 DeformerBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (GeometryFieldMask & whichField))
    {
        returnValue += _sfGeometry.getBinSize();
    }


    return returnValue;
}

void DeformerBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (GeometryFieldMask & whichField))
    {
        _sfGeometry.copyToBin(pMem);
    }


}

void DeformerBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (GeometryFieldMask & whichField))
    {
        _sfGeometry.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void DeformerBase::executeSyncImpl(      DeformerBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (GeometryFieldMask & whichField))
        _sfGeometry.syncWith(pOther->_sfGeometry);


}
#else
void DeformerBase::executeSyncImpl(      DeformerBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (GeometryFieldMask & whichField))
        _sfGeometry.syncWith(pOther->_sfGeometry);



}

void DeformerBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<DeformerPtr>::_type("DeformerPtr", "AttachmentContainerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(DeformerPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(DeformerPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGDEFORMERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDEFORMERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDEFORMERFIELDS_HEADER_CVSID;
}

