/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SkinDeformer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESKINDEFORMERINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGSkinDeformerBase.h"
#include "OSGSkinDeformer.h"


OSG_USING_NAMESPACE

const OSG::BitVector  SkinDeformerBase::InfluencesFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::InfluencesFieldId);

const OSG::BitVector  SkinDeformerBase::BaseMatricesFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::BaseMatricesFieldId);

const OSG::BitVector  SkinDeformerBase::VertexIndicesFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::VertexIndicesFieldId);

const OSG::BitVector  SkinDeformerBase::InfluenceIndicesFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::InfluenceIndicesFieldId);

const OSG::BitVector  SkinDeformerBase::InfluenceWeightsFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::InfluenceWeightsFieldId);

const OSG::BitVector  SkinDeformerBase::NormalIndicesFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::NormalIndicesFieldId);

const OSG::BitVector  SkinDeformerBase::NormalInfluenceIndicesFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::NormalInfluenceIndicesFieldId);

const OSG::BitVector  SkinDeformerBase::NormalInfluenceWeightsFieldMask = 
    (TypeTraits<BitVector>::One << SkinDeformerBase::NormalInfluenceWeightsFieldId);

const OSG::BitVector SkinDeformerBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var NodePtr         SkinDeformerBase::_mfInfluences
    Transform nodes that influence the mesh deformation
*/
/*! \var Matrix          SkinDeformerBase::_mfBaseMatrices
    Base world matrix for each influence transform
*/
/*! \var UInt32          SkinDeformerBase::_mfVertexIndices
    Vertex indices to deform.
*/
/*! \var UInt16          SkinDeformerBase::_mfInfluenceIndices
    Indices of influence transforms for each vertex index
*/
/*! \var Real32          SkinDeformerBase::_mfInfluenceWeights
    Weight of each influence for each vertex index
*/
/*! \var UInt32          SkinDeformerBase::_mfNormalIndices
    Normal indices to deform.
*/
/*! \var UInt16          SkinDeformerBase::_mfNormalInfluenceIndices
    Indices of influence transforms for each normal index.
*/
/*! \var Real32          SkinDeformerBase::_mfNormalInfluenceWeights
    Weight of each influence for each normal index.
*/

//! SkinDeformer description

FieldDescription *SkinDeformerBase::_desc[] = 
{
    new FieldDescription(MFNodePtr::getClassType(), 
                     "influences", 
                     InfluencesFieldId, InfluencesFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFInfluences),
    new FieldDescription(MFMatrix::getClassType(), 
                     "baseMatrices", 
                     BaseMatricesFieldId, BaseMatricesFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFBaseMatrices),
    new FieldDescription(MFUInt32::getClassType(), 
                     "vertexIndices", 
                     VertexIndicesFieldId, VertexIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFVertexIndices),
    new FieldDescription(MFUInt16::getClassType(), 
                     "influenceIndices", 
                     InfluenceIndicesFieldId, InfluenceIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFInfluenceIndices),
    new FieldDescription(MFReal32::getClassType(), 
                     "influenceWeights", 
                     InfluenceWeightsFieldId, InfluenceWeightsFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFInfluenceWeights),
    new FieldDescription(MFUInt32::getClassType(), 
                     "normalIndices", 
                     NormalIndicesFieldId, NormalIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFNormalIndices),
    new FieldDescription(MFUInt16::getClassType(), 
                     "normalInfluenceIndices", 
                     NormalInfluenceIndicesFieldId, NormalInfluenceIndicesFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFNormalInfluenceIndices),
    new FieldDescription(MFReal32::getClassType(), 
                     "normalInfluenceWeights", 
                     NormalInfluenceWeightsFieldId, NormalInfluenceWeightsFieldMask,
                     false,
                     (FieldAccessMethod) &SkinDeformerBase::getMFNormalInfluenceWeights)
};


FieldContainerType SkinDeformerBase::_type(
    "SkinDeformer",
    "Deformer",
    NULL,
    (PrototypeCreateF) &SkinDeformerBase::createEmpty,
    SkinDeformer::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(SkinDeformerBase, SkinDeformerPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &SkinDeformerBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &SkinDeformerBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr SkinDeformerBase::shallowCopy(void) const 
{ 
    SkinDeformerPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const SkinDeformer *>(this)); 

    return returnValue; 
}

UInt32 SkinDeformerBase::getContainerSize(void) const 
{ 
    return sizeof(SkinDeformer); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void SkinDeformerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((SkinDeformerBase *) &other, whichField);
}
#else
void SkinDeformerBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((SkinDeformerBase *) &other, whichField, sInfo);
}
void SkinDeformerBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void SkinDeformerBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfInfluences.terminateShare(uiAspect, this->getContainerSize());
    _mfBaseMatrices.terminateShare(uiAspect, this->getContainerSize());
    _mfVertexIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfInfluenceIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfInfluenceWeights.terminateShare(uiAspect, this->getContainerSize());
    _mfNormalIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfNormalInfluenceIndices.terminateShare(uiAspect, this->getContainerSize());
    _mfNormalInfluenceWeights.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

SkinDeformerBase::SkinDeformerBase(void) :
    _mfInfluences             (), 
    _mfBaseMatrices           (), 
    _mfVertexIndices          (), 
    _mfInfluenceIndices       (), 
    _mfInfluenceWeights       (), 
    _mfNormalIndices          (), 
    _mfNormalInfluenceIndices (), 
    _mfNormalInfluenceWeights (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

SkinDeformerBase::SkinDeformerBase(const SkinDeformerBase &source) :
    _mfInfluences             (source._mfInfluences             ), 
    _mfBaseMatrices           (source._mfBaseMatrices           ), 
    _mfVertexIndices          (source._mfVertexIndices          ), 
    _mfInfluenceIndices       (source._mfInfluenceIndices       ), 
    _mfInfluenceWeights       (source._mfInfluenceWeights       ), 
    _mfNormalIndices          (source._mfNormalIndices          ), 
    _mfNormalInfluenceIndices (source._mfNormalInfluenceIndices ), 
    _mfNormalInfluenceWeights (source._mfNormalInfluenceWeights ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

SkinDeformerBase::~SkinDeformerBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 SkinDeformerBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (InfluencesFieldMask & whichField))
    {
        returnValue += _mfInfluences.getBinSize();
    }

    if(FieldBits::NoField != (BaseMatricesFieldMask & whichField))
    {
        returnValue += _mfBaseMatrices.getBinSize();
    }

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
    {
        returnValue += _mfVertexIndices.getBinSize();
    }

    if(FieldBits::NoField != (InfluenceIndicesFieldMask & whichField))
    {
        returnValue += _mfInfluenceIndices.getBinSize();
    }

    if(FieldBits::NoField != (InfluenceWeightsFieldMask & whichField))
    {
        returnValue += _mfInfluenceWeights.getBinSize();
    }

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
    {
        returnValue += _mfNormalIndices.getBinSize();
    }

    if(FieldBits::NoField != (NormalInfluenceIndicesFieldMask & whichField))
    {
        returnValue += _mfNormalInfluenceIndices.getBinSize();
    }

    if(FieldBits::NoField != (NormalInfluenceWeightsFieldMask & whichField))
    {
        returnValue += _mfNormalInfluenceWeights.getBinSize();
    }


    return returnValue;
}

void SkinDeformerBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (InfluencesFieldMask & whichField))
    {
        _mfInfluences.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BaseMatricesFieldMask & whichField))
    {
        _mfBaseMatrices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
    {
        _mfVertexIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (InfluenceIndicesFieldMask & whichField))
    {
        _mfInfluenceIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (InfluenceWeightsFieldMask & whichField))
    {
        _mfInfluenceWeights.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
    {
        _mfNormalIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NormalInfluenceIndicesFieldMask & whichField))
    {
        _mfNormalInfluenceIndices.copyToBin(pMem);
    }

    if(FieldBits::NoField != (NormalInfluenceWeightsFieldMask & whichField))
    {
        _mfNormalInfluenceWeights.copyToBin(pMem);
    }


}

void SkinDeformerBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (InfluencesFieldMask & whichField))
    {
        _mfInfluences.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BaseMatricesFieldMask & whichField))
    {
        _mfBaseMatrices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
    {
        _mfVertexIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (InfluenceIndicesFieldMask & whichField))
    {
        _mfInfluenceIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (InfluenceWeightsFieldMask & whichField))
    {
        _mfInfluenceWeights.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
    {
        _mfNormalIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NormalInfluenceIndicesFieldMask & whichField))
    {
        _mfNormalInfluenceIndices.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (NormalInfluenceWeightsFieldMask & whichField))
    {
        _mfNormalInfluenceWeights.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void SkinDeformerBase::executeSyncImpl(      SkinDeformerBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (InfluencesFieldMask & whichField))
        _mfInfluences.syncWith(pOther->_mfInfluences);

    if(FieldBits::NoField != (BaseMatricesFieldMask & whichField))
        _mfBaseMatrices.syncWith(pOther->_mfBaseMatrices);

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
        _mfVertexIndices.syncWith(pOther->_mfVertexIndices);

    if(FieldBits::NoField != (InfluenceIndicesFieldMask & whichField))
        _mfInfluenceIndices.syncWith(pOther->_mfInfluenceIndices);

    if(FieldBits::NoField != (InfluenceWeightsFieldMask & whichField))
        _mfInfluenceWeights.syncWith(pOther->_mfInfluenceWeights);

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
        _mfNormalIndices.syncWith(pOther->_mfNormalIndices);

    if(FieldBits::NoField != (NormalInfluenceIndicesFieldMask & whichField))
        _mfNormalInfluenceIndices.syncWith(pOther->_mfNormalInfluenceIndices);

    if(FieldBits::NoField != (NormalInfluenceWeightsFieldMask & whichField))
        _mfNormalInfluenceWeights.syncWith(pOther->_mfNormalInfluenceWeights);


}
#else
void SkinDeformerBase::executeSyncImpl(      SkinDeformerBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (InfluencesFieldMask & whichField))
        _mfInfluences.syncWith(pOther->_mfInfluences, sInfo);

    if(FieldBits::NoField != (BaseMatricesFieldMask & whichField))
        _mfBaseMatrices.syncWith(pOther->_mfBaseMatrices, sInfo);

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
        _mfVertexIndices.syncWith(pOther->_mfVertexIndices, sInfo);

    if(FieldBits::NoField != (InfluenceIndicesFieldMask & whichField))
        _mfInfluenceIndices.syncWith(pOther->_mfInfluenceIndices, sInfo);

    if(FieldBits::NoField != (InfluenceWeightsFieldMask & whichField))
        _mfInfluenceWeights.syncWith(pOther->_mfInfluenceWeights, sInfo);

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
        _mfNormalIndices.syncWith(pOther->_mfNormalIndices, sInfo);

    if(FieldBits::NoField != (NormalInfluenceIndicesFieldMask & whichField))
        _mfNormalInfluenceIndices.syncWith(pOther->_mfNormalInfluenceIndices, sInfo);

    if(FieldBits::NoField != (NormalInfluenceWeightsFieldMask & whichField))
        _mfNormalInfluenceWeights.syncWith(pOther->_mfNormalInfluenceWeights, sInfo);


}

void SkinDeformerBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (InfluencesFieldMask & whichField))
        _mfInfluences.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (BaseMatricesFieldMask & whichField))
        _mfBaseMatrices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (VertexIndicesFieldMask & whichField))
        _mfVertexIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (InfluenceIndicesFieldMask & whichField))
        _mfInfluenceIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (InfluenceWeightsFieldMask & whichField))
        _mfInfluenceWeights.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (NormalIndicesFieldMask & whichField))
        _mfNormalIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (NormalInfluenceIndicesFieldMask & whichField))
        _mfNormalInfluenceIndices.beginEdit(uiAspect, uiContainerSize);

    if(FieldBits::NoField != (NormalInfluenceWeightsFieldMask & whichField))
        _mfNormalInfluenceWeights.beginEdit(uiAspect, uiContainerSize);

}
#endif



#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<SkinDeformerPtr>::_type("SkinDeformerPtr", "DeformerPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(SkinDeformerPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(SkinDeformerPtr, OSG_CONTRIBLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGSKINDEFORMERBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSKINDEFORMERBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSKINDEFORMERFIELDS_HEADER_CVSID;
}

