/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DisplayCalibration!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &DisplayCalibrationBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 DisplayCalibrationBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
DisplayCalibrationPtr DisplayCalibrationBase::create(void) 
{
    DisplayCalibrationPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = DisplayCalibrationPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
DisplayCalibrationPtr DisplayCalibrationBase::createEmpty(void) 
{ 
    DisplayCalibrationPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the DisplayCalibration::_sfEnabled field.
inline
SFBool *DisplayCalibrationBase::getSFEnabled(void)
{
    return &_sfEnabled;
}

//! Get the DisplayCalibration::_sfServer field.
inline
SFString *DisplayCalibrationBase::getSFServer(void)
{
    return &_sfServer;
}

//! Get the DisplayCalibration::_sfColorMatrix field.
inline
SFMatrix *DisplayCalibrationBase::getSFColorMatrix(void)
{
    return &_sfColorMatrix;
}

//! Get the DisplayCalibration::_sfGamma field.
inline
SFReal32 *DisplayCalibrationBase::getSFGamma(void)
{
    return &_sfGamma;
}

//! Get the DisplayCalibration::_mfGammaRamp field.
inline
MFColor3f *DisplayCalibrationBase::getMFGammaRamp(void)
{
    return &_mfGammaRamp;
}

//! Get the DisplayCalibration::_sfGridWidth field.
inline
SFUInt32 *DisplayCalibrationBase::getSFGridWidth(void)
{
    return &_sfGridWidth;
}

//! Get the DisplayCalibration::_sfGridHeight field.
inline
SFUInt32 *DisplayCalibrationBase::getSFGridHeight(void)
{
    return &_sfGridHeight;
}

//! Get the DisplayCalibration::_mfGrid field.
inline
MFVec2f *DisplayCalibrationBase::getMFGrid(void)
{
    return &_mfGrid;
}

//! Get the DisplayCalibration::_sfScaleDown field.
inline
SFReal32 *DisplayCalibrationBase::getSFScaleDown(void)
{
    return &_sfScaleDown;
}


//! Get the value of the DisplayCalibration::_sfEnabled field.
inline
bool &DisplayCalibrationBase::getEnabled(void)
{
    return _sfEnabled.getValue();
}

//! Get the value of the DisplayCalibration::_sfEnabled field.
inline
const bool &DisplayCalibrationBase::getEnabled(void) const
{
    return _sfEnabled.getValue();
}

//! Set the value of the DisplayCalibration::_sfEnabled field.
inline
void DisplayCalibrationBase::setEnabled(const bool &value)
{
    _sfEnabled.setValue(value);
}

//! Get the value of the DisplayCalibration::_sfServer field.
inline
std::string &DisplayCalibrationBase::getServer(void)
{
    return _sfServer.getValue();
}

//! Get the value of the DisplayCalibration::_sfServer field.
inline
const std::string &DisplayCalibrationBase::getServer(void) const
{
    return _sfServer.getValue();
}

//! Set the value of the DisplayCalibration::_sfServer field.
inline
void DisplayCalibrationBase::setServer(const std::string &value)
{
    _sfServer.setValue(value);
}

//! Get the value of the DisplayCalibration::_sfColorMatrix field.
inline
Matrix &DisplayCalibrationBase::getColorMatrix(void)
{
    return _sfColorMatrix.getValue();
}

//! Get the value of the DisplayCalibration::_sfColorMatrix field.
inline
const Matrix &DisplayCalibrationBase::getColorMatrix(void) const
{
    return _sfColorMatrix.getValue();
}

//! Set the value of the DisplayCalibration::_sfColorMatrix field.
inline
void DisplayCalibrationBase::setColorMatrix(const Matrix &value)
{
    _sfColorMatrix.setValue(value);
}

//! Get the value of the DisplayCalibration::_sfGamma field.
inline
Real32 &DisplayCalibrationBase::getGamma(void)
{
    return _sfGamma.getValue();
}

//! Get the value of the DisplayCalibration::_sfGamma field.
inline
const Real32 &DisplayCalibrationBase::getGamma(void) const
{
    return _sfGamma.getValue();
}

//! Set the value of the DisplayCalibration::_sfGamma field.
inline
void DisplayCalibrationBase::setGamma(const Real32 &value)
{
    _sfGamma.setValue(value);
}

//! Get the value of the DisplayCalibration::_sfGridWidth field.
inline
UInt32 &DisplayCalibrationBase::getGridWidth(void)
{
    return _sfGridWidth.getValue();
}

//! Get the value of the DisplayCalibration::_sfGridWidth field.
inline
const UInt32 &DisplayCalibrationBase::getGridWidth(void) const
{
    return _sfGridWidth.getValue();
}

//! Set the value of the DisplayCalibration::_sfGridWidth field.
inline
void DisplayCalibrationBase::setGridWidth(const UInt32 &value)
{
    _sfGridWidth.setValue(value);
}

//! Get the value of the DisplayCalibration::_sfGridHeight field.
inline
UInt32 &DisplayCalibrationBase::getGridHeight(void)
{
    return _sfGridHeight.getValue();
}

//! Get the value of the DisplayCalibration::_sfGridHeight field.
inline
const UInt32 &DisplayCalibrationBase::getGridHeight(void) const
{
    return _sfGridHeight.getValue();
}

//! Set the value of the DisplayCalibration::_sfGridHeight field.
inline
void DisplayCalibrationBase::setGridHeight(const UInt32 &value)
{
    _sfGridHeight.setValue(value);
}

//! Get the value of the DisplayCalibration::_sfScaleDown field.
inline
Real32 &DisplayCalibrationBase::getScaleDown(void)
{
    return _sfScaleDown.getValue();
}

//! Get the value of the DisplayCalibration::_sfScaleDown field.
inline
const Real32 &DisplayCalibrationBase::getScaleDown(void) const
{
    return _sfScaleDown.getValue();
}

//! Set the value of the DisplayCalibration::_sfScaleDown field.
inline
void DisplayCalibrationBase::setScaleDown(const Real32 &value)
{
    _sfScaleDown.setValue(value);
}


//! Get the value of the \a index element the DisplayCalibration::_mfGammaRamp field.
inline
Color3f &DisplayCalibrationBase::getGammaRamp(const UInt32 index)
{
    return _mfGammaRamp[index];
}

//! Get the DisplayCalibration::_mfGammaRamp field.
inline
MFColor3f &DisplayCalibrationBase::getGammaRamp(void)
{
    return _mfGammaRamp;
}

//! Get the DisplayCalibration::_mfGammaRamp field.
inline
const MFColor3f &DisplayCalibrationBase::getGammaRamp(void) const
{
    return _mfGammaRamp;
}

//! Get the value of the \a index element the DisplayCalibration::_mfGrid field.
inline
Vec2f &DisplayCalibrationBase::getGrid(const UInt32 index)
{
    return _mfGrid[index];
}

//! Get the DisplayCalibration::_mfGrid field.
inline
MFVec2f &DisplayCalibrationBase::getGrid(void)
{
    return _mfGrid;
}

//! Get the DisplayCalibration::_mfGrid field.
inline
const MFVec2f &DisplayCalibrationBase::getGrid(void) const
{
    return _mfGrid;
}

OSG_END_NAMESPACE

#define OSGDISPLAYCALIBRATIONBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

