/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class DirectionalLight!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILEDIRECTIONALLIGHTINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGDirectionalLightBase.h"
#include "OSGDirectionalLight.h"


OSG_USING_NAMESPACE

const OSG::BitVector  DirectionalLightBase::DirectionFieldMask = 
    (TypeTraits<BitVector>::One << DirectionalLightBase::DirectionFieldId);

const OSG::BitVector DirectionalLightBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec3f           DirectionalLightBase::_sfDirection
    
*/

//! DirectionalLight description

FieldDescription *DirectionalLightBase::_desc[] = 
{
    new FieldDescription(SFVec3f::getClassType(), 
                     "direction", 
                     DirectionFieldId, DirectionFieldMask,
                     false,
                     (FieldAccessMethod) &DirectionalLightBase::getSFDirection)
};


FieldContainerType DirectionalLightBase::_type(
    "DirectionalLight",
    "Light",
    NULL,
    (PrototypeCreateF) &DirectionalLightBase::createEmpty,
    DirectionalLight::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(DirectionalLightBase, DirectionalLightPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &DirectionalLightBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &DirectionalLightBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr DirectionalLightBase::shallowCopy(void) const 
{ 
    DirectionalLightPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const DirectionalLight *>(this)); 

    return returnValue; 
}

UInt32 DirectionalLightBase::getContainerSize(void) const 
{ 
    return sizeof(DirectionalLight); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void DirectionalLightBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((DirectionalLightBase *) &other, whichField);
}
#else
void DirectionalLightBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((DirectionalLightBase *) &other, whichField, sInfo);
}
void DirectionalLightBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void DirectionalLightBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

DirectionalLightBase::DirectionalLightBase(void) :
    _sfDirection              (Vec3f(0,0,1)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

DirectionalLightBase::DirectionalLightBase(const DirectionalLightBase &source) :
    _sfDirection              (source._sfDirection              ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

DirectionalLightBase::~DirectionalLightBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 DirectionalLightBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
    {
        returnValue += _sfDirection.getBinSize();
    }


    return returnValue;
}

void DirectionalLightBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
    {
        _sfDirection.copyToBin(pMem);
    }


}

void DirectionalLightBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
    {
        _sfDirection.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void DirectionalLightBase::executeSyncImpl(      DirectionalLightBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
        _sfDirection.syncWith(pOther->_sfDirection);


}
#else
void DirectionalLightBase::executeSyncImpl(      DirectionalLightBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (DirectionFieldMask & whichField))
        _sfDirection.syncWith(pOther->_sfDirection);



}

void DirectionalLightBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<DirectionalLightPtr>::_type("DirectionalLightPtr", "LightPtr");
#endif


OSG_END_NAMESPACE


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCBaseTemplate_cpp.h,v 1.45 2005/07/20 00:10:14 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGDIRECTIONALLIGHTBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDIRECTIONALLIGHTBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDIRECTIONALLIGHTFIELDS_HEADER_CVSID;
}

