/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class SClipPlaneChunk!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILESCLIPPLANECHUNKINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGSClipPlaneChunkBase.h"
#include "OSGSClipPlaneChunk.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  SClipPlaneChunkBase::EquationFieldMask = 
    (TypeTraits<BitVector>::One << SClipPlaneChunkBase::EquationFieldId);

const OSG::BitVector SClipPlaneChunkBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var Vec4f           SClipPlaneChunkBase::_sfEquation
    Defines the equation of the clip plane. Standard format, if (a,b,c,d) is         the plane a point (x,y,z) is visible if a*x+b*y+c*z+d &gt;= 0.
*/

//! SClipPlaneChunk description

FieldDescription *SClipPlaneChunkBase::_desc[] = 
{
    new FieldDescription(SFVec4f::getClassType(), 
                     "equation", 
                     EquationFieldId, EquationFieldMask,
                     false,
                     (FieldAccessMethod) &SClipPlaneChunkBase::getSFEquation)
};


FieldContainerType SClipPlaneChunkBase::_type(
    "SClipPlaneChunk",
    "StateChunk",
    NULL,
    (PrototypeCreateF) &SClipPlaneChunkBase::createEmpty,
    SClipPlaneChunk::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(SClipPlaneChunkBase, SClipPlaneChunkPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &SClipPlaneChunkBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &SClipPlaneChunkBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr SClipPlaneChunkBase::shallowCopy(void) const 
{ 
    SClipPlaneChunkPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const SClipPlaneChunk *>(this)); 

    return returnValue; 
}

UInt32 SClipPlaneChunkBase::getContainerSize(void) const 
{ 
    return sizeof(SClipPlaneChunk); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void SClipPlaneChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((SClipPlaneChunkBase *) &other, whichField);
}
#else
void SClipPlaneChunkBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((SClipPlaneChunkBase *) &other, whichField, sInfo);
}
void SClipPlaneChunkBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void SClipPlaneChunkBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

SClipPlaneChunkBase::SClipPlaneChunkBase(void) :
    _sfEquation               (Vec4f(0, 0, 1, 0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

SClipPlaneChunkBase::SClipPlaneChunkBase(const SClipPlaneChunkBase &source) :
    _sfEquation               (source._sfEquation               ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

SClipPlaneChunkBase::~SClipPlaneChunkBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 SClipPlaneChunkBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
    {
        returnValue += _sfEquation.getBinSize();
    }


    return returnValue;
}

void SClipPlaneChunkBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
    {
        _sfEquation.copyToBin(pMem);
    }


}

void SClipPlaneChunkBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
    {
        _sfEquation.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void SClipPlaneChunkBase::executeSyncImpl(      SClipPlaneChunkBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
        _sfEquation.syncWith(pOther->_sfEquation);


}
#else
void SClipPlaneChunkBase::executeSyncImpl(      SClipPlaneChunkBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (EquationFieldMask & whichField))
        _sfEquation.syncWith(pOther->_sfEquation);



}

void SClipPlaneChunkBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<SClipPlaneChunkPtr>::_type("SClipPlaneChunkPtr", "StateChunkPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(SClipPlaneChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(SClipPlaneChunkPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGSClipPlaneChunkBase.cpp,v 1.1 2007/04/26 15:22:01 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGSCLIPPLANECHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGSCLIPPLANECHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGSCLIPPLANECHUNKFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

