// OpenSTA, Static Timing Analyzer
// Copyright (c) 2019, Parallax Software, Inc.
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef STA_THREAD_EXCEPTION_H
#define STA_THREAD_EXCEPTION_H

#include "Error.hh"

namespace sta {

class ThreadException : public StaExceptionLine
{
public:
  ThreadException(const char *filename,
		  int line,
		  int error);
  virtual const char *what() const throw();

protected:
  int error_;
};

#define CheckThreadError(error) \
  if (error != 0) \
    throw ThreadException(__FILE__, __LINE__, error)

} // namespace
#endif
