<?php

require_once("read_conf.php");
require_once("db.php");
require_once("ssh.php");

$conf = readmyconf();
$con = connectme($conf);

function machine_list($con){
    $mlist = "<table border='1'>
<tr><th>IP address<br>Serial</th><th>Memory</th><th>HDD</th><th>iface</th><th>installed</th><th>Last seen</th><th>Hostname</th><th>Action</th></tr>\n";
    $r = mysqli_query($con, "SELECT * FROM machines");
    $n = mysqli_num_rows($r);
    for($i=0; $i<$n; $i++){
        $a = mysqli_fetch_array($r);
        $ipaddr = $a["ipaddr"];
        $serial = $a["serial"];
        $mlist .= "<tr>";
        $mlist .= "<td>$ipaddr<br>$serial</td>";
        $mlist .= "<td>".$a["memory"]." MB</td>";

        $blockdevs = "";
        $r2 = mysqli_query($con, "SELECT * FROM blockdevices WHERE machine_id='".$a["id"]."'");
        $n2 = mysqli_num_rows($r2);
        for($i2=0; $i2<$n2; $i2++){
            $a2 = mysqli_fetch_array($r2);
            $blockdevs .= $a2["name"] . ": " . $a2["size_mb"] . " GB<br>";
        }

        $mlist .= "<td>".$blockdevs."</td>";

        $ifaces = "";
        $r2 = mysqli_query($con, "SELECT * FROM ifnames WHERE machine_id='".$a["id"]."'");
        $n2 = mysqli_num_rows($r2);
        for($i2=0; $i2<$n2; $i2++){
            $a2 = mysqli_fetch_array($r2);
            $ifaces .= $a2["name"] . ": " . $a2["macaddr"] . "<br>";
        }

        $mlist .= "<td>$ifaces</td>";
        $mlist .= "<td>".$a["installed"]."</td>";
        $mlist .= "<td>".$a["lastseen"]."</td>";
        $mlist .= "<td><form action='?'><input type='text' name='hostname' value='".$a["hostname"]."'></td>";
        $mlist .= "<td><input type='hidden' name='action' value='install_os'><input type='hidden' name='ipaddr' value='$ipaddr'><input type='submit' text='Install' value='Install'></form><br>
<a target='_blank' href='view_log.php?ipaddr=$ipaddr'>view log</a></td>";
        $mlist .= "</tr>\n";
    }
    $mlist .= "</table>\n";
    return $mlist;
}

if(isset($_REQUEST["action"]) && $_REQUEST["action"] == "install_os"){
    if(!isset($_REQUEST["ipaddr"]) || $_REQUEST["ipaddr"] == ""){
        print("Missing ipaddr param");
    }
    if(isset($_REQUEST["hostname"]) && $_REQUEST["hostname"] != ""){
        $hostname = $_REQUEST["hostname"];
    }else{
        $hostname = "";
    }
    $r = mysqli_query($con, "SELECT * FROM machines WHERE ipaddr='".$_REQUEST["ipaddr"]."'");
    $n = mysqli_num_rows($r);
    if($n != 1){
        die("Cannot find machine with this IP address.");
    }else{
        $install_machine = mysqli_fetch_array($r);
        $install_machine_id = $install_machine["id"];
        $r = mysqli_query($con, "UPDATE machines SET hostname='$hostname' WHERE ipaddr='".$_REQUEST["ipaddr"]."'");
        $r = mysqli_query($con, "SELECT * FROM blockdevices WHERE machine_id='".$install_machine_id."' LIMIT 1;");
        $n = mysqli_num_rows($r);
        if($n != 1){
            die("Cannot find block device");
        }
        $a2 = mysqli_fetch_array($r);
        $install_hdd_name = $a2["name"];
    }
}

print("<html><head><link rel='stylesheet' href='oci.css'></head><body><center>\n");
print("<h1>OpenStack cluster Installer Web GUI</h1>");
print(machine_list($con));

if(isset($_REQUEST["action"]) && $_REQUEST["action"] == "install_os"){
    if(!isset($_REQUEST["ipaddr"]) || $_REQUEST["ipaddr"] == ""){
        print("Missing ipaddr param");
    }else{
        $added_params = " --static-eth0 " . $_REQUEST["ipaddr"] . "/" . $conf["network"]["netmaskclass"] . " --reboot-after-install --install-nonfree-repo --postinstall-packages firmware-bnx2,firmware-bnx2x";
        if(isset($_REQUEST["hostname"]) && $_REQUEST["hostname"] != ""){
            $added_params .= " --hostname " . $_REQUEST["hostname"];
        }

        print("Installing OS...<br>");
        $cmd = "build-openstack-debian-image --release stretch --debootstrap-url http://".$conf["network"]["DEBIAN_MIRROR_IP"].":9999/debian --sources.list-mirror http://".$conf["network"]["DEBIAN_MIRROR_IP"].":9999/debian --security-mirror http://".$conf["network"]["DEBIAN_MIRROR_IP"].":9999/security --dest-hdd $install_hdd_name --no-cloud-init --root-ssh-key /root/.ssh/authorized_keys $added_params >/var/log/oci.log 2>&1 &";
        $ret = send_ssh_cmd($conf, $con, $_REQUEST["ipaddr"], $cmd);
        print("Running: $cmd");
    }
}

print("</center></body></html>");

?>
