# OpenStreetMap Carto Community Code of Conduct

## Why have a Code of Conduct?

Online communities include people from many different backgrounds. The OpenStreetMap Carto contributors are committed to providing a friendly, safe and welcoming environment for all, regardless of age, disability, gender, nationality, ethnicity, religion, sexuality, or similar personal characteristic.

The first goal of the Code of Conduct is to specify a baseline standard of behavior so that people with different social values and communication styles can talk about OpenStreetMap Carto effectively, productively, and respectfully.

The second goal is to provide a mechanism for resolving conflicts in the community when they arise.

The third goal of the Code of Conduct is to make our community welcoming to people from different backgrounds. Diversity is critical to the project; for OpenStreetMap Carto to be successful, it needs contributors and users from all backgrounds.

With that said, a healthy community must allow for disagreement and debate. The Code of Conduct is not a mechanism for people to silence others with whom they disagree.

## Where does the Code of Conduct apply?

If you participate in or contribute to the OpenStreetMap Carto ecosystem in any way, you are encouraged to follow the Code of Conduct while doing so.

Explicit enforcement of the Code of Conduct applies to the OpenStreetMap Carto GitHub project and code reviews.

## Values

These are the values to which people in the OpenStreetMap Carto should aspire.

- Be friendly and welcoming
- Be patient
  - Remember that people have varying communication styles and that not everyone is using their native language. (Meaning and tone can be lost in translation.)
- Be thoughtful
  - Productive communication requires effort. Think about how your words will be interpreted.
  - Remember that sometimes it is best to refrain entirely from commenting.
- Be respectful
  - In particular, respect differences of opinion.
- Be charitable
  - Interpret the arguments of others in good faith, do not seek to disagree.
  - When we do disagree, try to understand why.
- Avoid destructive behavior:
  - Derailing: stay on topic; if you want to talk about something else, start a new conversation.
  - Unconstructive criticism: don't merely decry the current state of affairs; offer—or at least solicit—suggestions as to how things may be improved.
  - Snarking (pithy, unproductive, sniping comments)
  - Discussing potentially offensive or sensitive issues unless directly technically relevant; this all too often leads to unnecessary conflict.
  - Microaggressions: brief and commonplace verbal, behavioral and environmental indignities that communicate hostile, derogatory or negative slights and insults to a person or group.

People are complicated. You should expect to be misunderstood and to misunderstand others; when this inevitably occurs, resist the urge to be defensive or assign blame. Try not to take offense where no offense was intended. Give people the benefit of the doubt. Even if the intent was to provoke, do not rise to it. It is the responsibility of *all parties* to de-escalate conflict when it arises.

## Unwelcome behavior

These actions are explicitly forbidden in OpenStreetMap Carto spaces:

- Insulting, demeaning, hateful, or threatening remarks.
- Discrimination based on age, disability, gender, nationality, ethnicity, religion, sexuality, or similar personal characteristic.
- Bullying or systematic harassment.
- Unwelcome sexual advances.
- Incitement to any of these.

## Moderation

The OpenStreetMap Carto spaces are not free speech venues; they are for discussion about OpenStreetMap Carto.

When using the OpenStreetMap Carto spaces you should act in the spirit of the values. If you conduct yourself in a way that is explicitly forbidden by the CoC, you will be warned and asked to stop. If you do not stop, you will be removed from our community spaces temporarily. Repeated, willful breaches of the CoC will result in a permanent ban.

## Reporting issues

The OpenStreetMap Carto maintainers are responsible for handling conduct-related issues. Their goal is to de-escalate conflicts and try to resolve issues to the satisfaction of all parties.

If you encounter a conduct-related issue, you should report it to the maintainers by sending them [all an email](mailto:openstreetmap-carto@gravitystorm.co.uk,osm@paulnorman.ca,chris_hormann@gmx.de,daniel@xn--ko-wla.pl,sommerluk@gmail.com,joseph.eisenberg@gmail.com).

**Note that the goal of the Code of Conduct and the maintainers is to resolve conflicts in the most harmonious way possible.** We hope that in most cases issues may be resolved through polite discussion and mutual agreement. Bans and other forceful measures are to be employed only as a last resort.

Changes to the Code of Conduct should be proposed as pull requests.

## Summary

- Treat everyone with respect and kindness.
- Be thoughtful in how you communicate.
- Don’t be destructive or inflammatory.
- If you encounter an issue, please mail the maintainers.

## Acknowledgements

This document is based on the [Go Community Code of Conduct](https://go.dev/conduct), which in turn has parts derived from the Code of Conduct documents of the Django, FreeBSD, and Rust projects.

This documented is licensed under the Creative Commons Attribution 3.0 License.
