#!/usr/bin/env python
from subprocess import check_call
try:
	from lxml import etree as ElementTree
except ImportError:
	try:
		from xml.etree import ElementTree
	except ImportError:
		from elementTree import ElementTree

import os

print "\n\nGenerate new ts-files from po-files\n".upper()
for po_name in os.listdir("translations"):
	if po_name.endswith(".po"):
		ts_name = po_name[:-3] + ".ts"
		
		po_path = os.path.join("translations", po_name)
		ts_path = os.path.join("translations", ts_name)

		check_call(["po2ts", po_path, ts_path])
		#clean up ts file
		tree = ElementTree.parse(open(ts_path))

		for translation in tree.findall("//translation"):
			translation.text = translation.text.strip()
		tree.write(ts_path)

		#Add .ts to bzr
		check_call(["bzr", "add", ts_path])

print "\n\nUpdate translations from source files.\n".upper()
check_call("pylupdate4 -noobsolete openteacher.pro".split(" "))

print "\n\nConvert ts-files to po-files for launchpad use, and convert them to .qm for runtime use\n".upper()
for ts_name in os.listdir("translations"):
	if ts_name == "translations.ts":
		check_call(["ts2po", os.path.join("translations", ts_name), "-P",
                    "translations/translations.pot"])
	elif ts_name.endswith(".ts"):
		#po conversion
		po_name = ts_name[:-3] + ".po"
		qm_name = ts_name[:-3] + ".qm"

		check_call(["ts2po", os.path.join("translations", ts_name),
							 os.path.join("translations", po_name)])
		#Add po file to bzr if not already
		check_call(["bzr", "add", os.path.join("translations", po_name)])

		#qm conversion
		check_call(["lrelease", os.path.join("translations", ts_name)])

		#Add qm file to bzr if not already
		check_call(["bzr", "add", os.path.join("translations", qm_name)])

print "\n\nCompile application resources\n".upper()
check_call("pyrcc4 resources.qrc -o src/resources.py".split(" "))

print "\n\nCompile icon resources\n".upper()
check_call("pyrcc4 -o src/gui/icons_rc.py icons/icons.qrc".split(" "))

print "\n\nCompile all GUI-files (all files in the ui-folder with the extension .ui)\n".upper()
for ui_name in os.listdir("ui"):
	if ui_name.endswith(".ui"):
		py_name = ui_name[:-3] + ".py"
		check_call(["pyuic4", "-o", os.path.join("src/gui", py_name),
                                    os.path.join("ui", ui_name)])
