"computeTestPartialRegression" <-
function(outSample, inSample, selection, testLevel = 0.95) {

  # Perform lm on each selection.
  partialInSample <- inSample[,selection]
  lmSummary <- summary(lm(outSample ~ partialInSample))

  # The p-values are accessible via summary()
  pValues <- lmSummary$coefficients[,4]
  names(pValues) <- NULL
  
  testResult <- ifelse(pValues > 1 - testLevel, 1, 0)
  names(testResult) <- NULL

  return(list(test = "Regression",
              testResult = testResult,
              threshold = 1 - testLevel,
              pValue = pValues))

}

