//                                               -*- C -*-
/**
 *  @file  OTdebug.h
 *  @brief The header file of Open TURNS for debug level
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: OTdebug.h 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_OTDEBUG_H
# define OPENTURNS_OTDEBUG_H

# include <stdlib.h> // POSIX: for inclusion of <features.h> in GNU glibc systems

# ifdef __GNUC__
#  define GCC_VERSION (__GNUC__ * 10000         \
                       + __GNUC_MINOR__ * 100   \
                       + __GNUC_PATCHLEVEL__)

#  if GCC_VERSION <= 30406 /* GCC 3.4.6 and below */
#   define REINTERPRET_CAST(T,V) ( (T) (V) )
#  else /* GCC after 3.4.6 */
#   define REINTERPRET_CAST(T,V) ( reinterpret_cast< T > (V) )
#  endif /* GCC 3.4.6 test */

#  ifndef WIN32 // __GLIBC_PREREQ not defined on mingw
/* The pthread library is bogus for glibc < 2.10 */
#    if defined(__GNU_LIBRARY__) && ! __GLIBC_PREREQ(2, 10)
#     define BOGUS_PTHREAD_LIBRARY 1
#    endif
#  endif


#  ifdef SWIG
#   define DEPRECATED
#   define UNUSED
#   define NOTHROW
#  else /* not SWIG */
#   define DEPRECATED  __attribute__ ((deprecated))
#   define UNUSED      __attribute__ ((unused))
#   define NOTHROW     __attribute__ ((nothrow))
#  endif /* SWIG */

# else /* not __GNUC_ */

#  define GCC_VERSION 0
#  define DEPRECATED
#  define UNUSED
#  define NOTHROW

# endif /* __GNUC_ */

#endif /* OPENTURNS_OTDEBUG_H */
