//                                               -*- C++ -*-
/**
 *  @file  Equal.hxx
 *  @brief Implementation of equality comparison
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Equal.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_EQUAL_HXX
#define OPENTURNS_EQUAL_HXX

#include "ComparisonOperatorImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {


      /**
       * @class Equal
       *
       * @brief The class implements the equality comparison
       *
       * This class is derived from ComparisonOperatorImplementation. It performs the comparison
       * of two NumericalScalar and is mainly used in threshold exceedence algorithms.
       */
      class Equal
        : public ComparisonOperatorImplementation
      {
        CLASSNAME;
      public:

        /** Default constructor */
        explicit Equal();

        /* String converter */
        String __repr__() const;


        /* Here is the interface that all derived class must implement */

        /* Virtual constructor */
        virtual Equal * clone() const;

        /**
         * Return true if a == b
         * @param a The left hand side of the expression
         * @param b The right hand side of the expression
         * @return True if comparison succeeds
         */
        virtual Bool operator() (NumericalScalar a, NumericalScalar b) const;

        /* Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /* Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      }; /* class Equal */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_EQUAL_HXX */
