//                                               -*- C++ -*-
/**
 *  @file  NonCenteredFiniteDifferenceGradient.hxx
 *  @brief Class for the creation of a numerical math gradient implementation
 *         form a numerical math evaluation implementation by using noncentered
 *         finite difference formula.
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: NonCenteredFiniteDifferenceGradient.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_NONCENTEREDFINITEDIFFERENCEGRADIENT_HXX
#define OPENTURNS_NONCENTEREDFINITEDIFFERENCEGRADIENT_HXX

#include "FiniteDifferenceGradient.hxx"
#include "NumericalMathEvaluationImplementation.hxx"
#include "Exception.hxx"
#include "Pointer.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Diff {


      /**
       * @class NonCenteredFiniteDifferenceGradient
       * @brief This class is for the creation of a numerical math gradient implementation
       * @ingroup Function
       *
       * This class is for the creation of a numerical math gradient implementation
       * form a numerical math evaluation implementation by using noncentered
       * finite difference formula
       */
      class NonCenteredFiniteDifferenceGradient
        : public FiniteDifferenceGradient
      {
        CLASSNAME;
      public:

        static const NumericalScalar DefaultEpsilon;

        typedef Func::NumericalMathGradientImplementation::Description              Description;
        typedef Func::NumericalMathGradientImplementation::NumericalPoint           NumericalPoint;
        typedef Func::NumericalMathGradientImplementation::InvalidArgumentException InvalidArgumentException;
        typedef Func::NumericalMathGradientImplementation::InternalException        InternalException;
        typedef Func::NumericalMathGradientImplementation::StorageManager           StorageManager;
        typedef Common::InvalidDimensionException                                   InvalidDimensionException;
        typedef Pointer<Func::NumericalMathEvaluationImplementation>        EvaluationImplementation;

        /** Default constructor */
        NonCenteredFiniteDifferenceGradient();

        /** Parameter constructor */
        NonCenteredFiniteDifferenceGradient(const NumericalPoint & epsilon,
                                            const EvaluationImplementation & p_evaluation)
          /* throw(InvalidDimensionException) */;

        /** Second parameter constructor */
        NonCenteredFiniteDifferenceGradient(const NumericalScalar epsilon,
                                            const EvaluationImplementation & p_evaluation)
          /* throw(InvalidDimensionException) */;

        /** Constructor from finite difference step */
        NonCenteredFiniteDifferenceGradient(const FiniteDifferenceStep & step,
                                            const EvaluationImplementation & p_evaluation);

        /** Virtual constructor */
        virtual NonCenteredFiniteDifferenceGradient * clone() const;

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset) const;



        /* Here is the interface that all derived class must implement */

        /** This method computes the gradient at some point
         * @param in The point where the gradient is computed
         * @result A matrix constructed with the dF_i/dx_j values (Jacobian transposed)
         */
        virtual Matrix gradient(const NumericalPoint & inP) const
          /* throw(InvalidArgumentException, InternalException) */;

      protected:


      private:

      }; /* class NonCenteredFiniteDifferenceGradient */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NONCENTEREDFINITEDIFFERENCEGRADIENT_HXX */
