//                                               -*- C++ -*-
/**
 *  @file  BasisSequence.hxx
 *  @brief A sequence of numerical math function collection
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: BasisSequence.hxx 1649 2010-11-09 12:44:00Z dutka $
 */
#ifndef OPENTURNS_BASISSEQUENCE_HXX
#define OPENTURNS_BASISSEQUENCE_HXX

#include "TypedCollectionInterfaceObject.hxx"
#include "BasisSequenceImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {

      /**
       * @class BasisSequence
       *
       * A sequence of numerical math function collection.
       */
      class BasisSequence
        : public Common::TypedCollectionInterfaceObject<BasisSequenceImplementation>
      {
        CLASSNAME;

      public:

        typedef Base::Type::Indices Indices;

        /** Default constructor */
        BasisSequence();

        /** Default constructor */
        BasisSequence(const Basis & psi);

        /** Contructor from implementation */
        BasisSequence(const BasisSequenceImplementation & implementation);

        /** Dimension accessor */
        UnsignedLong getDimension() const;

        /** Returns the master basis */
        Basis getMasterBasis() const;

        /** Sub-basis accessor */
        Basis getBasis(const UnsignedLong index) const;

        /** Indices accessor */
        Indices getIndices(const UnsignedLong index) const;

        /** Converter to Basis collection */
        operator Base::Type::PersistentCollection< Base::Type::Indices > () const;

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset = "") const;

      }; /* class BasisSequence */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BASISSEQUENCE_HXX */
