//                                               -*- C++ -*-
/**
 * @file  FunctionCache.hxx
 * @brief Cache of NumericalMathFunction
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * \author $LastChangedBy: schueller $
 * \date   $LastChangedDate: 2011-01-26 14:50:44 +0100 (Wed, 26 Jan 2011) $
 */

#ifndef OPENTURNS_FUNCTIONCACHE_HXX
#define OPENTURNS_FUNCTIONCACHE_HXX

#include "OTprivate.hxx"
#include "Cache.hxx"
#include "PersistentCollection.hxx"
#include "NumericalSample.hxx"


namespace OpenTURNS {

  namespace Base {

    namespace Func {

      class FunctionCache
        : public Base::Type::Cache<Base::Type::PersistentCollection< OpenTURNS::NumericalScalar >, Base::Type::PersistentCollection< OpenTURNS::NumericalScalar > >
      {
        CLASSNAME;
      public:

        typedef Base::Stat::NumericalSample                                                     NumericalSample;
        typedef Base::Type::PersistentCollection<NumericalScalar>                               KeyType;
        typedef Base::Type::PersistentCollection<NumericalScalar>                               ValueType;

        /** Default constructor */
        FunctionCache();

        /** parameter constructor */
        FunctionCache(const UnsignedLong size);

        /** String converter */
        virtual String __str__() const;
        virtual String __repr__() const;

        /** Get the cache as NumericalSample */
        virtual NumericalSample getInputNumericalSample() const;
        virtual NumericalSample getOutputNumericalSample() const;

        /** Import cache from a NumericalSample */
        virtual void importFromNumericalSample(const NumericalSample & input,
                                               const NumericalSample & output);
      };
    }
  }
}

#endif //OPENTURNS_FUNCTIONCACHE_HXX
