//                                               -*- C++ -*-
/**
 *  @file  NearestPointAlgorithmImplementationResult.cxx
 *  @brief NearestPointAlgorithmImplementationResult stores the result of a NearestPointAlgorithmImplementationResult
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: NearestPointAlgorithmImplementationResult.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "NearestPointAlgorithmImplementationResult.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(NearestPointAlgorithmImplementationResult);

      static Base::Common::Factory<NearestPointAlgorithmImplementationResult> RegisteredFactory("NearestPointAlgorithmImplementationResult");

      /* Default constructor */
      NearestPointAlgorithmImplementationResult::NearestPointAlgorithmImplementationResult():
        PersistentObject(),
        minimizer_(NumericalPoint(1)),
        iterationsNumber_(0),
        absoluteError_(0.),
        relativeError_(0.),
        residualError_(0.),
        constraintError_(0.)
      {
        // Nothing to do
      }

      /* Standard constructor */
      NearestPointAlgorithmImplementationResult::NearestPointAlgorithmImplementationResult(const NumericalPoint & minimizer,
                                                                                           const UnsignedLong iterationsNumber,
                                                                                           const NumericalScalar absoluteError,
                                                                                           const NumericalScalar relativeError,
                                                                                           const NumericalScalar residualError,
                                                                                           const NumericalScalar constraintError):
        PersistentObject(),
        minimizer_(minimizer),
        iterationsNumber_(iterationsNumber),
        absoluteError_(absoluteError),
        relativeError_(relativeError),
        residualError_(residualError),
        constraintError_(constraintError)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      NearestPointAlgorithmImplementationResult * NearestPointAlgorithmImplementationResult::clone() const
      {
        return new NearestPointAlgorithmImplementationResult(*this);
      }

      /* Minimizer accessors */
      NearestPointAlgorithmImplementationResult::NumericalPoint NearestPointAlgorithmImplementationResult::getMinimizer() const
      {
        return minimizer_;
      }

      /* Minimizer accessors */
      void NearestPointAlgorithmImplementationResult::setMinimizer(const NumericalPoint & minimizer)
      {
        minimizer_ = minimizer;
      }

      /* Iterations number accessor */
      UnsignedLong NearestPointAlgorithmImplementationResult::getIterationsNumber() const
      {
        return iterationsNumber_;
      }

      /* Iterations Number accessor */
      void NearestPointAlgorithmImplementationResult::setIterationsNumber(const UnsignedLong iterationsNumber)
      {
        iterationsNumber_ = iterationsNumber;
      }

      /* Absolute error accessor */
      NumericalScalar NearestPointAlgorithmImplementationResult::getAbsoluteError() const
      {
        return absoluteError_;
      }

      /* Absolute error accessor */
      void NearestPointAlgorithmImplementationResult::setAbsoluteError(const NumericalScalar absoluteError)
      {
        absoluteError_ = absoluteError;
      }

      /* Relative error accessor */
      NumericalScalar NearestPointAlgorithmImplementationResult::getRelativeError() const
      {
        return relativeError_;
      }

      /* Relative error accessor */
      void NearestPointAlgorithmImplementationResult::setRelativeError(const NumericalScalar relativeError)
      {
        relativeError_ = relativeError;
      }

      /* Residual error accessor */
      NumericalScalar NearestPointAlgorithmImplementationResult::getResidualError() const
      {
        return residualError_;
      }

      /* Residual error accessor */
      void NearestPointAlgorithmImplementationResult::setResidualError(const NumericalScalar residualError)
      {
        residualError_ = residualError;
      }

      /* Constraint error accessor */
      NumericalScalar NearestPointAlgorithmImplementationResult::getConstraintError() const
      {
        return constraintError_;
      }

      /* Constraint error accessor */
      void NearestPointAlgorithmImplementationResult::setConstraintError(const NumericalScalar constraintError)
      {
        constraintError_ = constraintError;
      }

      /* String converter */
      String NearestPointAlgorithmImplementationResult::__repr__() const
      {
        OSS oss;
        oss << "class=" << NearestPointAlgorithmImplementationResult::GetClassName()
            << " minimizer=" << minimizer_
            << " iterationsNumber=" << iterationsNumber_
            << " absoluteError=" << absoluteError_
            << " relativeError=" << relativeError_
            << " residualError=" << residualError_
            << " constraintError=" << constraintError_;
        return oss;
      }

      /* Method save() stores the object through the StorageManager */
      void NearestPointAlgorithmImplementationResult::save(StorageManager::Advocate & adv) const
      {
        PersistentObject::save(adv);
        adv.saveAttribute( "minimizer_", minimizer_ );
        adv.saveAttribute( "iterationsNumber_", iterationsNumber_ );
        adv.saveAttribute( "absoluteError_", absoluteError_ );
        adv.saveAttribute( "relativeError_", relativeError_ );
        adv.saveAttribute( "residualError_", residualError_ );
        adv.saveAttribute( "constraintError_", constraintError_ );
      }

      /* Method load() reloads the object from the StorageManager */
      void NearestPointAlgorithmImplementationResult::load(StorageManager::Advocate & adv)
      {
        PersistentObject::load(adv);
        adv.loadAttribute( "minimizer_", minimizer_ );
        adv.loadAttribute( "iterationsNumber_", iterationsNumber_ );
        adv.loadAttribute( "absoluteError_", absoluteError_ );
        adv.loadAttribute( "relativeError_", relativeError_ );
        adv.loadAttribute( "residualError_", residualError_ );
        adv.loadAttribute( "constraintError_", constraintError_ );
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */
