//                                               -*- C++ -*-
/**
 * @file  SobolIndicesResult.hxx
 * @brief SobolIndicesResult implements computation of correlation coefficients
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: SobolIndicesResult.hxx 1473 2010-02-04 15:44:49Z dutka $
 */

#ifndef OPENTURNS_SOBOLINDICESRESULT_HXX
#define OPENTURNS_SOBOLINDICESRESULT_HXX

#include "OTprivate.hxx"
#include "NumericalSample.hxx"
#include "NumericalPoint.hxx"
#include "NumericalMathFunction.hxx"
#include "SymmetricTensor.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {
      /**
       * @class SobolIndicesResult
       *      Stores every Sobol' indices
       */
      class SobolIndicesResult
        : public Common::PersistentObject
      {
        CLASSNAME;

      public :
        typedef Type::NumericalPoint  NumericalPoint;
        typedef Type::SymmetricMatrix SymmetricMatrix;
        typedef Type::SymmetricTensor SymmetricTensor;

        /** default constructor */
        SobolIndicesResult();

        /** Virtual constructor */
        virtual SobolIndicesResult * clone() const;

        /** first order Sobol' indices accessor */
        NumericalPoint getFirstOrderIndice() const;
        void setFirstOrderIndice(NumericalPoint & firstOrderIndice);

        /** second order Sobol' indices accessor */
        SymmetricMatrix getSecondOrderIndice() const;
        void setSecondOrderIndice(const SymmetricMatrix & secondOrderIndice);

        /** third order Sobol' indices accessor */
        SymmetricTensor getThirdOrderIndice() const;
        void setThirdOrderIndice(const SymmetricTensor & thirdOrderIndice);

        /** total order (order = dimension - 1) Sobol' indices accessor */
        NumericalPoint getTotalOrderIndice() const;
        void setTotalOrderIndice(const NumericalPoint & totalOrderIndice);

        /** String converter */
        String __repr__() const;

      protected :
        NumericalPoint  firstOrderIndice_;
        SymmetricMatrix secondOrderIndice_;
        SymmetricTensor thirdOrderIndice_;
        NumericalPoint  totalOrderIndice_;

      } ; // class SobolIndicesResult

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SOBOLINDICESRESULT_HXX */
