//                                               -*- C++ -*-
/**
 *  @file  SORM.cxx
 *  @brief SORM implements the Second Order Reliability Method
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: SORM.cxx 1866 2011-04-11 10:32:27Z schueller $
 */

#include "SORM.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(SORM);

      static Base::Common::Factory< SORM > RegisteredFactory("SORM");

      /* Default constructor for the save/load mechanism */
      SORM::SORM()
        : Analytical(),
          sormResult_()
      {
        // Nothing to do
      }

      /*
       * @brief  Standard constructor: the class is defined by an optimisation algorithm, a failure event and a physical starting point
       */
      SORM::SORM(const NearestPointAlgorithm & nearestPointAlgorithm,
                 const Event & event,
                 const NumericalPoint & physicalStartingPoint):
        Analytical(nearestPointAlgorithm, event, physicalStartingPoint),
        sormResult_()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      SORM * SORM::clone() const
      {
        return new SORM(*this);
      }

      /* Result accessor */
      SORMResult SORM::getResult() const
      {
        return sormResult_;
      }

      /* Result accessor */
      void SORM::setResult(const SORMResult & sormResult)
      {
        sormResult_ = sormResult;
      }

      /* String converter */
      String SORM::__repr__() const
      {
        OSS oss;
        oss << "class=" << SORM::GetClassName()
            << " " << Analytical::__repr__()
            << " result=" << sormResult_;
        return oss;
      }

      /* Function that computes the design point by re-using the Analytical::run() and creates a SORMResult */
      void SORM::run()
      {
        Analytical::run();
        sormResult_ = SORMResult(Analytical::getAnalyticalResult().getStandardSpaceDesignPoint(), Analytical::getAnalyticalResult().getLimitStateVariable(), Analytical::getAnalyticalResult().getIsStandardPointOriginInFailureSpace());
      }


      /* Method save() stores the object through the StorageManager */
      void SORM::save(StorageManager::Advocate & adv) const
      {

        Analytical::save(adv);
        adv.saveAttribute("sormResult_", sormResult_);
      }

      /* Method load() reloads the object from the StorageManager */
      void SORM::load(StorageManager::Advocate & adv)
      {
        Analytical::load(adv);
        adv.loadAttribute("sormResult_", sormResult_);
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

