//                                               -*- C++ -*-
/**
 *  @file  SORM.hxx
 *  @brief SORM implements the First Order Reliability Method
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: SORM.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_SORM_HXX
#define OPENTURNS_SORM_HXX

#include "Analytical.hxx"
#include "Event.hxx"
#include "SquareMatrix.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"
#include "SORMResult.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class SORM
       * SORM implements the Second Order Reliability Method
       * and compute the results of such kind of analyses
       */

      class SORM :
        public Analytical
      {

        CLASSNAME;
      public:

        typedef Analytical::NumericalPoint        NumericalPoint;
        typedef Analytical::Event                 Event;
        typedef Analytical::Sensitivity           Sensitivity;
        typedef Analytical::NearestPointAlgorithm NearestPointAlgorithm;
        typedef Base::Type::SquareMatrix          SquareMatrix;
        typedef Model::Distribution               Distribution;
        typedef Base::Common::NotDefinedException NotDefinedException;

        /** Default constructor */
        SORM();

        /** Constructor with parameters */
        SORM(const NearestPointAlgorithm & nearestPointAlgorithm,
             const Event & event,
             const NumericalPoint & physicalStartingPoint);


        /** Virtual constructor */
        virtual SORM * clone() const;

        /** Result accessor */
        SORMResult getResult() const;

        /** Result accessor */
        void setResult(const SORMResult & sormResult);

        /** String converter */
        String __repr__() const;

        /** Function that computes the design point by re-using the Analytical::run() and creates a SORM::Result */
        void run();

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      private:

        SORMResult sormResult_;

      } ; /* class SORM */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SORM_HXX */
