//                                               -*- C++ -*-
/**
 *  @file  Experiment.hxx
 *  @brief Abstract top-level view of an experiment plane
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Experiment.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_EXPERIMENT_HXX
#define OPENTURNS_EXPERIMENT_HXX

#include "TypedInterfaceObject.hxx"
#include "ExperimentImplementation.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class Experiment
       *
       * The class describes the probabilistic concept of experiment plan
       */
      class Experiment
        : public Base::Common::TypedInterfaceObject<ExperimentImplementation>
      {
        CLASSNAME;
      public:
        typedef ExperimentImplementation::NumericalSample NumericalSample;
        typedef ExperimentImplementation::Implementation  Implementation;

        /** Default constructor */
        explicit Experiment(const String & name = OT::DefaultName);

        /** Constructor from implementation */
        Experiment(const ExperimentImplementation & implementation,
                   const String & name = OT::DefaultName);

#ifndef SWIG
        /** Constructor from implementation pointer */
        Experiment(const Implementation & p_implementation,
                   const String & name = OT::DefaultName);
#endif

        /** String converter */
        virtual String __repr__() const;

        /** Sample generation */
        virtual NumericalSample generate();

        /** Implementation accessor */
        void setImplementation(const Implementation & p_implementation);

      }; /* class Experiment */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_EXPERIMENT_HXX */
