//                                               -*- C++ -*-
/**
 *  @file  MonteCarloExperiment.cxx
 *  @brief Abstract top-level view of an monteCarloExperiment plane
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: MonteCarloExperiment.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include "MonteCarloExperiment.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      CLASSNAMEINIT(MonteCarloExperiment);

      /* Default constructor */
      MonteCarloExperiment::MonteCarloExperiment(const String & name):
        WeightedExperiment(name)
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      MonteCarloExperiment::MonteCarloExperiment(const UnsignedLong size,
                                                 const String & name):
        WeightedExperiment(size, name)
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      MonteCarloExperiment::MonteCarloExperiment(const Distribution & distribution,
                                                 const UnsignedLong size,
                                                 const String & name):
        WeightedExperiment(distribution, size, name)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      MonteCarloExperiment * MonteCarloExperiment::clone() const
      {
        return new MonteCarloExperiment(*this);
      }

      /* String converter */
      String MonteCarloExperiment::__repr__() const
      {
        OSS oss;
        oss << "class=" << GetClassName()
            << " name=" << getName()
            << " distribution=" << distribution_
            << " size=" << size_;
        return oss;
      }

      /* Sample generation */
      MonteCarloExperiment::NumericalSample MonteCarloExperiment::generate()
      {
        return distribution_.getNumericalSample(size_);
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
