//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalDistributionHessian.hxx
 *  @brief Class for the InverseNataf transformation hessian for elliptical
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: InverseNatafEllipticalDistributionHessian.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONHESSIAN_HXX
#define OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONHESSIAN_HXX

#include "OTprivate.hxx"
#include "ConstantNumericalMathHessianImplementation.hxx"
#include "StorageManager.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class InverseNatafEllipticalDistributionHessian
       *
       * This class offers an interface for the InverseNataf gradient for elliptical distributions
       */
      class InverseNatafEllipticalDistributionHessian
        : public Base::Func::ConstantNumericalMathHessianImplementation
      {
        CLASSNAME;
      public:

        typedef Base::Func::ConstantNumericalMathHessianImplementation ConstantNumericalMathHessianImplementation;
        typedef Base::Common::StorageManager                           StorageManager;

        /** Default constructor */
        InverseNatafEllipticalDistributionHessian();

        /** Parameter constructor */
        InverseNatafEllipticalDistributionHessian(const UnsignedLong dimension);


        /** String converter */
        virtual String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:


      private:

      }; /* InverseNatafEllipticalDistributionHessian */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INVERSENATAFELLIPTICALDISTRIBUTIONHESSIAN_HXX */
