//                                               -*- C++ -*-
/**
 *  @file  SequentialStrategy.hxx
 *  @brief An implementation returning the set of polynomials in sequence
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_SEQUENTIALSTRATEGY_HXX
#define OPENTURNS_SEQUENTIALSTRATEGY_HXX

#include "AdaptiveStrategyImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class SequentialStrategy
       *
       * An implementation returning the set of polynomials in sequence
       */

      class SequentialStrategy
        : public AdaptiveStrategyImplementation
      {
        CLASSNAME;
      public:

        typedef Base::Common::StorageManager StorageManager;

        /** Constructor from an orthogonal basis */
        SequentialStrategy(const OrthogonalBasis & basis,
                           const UnsignedLong maximumDimension,
                           const Bool verbose = false);

        /** Virtual constructor */
        virtual SequentialStrategy * clone() const;

        /** Compute initial basis for the approximation */
        void computeInitialBasis();

        /** Update the basis for the next iteration of approximation */
        void updateBasis(const NumericalPoint & alpha_k_p_,
                         const NumericalScalar residual_p_,
                         const NumericalScalar relativeError_p_);

        /** String converter */
        virtual String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);


      protected:

        friend class Base::Common::Factory<SequentialStrategy>;

        /** Default constructor */
        SequentialStrategy();

      private:
        // Index of the next vector to be generated
        UnsignedLong currentVectorIndex_;

        // Verbose
        Bool verbose_;

      } ; /* class SequentialStrategy */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SEQUENTIALSTRATEGY_HXX */
