//                                               -*- C++ -*-
/**
 *  @file  OrthogonalFunctionFactory.cxx
 *  @brief This is an abstract class for orthogonal basis
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "OrthogonalFunctionFactory.hxx"
#include "OSS.hxx"
#include "PersistentObjectFactory.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(OrthogonalFunctionFactory);

      static Base::Common::Factory<OrthogonalFunctionFactory> RegisteredFactory("OrthogonalFunctionFactory");

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;

      /* Default constructor */
      OrthogonalFunctionFactory::OrthogonalFunctionFactory()
        : Base::Common::PersistentObject(),
          measure_()
      {
        // Nothing to do
      }


      /* Virtual constructor */
      OrthogonalFunctionFactory * OrthogonalFunctionFactory::clone() const
      {
        return new OrthogonalFunctionFactory(*this);
      }


      /* Build the NumericalMathFunction of the given index */
      OrthogonalFunctionFactory::NumericalMathFunction OrthogonalFunctionFactory::build(const UnsignedLong index) const
      {
        throw NotYetImplementedException(HERE);
      }


      /* Return the measure upon which the basis is orthogonal */
      OrthogonalFunctionFactory::Distribution OrthogonalFunctionFactory::getMeasure() const
      {
        return measure_;
      }

      /* Return the enumerate function that translate unidimensional indices nto multidimensional indices */
      EnumerateFunction OrthogonalFunctionFactory::getEnumerateFunction() const
      {
        throw NotYetImplementedException(HERE);
      }


      /* String converter */
      String OrthogonalFunctionFactory::__repr__() const
      {
        return OSS() << "class=" << getClassName()
                     << " measure=" << measure_;
      }

      /* Method save() stores the object through the StorageManager */
      void OrthogonalFunctionFactory::save(StorageManager::Advocate & adv) const
      {
        PersistentObject::save(adv);
        adv.saveAttribute( "measure_", measure_ );
        adv.saveAttribute( "enumerateFunction_", enumerateFunction_ );
      }


      /* Method load() reloads the object from the StorageManager */
      void OrthogonalFunctionFactory::load(StorageManager::Advocate & adv)
      {
        PersistentObject::load(adv);
        adv.loadAttribute( "measure_", measure_ );
        adv.loadAttribute( "enumerateFunction_", enumerateFunction_ );
      }


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
