//                                               -*- C++ -*-
/**
 *  @file  OrthogonalProductPolynomialFactory.hxx
 *  @brief This is the orthogonal polynomial basis
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_ORTHOGONALPRODUCTPOLYNOMIALFACTORY_HXX
#define OPENTURNS_ORTHOGONALPRODUCTPOLYNOMIALFACTORY_HXX

#include "OrthogonalFunctionFactory.hxx"
#include "Distribution.hxx"
#include "Indices.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "NumericalMathFunction.hxx"
#include "PersistentCollection.hxx"
#include "OrthogonalUniVariatePolynomialFamily.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthogonalProductPolynomialFactory
       *
       * This is the orthogonal polynomial basis
       */

      class OrthogonalProductPolynomialFactory
        : public OrthogonalFunctionFactory
      {
        CLASSNAME;
      public:

        typedef Base::Common::StorageManager                                           StorageManager;
        typedef Base::Type::Collection<OrthogonalUniVariatePolynomialFamily>           PolynomialFamilyCollection;
        typedef Base::Type::PersistentCollection<OrthogonalUniVariatePolynomialFamily> PolynomialFamilyPersistentCollection;
        typedef Base::Func::NumericalMathFunction                                      NumericalMathFunction;
        typedef Base::Type::Indices                                                    Indices;
        typedef Base::Type::NumericalPoint                                             NumericalPoint;
        typedef Base::Stat::NumericalSample                                            NumericalSample;

        friend class Base::Common::Factory<OrthogonalProductPolynomialFactory>;

        /** Default constructor */
        OrthogonalProductPolynomialFactory();

        /** Constructor */
        OrthogonalProductPolynomialFactory(const PolynomialFamilyCollection & coll);

        /** Constructor */
        OrthogonalProductPolynomialFactory(const PolynomialFamilyCollection & coll,
                                           const EnumerateFunction & phi);

        /** Build the NumericalMathFunction of the given index */
        NumericalMathFunction build(const UnsignedLong index) const;

        /** Return the enumerate function that translate unidimensional indices nto multidimensional indices */
        EnumerateFunction getEnumerateFunction() const;

        /** Virtual constructor */
        OrthogonalProductPolynomialFactory * clone() const;

        /** Nodes and weights of the multivariate polynomial associated with the marginal degrees indices[0], ...,indices[dimension] as the tensor product of the marginal orthogonal univariate polynomials, to build multivariate quadrature rules */
        NumericalSample getNodesAndWeights(const Indices & degrees,
                                           NumericalPoint & weights) const;

        /** String converter */
        virtual String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);

      protected:

      private:
        /** Build the measure based on the one found in the family collection */
        void buildMeasure();

        /** The 1D polynomial family collection */
        PolynomialFamilyPersistentCollection coll_;

        /** The Phi function */
        EnumerateFunction phi_;

      } ; /* class OrthogonalProductPolynomialFactory */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ORTHOGONALPRODUCTPOLYNOMIALFACTORY_HXX */
