//                                               -*- C++ -*-
/**
 *  @file  OrthonormalizationAlgorithm.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-09-14 14:39:35 +0200 (lun. 14 sept. 2009) $
 *  Id:      $Id: OrthonormalizationAlgorithm.cxx 1331 2009-09-14 12:39:35Z dutka $
 */
#include "OrthonormalizationAlgorithm.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthonormalizationAlgorithm
       */

      CLASSNAMEINIT(OrthonormalizationAlgorithm);

      /* Constructor with parameters */
      OrthonormalizationAlgorithm::OrthonormalizationAlgorithm(const OrthonormalizationAlgorithmImplementation & implementation)
        : Base::Common::TypedInterfaceObject<OrthonormalizationAlgorithmImplementation>(implementation.clone())
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      OrthonormalizationAlgorithm::OrthonormalizationAlgorithm(Implementation & p_implementation)
        : Base::Common::TypedInterfaceObject<OrthonormalizationAlgorithmImplementation>(p_implementation)
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      OrthonormalizationAlgorithm::OrthonormalizationAlgorithm(const Distribution & measure)
        : Base::Common::TypedInterfaceObject<OrthonormalizationAlgorithmImplementation>(new OrthonormalizationAlgorithmImplementation(measure))
      {
        // Nothing to do
      }

      /* Constructor with parameters */
      OrthonormalizationAlgorithm::OrthonormalizationAlgorithm()
        : Base::Common::TypedInterfaceObject<OrthonormalizationAlgorithmImplementation>(new OrthonormalizationAlgorithmImplementation())
      {
        // Nothing to do
      }

      /* Calculate the coefficients of recurrence a0, a1, a2 such that
         Pn+1(x) = (a0 * x + a1) * Pn(x) + a2 * Pn-1(x) */
      OrthonormalizationAlgorithm::Coefficients OrthonormalizationAlgorithm::getRecurrenceCoefficients(const UnsignedLong n) const
      {
        return getImplementation()->getRecurrenceCoefficients(n);
      }

      /* Measure accessor */
      OrthonormalizationAlgorithm::Distribution OrthonormalizationAlgorithm::getMeasure() const
      {
        return getImplementation()->getMeasure();
      }

      void OrthonormalizationAlgorithm::setMeasure(const Distribution & measure)
      {
        getImplementation()->setMeasure(measure);
      }

      /* String converter */
      String OrthonormalizationAlgorithm::__repr__() const
      {
        return OSS() << "class=" << getClassName()
                     << " implementation=" << getImplementation()->__repr__();
      }

      /* String converter */
      String OrthonormalizationAlgorithm::__str__(const String & offset) const
      {
        return __repr__();
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
